/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.exec.api.low;

import graphql.language.DirectivesContainer;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStateDriver;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlFieldExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessor;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.QueryMapping;
import org.aksw.jenax.graphql.sparql.v2.io.ObjectNotationWriter;
import org.aksw.jenax.graphql.sparql.v2.util.BindingRemapped;
import org.aksw.jenax.graphql.sparql.v2.util.ExecutionContextUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.function.FunctionEnv;

public class GraphQlFieldExecImpl<K>
implements GraphQlFieldExec<K> {
    protected GraphQlProcessor<K> processor;
    protected final Query query;
    protected final QueryExec queryExec;
    protected final RowSet rs;
    protected FunctionEnv functionEnv;
    protected boolean isSingle;
    protected Map<?, Map<Var, Var>> stateVarMap;
    protected AccStateDriver<Binding, FunctionEnv, K, Node> driver;
    protected QueryMapping<K> queryMapping;
    protected boolean isFinished = false;

    public GraphQlFieldExecImpl(GraphQlProcessor<K> processor, boolean isSingle, Query query, QueryExec queryExec, Map<?, Map<Var, Var>> stateVarMap, AccStateDriver<Binding, FunctionEnv, K, Node> driver, QueryMapping<K> queryMapping) {
        this.processor = processor;
        this.isSingle = isSingle;
        this.query = query;
        this.queryExec = Objects.requireNonNull(queryExec);
        this.rs = Objects.requireNonNull(queryExec.select());
        this.functionEnv = ExecutionContextUtils.createFunctionEnv();
        this.stateVarMap = Objects.requireNonNull(stateVarMap);
        this.driver = Objects.requireNonNull(driver);
        this.queryMapping = queryMapping;
    }

    public Query getQuery() {
        return this.query;
    }

    @Override
    public GraphQlProcessor<K> getProcessor() {
        return this.processor;
    }

    @Override
    public boolean isSingle() {
        return this.isSingle;
    }

    public QueryExec getQueryExec() {
        return this.queryExec;
    }

    @Override
    public long sendRemainingItemsToWriter(ObjectNotationWriter<K, Node> writer) throws IOException {
        long[] result = new long[]{0L};
        this.driver.getContext().setWriter(writer);
        if (!this.isFinished) {
            if (!this.rs.hasNext()) {
                this.isFinished = true;
                boolean emittedItem = this.driver.end();
                if (emittedItem) {
                    result[0] = result[0] + 1L;
                }
            } else {
                this.rs.forEachRemaining(binding -> {
                    boolean emittedItem = this.processBinding((Binding)binding);
                    if (emittedItem) {
                        result[0] = result[0] + 1L;
                    }
                });
                boolean emittedItem2 = this.driver.end();
                if (emittedItem2) {
                    result[0] = result[0] + 1L;
                }
            }
        }
        return result[0];
    }

    private boolean processBinding(Binding binding) {
        boolean emittedItem;
        Object state = this.driver.getInputToStateId().apply(binding, this.functionEnv);
        Map<Var, Var> originalToEnum = this.stateVarMap.get(state);
        if (originalToEnum == null) {
            throw new IllegalStateException("No variable mapping obtained for state: " + String.valueOf(state));
        }
        Binding mappedBinding = BindingRemapped.of(binding, originalToEnum);
        try {
            emittedItem = this.driver.accumulate(mappedBinding, this.functionEnv);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return emittedItem;
    }

    @Override
    public boolean sendNextItemToWriter(ObjectNotationWriter<K, Node> writer) throws IOException {
        boolean result;
        this.driver.getContext().setWriter(writer);
        if (this.isFinished) {
            result = false;
        } else if (!this.rs.hasNext()) {
            this.isFinished = true;
            result = this.driver.end();
        } else {
            Binding binding;
            boolean completedObject = false;
            while (this.rs.hasNext() && !(completedObject = this.processBinding(binding = this.rs.next()))) {
            }
            if (!completedObject) {
                this.isFinished = true;
                result = this.driver.end();
            } else {
                result = true;
            }
        }
        return result;
    }

    @Override
    public void writeExtensions(ObjectNotationWriter<K, Node> writer, Function<String, K> stringToKey) throws IOException {
        DirectivesContainer container;
        graphql.language.Node<?> graphQlNode = this.queryMapping.fieldRewrite().graphQlNode();
        if (graphQlNode instanceof DirectivesContainer && (container = (DirectivesContainer)graphQlNode).hasDirective("debug")) {
            writer.name(stringToKey.apply("metadata"));
            writer.beginObject();
            writer.name(stringToKey.apply("sparqlQuery"));
            writer.value(NodeFactory.createLiteralString((String)Objects.toString(this.query)));
            writer.endObject();
        }
    }

    @Override
    public void close() {
        this.queryExec.close();
    }

    @Override
    public void abort() {
        this.queryExec.abort();
    }
}

