/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.exec.api.low;

import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccContext;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccState;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateBase;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.AccStateTypeProduceNode;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStateArrayInit;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStateDriver;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AccStateInit;
import org.aksw.jenax.graphql.sparql.v2.acc.state.api.impl.AggStateGon;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlFieldExec;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlFieldExecBuilder;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlFieldExecImpl;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.GraphQlProcessor;
import org.aksw.jenax.graphql.sparql.v2.exec.api.low.QueryMapping;
import org.aksw.jenax.graphql.sparql.v2.rewrite.Bind;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.function.FunctionEnv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlFieldExecBuilderImpl<K>
implements GraphQlFieldExecBuilder<K> {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlFieldExecBuilderImpl.class);
    private GraphQlProcessor<K> processor;
    private QueryMapping<K> mapping;
    private Creator<QueryExecBuilder> queryExecBuilderCreator;

    public GraphQlFieldExecBuilderImpl(GraphQlProcessor<K> processor, QueryMapping<K> mapping) {
        this.processor = processor;
        this.mapping = Objects.requireNonNull(mapping);
    }

    @Override
    public GraphQlFieldExecBuilder<K> service(Creator<QueryExecBuilder> queryExecBuilderCreator) {
        this.queryExecBuilderCreator = queryExecBuilderCreator;
        return this;
    }

    @Override
    public GraphQlFieldExec<K> build() {
        QueryExecBuilder queryExecBuilder = (QueryExecBuilder)this.queryExecBuilderCreator.create();
        Objects.requireNonNull(queryExecBuilder);
        Var stateVar = this.mapping.stateVar();
        Node rootStateId = this.mapping.rootStateId();
        Query query = this.mapping.query();
        Map<?, Map<Var, Var>> stateVarMap = this.mapping.stateVarMap();
        boolean isSingle = this.mapping.isSingle();
        AggStateGon<Binding, FunctionEnv, K, Node> agg = this.mapping.agg();
        BiFunction stateIdExtractor = Bind.var(stateVar).andThen(node -> node);
        AccContext cxt = new AccContext(null, false, true);
        AccState acc = agg.newAccumulator();
        AccStateTypeProduceNode tmp = (AccStateTypeProduceNode)acc;
        AccStateBase accInit = isSingle ? new AccStateInit(rootStateId, tmp) : new AccStateArrayInit(rootStateId, tmp);
        acc.setParent(accInit);
        AccStateDriver driver = AccStateDriver.of(cxt, accInit, true, stateIdExtractor);
        if (logger.isDebugEnabled()) {
            logger.debug("GraphQl Accumulator: " + String.valueOf(accInit));
            logger.debug("GraphQl SPARQL Query: " + String.valueOf(query));
        }
        QueryExec queryExec = queryExecBuilder.query(query).build();
        GraphQlFieldExecImpl<K> result = new GraphQlFieldExecImpl<K>(this.processor, isSingle, query, queryExec, stateVarMap, driver, this.mapping);
        return result;
    }
}

