/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql.v2.api2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.jenax.graphql.sparql.v2.api2.Connective;
import org.aksw.jenax.graphql.sparql.v2.api2.ElementTransform;
import org.aksw.jenax.graphql.sparql.v2.api2.QueryUtils;
import org.aksw.jenax.graphql.sparql.v2.api2.Selection;
import org.aksw.jenax.graphql.sparql.v2.api2.VarHelper;
import org.aksw.jenax.graphql.sparql.v2.model.ElementNode;
import org.aksw.jenax.graphql.sparql.v2.util.ElementUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_Coalesce;
import org.apache.jena.sparql.expr.E_Conditional;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_LogicalAnd;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class ElementGeneratorLateral {
    public static ElementMapping toLateral(boolean globalOrderBy, ElementNode rootField, Var stateVar) {
        LinkedHashMap<Node, Map<Var, Var>> stateVarMap = new LinkedHashMap<Node, Map<Var, Var>>();
        LinkedHashMap<Node, Map<Var, Var>> outStateOriginalToGlobalMap = new LinkedHashMap<Node, Map<Var, Var>>();
        ArrayList<Var> levelVars = new ArrayList<Var>();
        SortNode superRootSortNode = new SortNode(null, -1, NodeFactory.createLiteralString((String)rootField.getIdentifier()), new ArrayList<SortCondition>(), new ArrayList<SortNode>());
        Element element = ElementGeneratorLateral.toLateral(globalOrderBy, rootField, List.of(), stateVar, stateVarMap, outStateOriginalToGlobalMap, levelVars, List.of(), superRootSortNode);
        ArrayList<SortCondition> globalSortConditions = null;
        if (globalOrderBy) {
            List<SortNode> breadth = superRootSortNode.children();
            ArrayList<SortNode> nextBreadth = new ArrayList<SortNode>();
            globalSortConditions = new ArrayList<SortCondition>();
            for (Var levelVar : levelVars) {
                globalSortConditions.add(new SortCondition(levelVar, -2));
                for (SortNode sn : breadth) {
                    List<SortNode> children;
                    List<SortCondition> scs = sn.sortConditions();
                    List<Integer> pathIds = sn.getPath();
                    E_Equals idExpr = null;
                    for (int i = 0; i < pathIds.size(); ++i) {
                        Var lv = (Var)levelVars.get(i);
                        Integer levelId = pathIds.get(i);
                        E_Equals contrib = new E_Equals((Expr)new ExprVar(lv), (Expr)NodeValue.makeInteger((long)levelId.intValue()));
                        idExpr = idExpr == null ? contrib : new E_LogicalAnd((Expr)idExpr, (Expr)contrib);
                    }
                    if (!scs.isEmpty()) {
                        for (SortCondition sc : scs) {
                            SortCondition adaptedSc = new SortCondition((Expr)new E_Conditional((Expr)idExpr, sc.getExpression(), (Expr)new E_Coalesce(new ExprList())), sc.getDirection());
                            globalSortConditions.add(adaptedSc);
                        }
                    }
                    if ((children = sn.children()) == null) continue;
                    nextBreadth.addAll(children);
                }
                breadth = nextBreadth;
                nextBreadth = new ArrayList();
            }
        }
        return new ElementMapping(element, stateVarMap, globalSortConditions);
    }

    public static ElementNodeVarMapping harmonizeVariables(ElementNode elementNode, String prefix) {
        List<String> basePath = List.of(prefix);
        LinkedHashMap<Object, Map<Var, Var>> outStateVarMap = new LinkedHashMap<Object, Map<Var, Var>>();
        HashMap<Var, Var> parentRenames = new HashMap<Var, Var>();
        ElementNode node = ElementGeneratorLateral.harmonizeVariables(elementNode, basePath, parentRenames, outStateVarMap);
        return new ElementNodeVarMapping(node, outStateVarMap);
    }

    public static ElementNode harmonizeVariables(ElementNode elementNode, List<String> parentPath, Map<Var, Var> parentRenames, Map<Object, Map<Var, Var>> outStateVarMap) {
        List<Selection> children = elementNode.getSelections();
        List parentVars = Optional.ofNullable(elementNode.getJoinLink()).map(ElementNode.JoinLink::parentVars).orElse(null);
        String name = elementNode.getName();
        ArrayList<String> fieldPath = new ArrayList<String>(parentPath);
        fieldPath.add(name);
        String scopeName = fieldPath.size() == 1 ? "root" : fieldPath.subList(1, fieldPath.size()).stream().collect(Collectors.joining("_"));
        Connective connective = elementNode.getConnective();
        Element element = connective.getElement();
        Set<Var> mentionedVars = VarHelper.vars(element);
        Map originalToGlobal = outStateVarMap.computeIfAbsent(scopeName, k -> new LinkedHashMap());
        if (parentVars != null) {
            List<Var> connectVars = connective.getConnectVars();
            for (int i = 0; i < connectVars.size(); ++i) {
                Var connectVar = (Var)connectVars.get(i);
                Var parentVar = (Var)parentVars.get(i);
                Var var = originalToGlobal.computeIfAbsent(connectVar, v -> parentRenames.getOrDefault(parentVar, parentVar));
            }
        }
        for (Var var : mentionedVars) {
            originalToGlobal.computeIfAbsent(var, v -> Var.alloc((String)(scopeName + "_" + v.getName())));
        }
        Connective globalConnective = connective.applyNodeTransform((NodeTransform)new NodeTransformSubst(originalToGlobal));
        ElementNode resultNode = ElementNode.of(elementNode.getLabel(), globalConnective);
        List<Var> globalParentVars = parentVars != null ? parentVars.stream().map(originalToGlobal::get).toList() : null;
        for (Selection selection : elementNode.getSelections()) {
            if (!(selection instanceof ElementNode)) continue;
            ElementNode f = (ElementNode)selection;
            ElementNode childBuilder = ElementGeneratorLateral.harmonizeVariables(f, fieldPath, originalToGlobal, outStateVarMap);
            resultNode.addChild(globalParentVars, childBuilder);
        }
        return resultNode;
    }

    public static Var resolveAncestorVar(ElementNode elementNode, Map<Node, Map<Var, Var>> outStateVarMap, Var var) {
        String id = elementNode.getIdentifier();
        Node idNode = NodeFactory.createLiteralString((String)id);
        Map<Var, Var> localToGlobal = outStateVarMap.get(idNode);
        Objects.requireNonNull(localToGlobal, "Unexpectedly found no local-to-global variable mapping for state: " + String.valueOf(idNode));
        Var result = localToGlobal.get(var);
        if (result == null) {
            ElementNode.ParentLink parentLink = elementNode.getParentLink();
            result = parentLink == null ? null : ElementGeneratorLateral.resolveAncestorVar(parentLink.parent(), outStateVarMap, var);
        }
        return result;
    }

    public static Map<Var, Var> resolveVarMap(ElementNode elementNode, Map<Node, Map<Var, Var>> outStateVarMap, Expr expr) {
        Set vars = expr.getVarsMentioned();
        HashMap<Var, Var> localToGlobal = new HashMap<Var, Var>();
        for (Var var : vars) {
            Var resolvedVar = ElementGeneratorLateral.resolveAncestorVar(elementNode, outStateVarMap, var);
            if (resolvedVar == null) {
                throw new RuntimeException("Could not resolve variable: " + String.valueOf(var) + " in expression: " + String.valueOf(expr));
            }
            localToGlobal.put(var, resolvedVar);
        }
        return localToGlobal;
    }

    public static Expr resolveLocalVarsInExpr(ElementNode elementNode, Map<Node, Map<Var, Var>> outStateVarMap, Expr expr) {
        Map<Var, Var> localToGlobal = ElementGeneratorLateral.resolveVarMap(elementNode, outStateVarMap, expr);
        Expr result = ExprTransformer.transform((ExprTransform)new NodeTransformExpr((NodeTransform)new NodeTransformSubst(localToGlobal)), (Expr)expr);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static Element toLateral(boolean globalOrderBy, ElementNode node, List<String> parentPath, Var discriminatorVar, Map<Node, Map<Var, Var>> outStateVarMap, Map<Node, Map<Var, Var>> outStateOriginalToGlobalMap, List<Var> levelVars, List<Integer> parentPathIdx, SortNode thisSortNode) {
        void var35_44;
        ElementGroup g;
        ElementGroup elementGroup;
        ElementGroup eg;
        List<Selection> children = node.getSelections();
        boolean isLeaf = children.isEmpty();
        ElementNode.JoinLink joinLink = node.getJoinLink();
        String name = node.getName();
        ArrayList<String> fieldPath = new ArrayList<String>(parentPath);
        fieldPath.add(name);
        String scopeName = fieldPath.size() == 1 ? "root" : fieldPath.subList(1, fieldPath.size()).stream().collect(Collectors.joining("_"));
        String stateId = node.getIdentifier();
        if (stateId == null) {
            throw new IllegalArgumentException("Node had null for its identifier");
        }
        Node stateIdNode = NodeFactory.createLiteralString((String)stateId);
        NodeValue discriminatorValue = NodeValue.makeNode((Node)stateIdNode);
        Connective connective = node.getConnective();
        Element originalElement = connective.getElement();
        Set<Var> mentionedVars = VarHelper.vars(originalElement);
        LinkedHashSet<Object> projVars = new LinkedHashSet<Object>();
        projVars.add(discriminatorVar);
        Map originalToGlobal = outStateOriginalToGlobalMap.computeIfAbsent(stateIdNode, k -> new LinkedHashMap());
        int memberIdx = 0;
        int thisDepthIdx = -1;
        Var thisLevelVar = null;
        NodeValue thisLevelValNv = null;
        if (globalOrderBy) {
            thisDepthIdx = parentPathIdx.size();
            if (thisDepthIdx != 0) {
                thisLevelVar = levelVars.get(thisDepthIdx - 1);
                int thisLevelVal = parentPathIdx.get(thisDepthIdx - 1);
                thisLevelValNv = NodeValue.makeInteger((long)thisLevelVal);
            }
            while (thisDepthIdx > levelVars.size()) {
                levelVars.add(Var.alloc((String)("l_" + levelVars.size())));
            }
        }
        if (joinLink != null) {
            for (int i = 0; i < joinLink.size(); ++i) {
                Var connectVar = joinLink.childVars().get(i);
                Var parentVar = joinLink.parentVars().get(i);
                Var globalVar = ElementGeneratorLateral.resolveAncestorVar(node, outStateOriginalToGlobalMap, parentVar);
                originalToGlobal.computeIfAbsent(connectVar, v -> globalVar);
                projVars.add(globalVar);
            }
        }
        for (Var var : mentionedVars) {
            originalToGlobal.computeIfAbsent(var, v -> Var.alloc((String)(scopeName + "_" + v.getName())));
        }
        ElementGroup group = new ElementGroup();
        if (globalOrderBy && thisLevelVar != null) {
            group.addElement((Element)new ElementBind(thisLevelVar, thisLevelValNv));
        }
        if (isLeaf) {
            group.addElement((Element)new ElementBind(discriminatorVar, (Expr)discriminatorValue));
        }
        Connective globalConnective = connective.applyNodeTransform((NodeTransform)new NodeTransformSubst(originalToGlobal));
        Element finalElement = globalConnective.getElement();
        ArrayList<SortCondition> thisSortConditions = new ArrayList<SortCondition>();
        if (!(!globalOrderBy || finalElement instanceof ElementGroup && (eg = (ElementGroup)finalElement).isEmpty())) {
            Query subQuery;
            if (finalElement instanceof ElementSubQuery) {
                ElementSubQuery esq = (ElementSubQuery)finalElement;
                Query tmp = esq.getQuery();
                if (tmp.hasOrderBy()) {
                    Query query = tmp.cloneQuery();
                    thisSortConditions.addAll(query.getOrderBy());
                    query.getOrderBy().clear();
                    finalElement = new ElementSubQuery(query);
                    subQuery = query;
                } else {
                    subQuery = tmp;
                }
            } else {
                boolean disableSubQueryBecauseOfJenaIssue2896 = true;
                if (!disableSubQueryBecauseOfJenaIssue2896) {
                    subQuery = new Query();
                    subQuery.setQuerySelectType();
                    subQuery.setQueryResultStar(true);
                    subQuery.setDistinct(true);
                    subQuery.setQueryPattern(finalElement);
                } else {
                    subQuery = null;
                }
            }
            Set sortVars = thisSortConditions.stream().map(SortCondition::getExpression).map(Expr::getVarsMentioned).flatMap(Collection::stream).collect(Collectors.toSet());
            Set<Var> visibleVars = globalConnective.getVisibleVars();
            Iterator<Var> iterator = visibleVars.iterator();
            while (iterator.hasNext()) {
                Var visibleVar = iterator.next();
                if (Var.isBlankNodeVar((Node)visibleVar) || sortVars.contains(visibleVar)) continue;
                thisSortConditions.add(new SortCondition((Expr)new ExprVar(visibleVar), -2));
            }
            if (subQuery != null) {
                finalElement = new ElementSubQuery(subQuery);
            }
        }
        ElementUtils.copyElements(group, finalElement);
        node.getBinds().forEachExpr((v, e) -> {
            Var resolvedVar = originalToGlobal.computeIfAbsent(v, vv -> Var.alloc((String)(scopeName + "_" + vv.getName())));
            Expr resolvedExpr = ElementGeneratorLateral.resolveLocalVarsInExpr(node, outStateOriginalToGlobalMap, e);
            group.addElement((Element)new ElementBind(resolvedVar, resolvedExpr));
        });
        int i = 0;
        LinkedHashMap<Var, Var> globalToEnum = new LinkedHashMap<Var, Var>();
        Map originalToEnum = outStateVarMap.computeIfAbsent(stateIdNode, k -> new LinkedHashMap());
        originalToEnum.put(discriminatorVar, discriminatorVar);
        for (Map.Entry entry : originalToGlobal.entrySet()) {
            Var originalVar = (Var)entry.getKey();
            Var globalVar = (Var)entry.getValue();
            Var enumVar = Var.alloc((String)("v_" + i));
            globalToEnum.put(globalVar, enumVar);
            originalToEnum.put(originalVar, enumVar);
            ++i;
        }
        projVars.addAll(originalToEnum.values());
        if (globalOrderBy) {
            // empty if block
        }
        if (isLeaf) {
            globalToEnum.forEach((from, to) -> group.addElement((Element)new ElementBind(to, (Expr)new ExprVar(from))));
            if (globalOrderBy) {
                thisSortNode.sortConditions().addAll(thisSortConditions);
            }
        }
        ElementGroup primary = group;
        for (ElementTransform transform : node.getLocalTransforms()) {
            Element tmp = (Element)transform.apply(primary);
            primary = tmp;
        }
        ElementGroup elementGroup2 = elementGroup = (primary = ElementGeneratorLateral.applySlice((Element)primary, node.getOffset(), node.getLimit())) instanceof ElementGroup ? (g = primary) : ElementUtils.createElementGroup(new Element[]{primary});
        if (!isLeaf) {
            if (elementGroup.size() > 1) {
                ElementGroup tmp = new ElementGroup();
                tmp.addElement((Element)elementGroup);
                ElementGroup elementGroup3 = tmp;
            }
            ArrayList<Element> members = new ArrayList<Element>();
            ArrayList<ElementBind> headElts = new ArrayList<ElementBind>();
            headElts.add(new ElementBind(discriminatorVar, (Expr)discriminatorValue));
            if (globalOrderBy) {
                while (thisDepthIdx >= levelVars.size()) {
                    levelVars.add(Var.alloc((String)("l_" + levelVars.size())));
                }
                Var nextLevelVar = levelVars.get(thisDepthIdx);
                headElts.add(new ElementBind(nextLevelVar, (Expr)NodeValue.makeInteger((long)memberIdx)));
                SortNode childSortNode = new SortNode(thisSortNode, memberIdx, stateIdNode, new ArrayList<SortCondition>(), new ArrayList<SortNode>());
                thisSortNode.children().add(childSortNode);
                thisSortNode.sortConditions().addAll(thisSortConditions);
                ++memberIdx;
            }
            globalToEnum.forEach((from, to) -> headElts.add(new ElementBind(to, (Expr)new ExprVar(from))));
            Element head = ElementUtils.groupIfNeeded(headElts);
            members.add(head);
            for (Selection selection : node.getSelections()) {
                if (!(selection instanceof ElementNode)) continue;
                ElementNode f = (ElementNode)selection;
                ArrayList<Integer> childPathIdx = null;
                SortNode childSortNode = null;
                if (globalOrderBy) {
                    Node childStateId = NodeFactory.createLiteralString((String)f.getIdentifier());
                    childPathIdx = new ArrayList<Integer>(parentPath.size() + 1);
                    childPathIdx.addAll(parentPathIdx);
                    childPathIdx.add(memberIdx);
                    childSortNode = new SortNode(thisSortNode, memberIdx, childStateId, new ArrayList<SortCondition>(), new ArrayList<SortNode>());
                    thisSortNode.children().add(childSortNode);
                    ++memberIdx;
                }
                Element contrib = ElementGeneratorLateral.toLateral(globalOrderBy, f, fieldPath, discriminatorVar, outStateVarMap, outStateOriginalToGlobalMap, levelVars, childPathIdx, childSortNode);
                members.add(contrib);
            }
            Element union = ElementUtils.unionIfNeeded(members);
            ElementLateral lateral = new ElementLateral(union);
            var35_44.addElement((Element)lateral);
        }
        Element result = var35_44;
        for (ElementTransform transform : node.getTreeTransforms()) {
            Element tmp;
            result = tmp = (Element)transform.apply(result);
        }
        return result;
    }

    public static Element applySlice(Element elt, Long offset, Long limit) {
        Element result = elt;
        if (limit != null || offset != null) {
            Query query = QueryUtils.elementToQuery(elt);
            if (limit != null) {
                query.setLimit(limit.longValue());
            }
            if (offset != null) {
                query.setOffset(offset.longValue());
            }
            result = new ElementSubQuery(query);
        }
        return result;
    }

    public record SortNode(SortNode parent, int localIdx, Node stateId, List<SortCondition> sortConditions, List<SortNode> children) {
        public List<Integer> getPath() {
            ArrayList<Integer> result = new ArrayList<Integer>();
            this.collectPath(result);
            return result;
        }

        private void collectPath(List<Integer> out) {
            if (this.parent != null) {
                if (this.parent.parent != null) {
                    this.parent.collectPath(out);
                }
                out.add(this.localIdx);
            }
        }

        @Override
        public final String toString() {
            return String.valueOf(this.getPath()) + ": " + String.valueOf(this.sortConditions);
        }
    }

    public record ElementMapping(Element element, Map<Node, Map<Var, Var>> stateVarMap, List<SortCondition> sortConditions) {
    }

    public record ElementNodeVarMapping(ElementNode node, Map<Object, Map<Var, Var>> stateVarMap) {
    }
}

