/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.graphql.sparql.AsyncCombiner;
import org.aksw.jenax.model.voidx.api.VoidDataset;
import org.aksw.jenax.model.voidx.util.VoidUtils;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatasetMetadata {
    private static final Logger logger = LoggerFactory.getLogger(DatasetMetadata.class);
    protected static final Query classPartitionsQuery = SparqlStmtMgr.loadQuery((String)"void/minimal/class-partitions.rq");
    protected static final Query propertyPartitionsQuery = SparqlStmtMgr.loadQuery((String)"void/minimal/property-partitions.rq");
    public static final List<Query> defaultVoidQueries = List.of(classPartitionsQuery, propertyPartitionsQuery);
    public static final List<Query> defaultShaclQueries = List.copyOf(SparqlStmtMgr.loadQueries((String)"sh-scalar-properties.rq"));
    protected VoidDataset voidDataset;
    protected Model shaclModel;

    public DatasetMetadata(VoidDataset voidDataset, Model shaclModel) {
        this.voidDataset = voidDataset;
        this.shaclModel = shaclModel;
    }

    public VoidDataset getVoidDataset() {
        return this.voidDataset;
    }

    public Model getShaclModel() {
        return this.shaclModel;
    }

    public static Model combine(List<Model> models) {
        Model result = ModelFactory.createDefaultModel();
        models.stream().forEach(arg_0 -> ((Model)result).add(arg_0));
        return result;
    }

    public static ListenableFuture<Model> asyncModel(ListeningExecutorService executorService, QueryExecutionFactoryQuery qef, List<Query> constructQueries) {
        AsyncCombiner<Model, Model> combiner = AsyncCombiner.of(executorService, DatasetMetadata::combine);
        for (Query query : constructQueries) {
            combiner.addTask(() -> {
                Model r;
                try {
                    r = qef.execConstruct(query);
                }
                catch (Exception e) {
                    logger.info("Query execution failed: " + String.valueOf(query));
                    throw new RuntimeException(e);
                }
                return r;
            });
        }
        return combiner.exec();
    }

    public static ListenableFuture<String> fetchDatasetHash(RDFDataSource dataSource, ListeningExecutorService executorService) {
        ListenableFuture datasetHashFuture = executorService.submit(() -> RDFDataSources.fetchDatasetHash((RDFDataSource)dataSource));
        return datasetHashFuture;
    }

    public static DatasetMetadata of(Model voidModel, Model shaclModel) {
        List voidDatasets = VoidUtils.listVoidDatasets((Model)voidModel);
        VoidDataset voidDataset = (VoidDataset)IterableUtils.expectZeroOrOneItems((Iterable)voidDatasets);
        if (voidDataset == null) {
            voidDataset = (VoidDataset)ModelFactory.createDefaultModel().createResource().as(VoidDataset.class);
        }
        return new DatasetMetadata(voidDataset, shaclModel);
    }

    public static DatasetMetadata fetch(RDFDataSource dataSource) {
        return DatasetMetadata.fetch(dataSource, defaultVoidQueries, defaultShaclQueries);
    }

    public static ListenableFuture<DatasetMetadata> fetch(RDFDataSource dataSource, ListeningExecutorService executorService) {
        List<Query> voidQueries = Arrays.asList(classPartitionsQuery, propertyPartitionsQuery);
        return DatasetMetadata.fetch(dataSource, executorService, voidQueries, defaultShaclQueries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DatasetMetadata fetch(RDFDataSource dataSource, List<Query> voidQueries, List<Query> shaclQueries) {
        DatasetMetadata result;
        if (voidQueries == null) {
            voidQueries = defaultVoidQueries;
        }
        if (shaclQueries == null) {
            shaclQueries = defaultShaclQueries;
        }
        ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool())));
        try {
            ListenableFuture<DatasetMetadata> future = DatasetMetadata.fetch(dataSource, executorService, voidQueries, shaclQueries);
            try {
                result = (DatasetMetadata)future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        finally {
            executorService.shutdown();
            try {
                executorService.awaitTermination(60L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static ListenableFuture<DatasetMetadata> fetch(RDFDataSource dataSource, ListeningExecutorService executorService, List<Query> voidQueries, List<Query> shaclQueries) {
        QueryExecutionFactory qef = dataSource.asQef();
        ListenableFuture<Model> voidModelFuture = DatasetMetadata.asyncModel(executorService, (QueryExecutionFactoryQuery)qef, voidQueries);
        ListenableFuture<Model> shaclModelFuture = DatasetMetadata.asyncModel(executorService, (QueryExecutionFactoryQuery)qef, shaclQueries);
        ListenableFuture result = Futures.whenAllSucceed((ListenableFuture[])new ListenableFuture[]{voidModelFuture, shaclModelFuture}).call(() -> {
            Model voidModel = (Model)voidModelFuture.get();
            Model shaclModel = (Model)shaclModelFuture.get();
            return DatasetMetadata.of(voidModel, shaclModel);
        }, (Executor)executorService);
        return result;
    }
}

