/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.impl.common;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.aksw.jenax.graphql.impl.common.GraphQlExecUtils;
import org.aksw.jenax.graphql.json.api.GraphQlDataProvider;
import org.aksw.jenax.graphql.json.api.GraphQlExec;

public class GraphQlResultWriterImpl {
    protected Gson gson;

    protected GraphQlResultWriterImpl(Gson gson) {
        this.gson = gson;
    }

    public Gson getGson() {
        return this.gson;
    }

    public void write(OutputStream out, GraphQlExec exec) throws IOException {
        JsonWriter writer = this.gson.newJsonWriter((Writer)new OutputStreamWriter(out, StandardCharsets.UTF_8));
        this.write(writer, exec);
        writer.flush();
    }

    public void write(JsonWriter writer, GraphQlExec exec) throws IOException {
        writer.beginObject();
        writer.name("data");
        writer.beginObject();
        for (GraphQlDataProvider dataProvider : exec.getDataProviders()) {
            String name = dataProvider.getName();
            writer.name(name);
            boolean isSingle = dataProvider.isSingle();
            if (!isSingle) {
                writer.beginArray();
            }
            dataProvider.write(writer, this.gson);
            if (isSingle) continue;
            writer.endArray();
        }
        writer.endObject();
        writer.name("errors");
        writer.beginArray();
        writer.endArray();
        JsonObject metadata = GraphQlExecUtils.collectExtensions(exec);
        if (!metadata.keySet().isEmpty()) {
            writer.name("extensions");
            this.gson.toJson((JsonElement)metadata, writer);
        }
        writer.endObject();
    }
}

