/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AsyncCombiner<I, O> {
    protected ListeningExecutorService executorService;
    protected Function<List<I>, O> combiner;
    protected List<Callable<I>> tasks = new ArrayList<Callable<I>>();

    protected AsyncCombiner(ListeningExecutorService executorService, Function<List<I>, O> combiner) {
        this.executorService = Objects.requireNonNull(executorService, "executorService must not be null");
        this.combiner = Objects.requireNonNull(combiner, "combiner must not be null");
    }

    public static <I, O> AsyncCombiner<I, O> of(ExecutorService executorService, Function<List<I>, O> combiner) {
        return AsyncCombiner.of(MoreExecutors.listeningDecorator((ExecutorService)executorService), combiner);
    }

    public static <I, O> AsyncCombiner<I, O> of(ListeningExecutorService executorService, Function<List<I>, O> combiner) {
        return new AsyncCombiner<I, O>(executorService, combiner);
    }

    public AsyncCombiner<I, O> addTask(Callable<I> task) {
        this.tasks.add(task);
        return this;
    }

    public ListenableFuture<O> exec() {
        List futures = this.tasks.stream().map(arg_0 -> ((ListeningExecutorService)this.executorService).submit(arg_0)).collect(Collectors.toList());
        ListenableFuture result = Futures.transform((ListenableFuture)Futures.allAsList(futures), this.combiner::apply, (Executor)this.executorService);
        return result;
    }
}

