/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Range;
import graphql.language.Argument;
import graphql.language.ArrayValue;
import graphql.language.Directive;
import graphql.language.DirectivesContainer;
import graphql.language.Document;
import graphql.language.EnumValue;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.InlineFragment;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.language.OperationDefinition;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import graphql.language.StringValue;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.util.range.RangeUtils;
import org.aksw.facete.v3.api.ConstraintFacade;
import org.aksw.jenax.arq.util.node.PathUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.impl.NodeQueryImpl;
import org.aksw.jenax.graphql.sparql.Cardinality;
import org.aksw.jenax.graphql.sparql.Context;
import org.aksw.jenax.graphql.sparql.GraphQlResolver;
import org.aksw.jenax.graphql.sparql.GraphQlToSparqlMapping;
import org.aksw.jenax.graphql.sparql.GraphQlUtils;
import org.aksw.jenax.graphql.sparql.ScopedCardinality;
import org.aksw.jenax.io.json.graph.GraphToJsonMapperNode;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperFragmentBody;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperFragmentHead;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperLiteral;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperObject;
import org.aksw.jenax.io.json.graph.GraphToJsonNodeMapperObjectLike;
import org.aksw.jenax.io.json.graph.GraphToJsonPropertyMapper;
import org.aksw.jenax.model.shacl.domain.ShPropertyShape;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.MappedFragment;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.stmt.core.SparqlParserConfig;
import org.aksw.jenax.stmt.parser.query.SparqlQueryParserImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.PrefixMappingAdapter;
import org.apache.jena.sparql.path.P_Link;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlToSparqlConverter {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlToSparqlConverter.class);
    protected GraphQlResolver resolver;
    protected boolean jsonMode;

    public GraphQlToSparqlConverter(GraphQlResolver resolver, boolean jsonMode) {
        this.resolver = resolver;
        this.jsonMode = jsonMode;
    }

    public GraphQlToSparqlMapping convertDocument(Document document, Map<String, Value<?>> assignments) {
        GraphQlToSparqlMapping result = new GraphQlToSparqlMapping(document);
        new GraphQlQueryWorker(document, assignments).convertDocument(result);
        return result;
    }

    public static Context setupContext(Context cxt) {
        Field field = cxt.getField();
        List rdfDirectives = field.getDirectives("rdf");
        for (Directive rdf : rdfDirectives) {
            String baseContrib = GraphQlUtils.toString(GraphQlUtils.getValue(rdf.getArgument("base")));
            String iriContrib = GraphQlUtils.toString(GraphQlUtils.getValue(rdf.getArgument("iri")));
            String nsContrib = GraphQlUtils.toString(GraphQlUtils.getValue(rdf.getArgument("ns")));
            PrefixMap prefixMapContrib = GraphQlToSparqlConverter.tryGetPrefixMap(GraphQlUtils.getValue(rdf.getArgument("prefixes")));
            if (baseContrib != null) {
                cxt.setBase(baseContrib);
            }
            if (iriContrib != null) {
                cxt.setIri(iriContrib);
            }
            if (nsContrib != null) {
                cxt.setNs(nsContrib);
            }
            if (prefixMapContrib == null) continue;
            cxt.setLocalPrefixMap(prefixMapContrib);
        }
        ScopedCardinality scopedCardinality = GraphQlToSparqlConverter.getCardinality(field);
        if (scopedCardinality != null) {
            Cardinality cardinality = scopedCardinality.getCardinality();
            if (scopedCardinality.isSelf()) {
                cxt.setThisCardinality(cardinality);
            }
            if (scopedCardinality.isCascade()) {
                cxt.setInheritedCardinality(cardinality);
            }
        }
        cxt.update();
        return cxt;
    }

    public static String deriveFieldIri(Context context, String fieldName) {
        Object result = null;
        String base = context.getFinalBase();
        String ns = context.getFinalNs();
        String iri = context.getFinalIri();
        if (base != null && !base.isBlank()) {
            result = base + fieldName;
        }
        String namespace = null;
        if (ns != null) {
            namespace = ns;
        }
        if (namespace != null) {
            result = namespace + fieldName;
        }
        if (iri != null) {
            result = iri;
        }
        return result;
    }

    public static void processSparqlDirectives(Context cxt, GraphQlResolver resolver) {
        Field field = cxt.getField();
        String fieldName = field.getName();
        NodeQuery nodeQuery = cxt.getNodeQuery();
        FacetPath facetPath = nodeQuery.getFacetPath();
        ArrayList<Fragment1> filterRelations = new ArrayList<Fragment1>();
        for (Directive dir : field.getDirectives()) {
            Fragment contrib = null;
            boolean isInject = false;
            if ("sparql".equals(dir.getName())) {
                contrib = GraphQlToSparqlConverter.tryParseSparqlQuery(cxt, dir, "fragment");
                if (contrib == null && (contrib = GraphQlToSparqlConverter.tryParseSparqlQuery(cxt, dir, "inject")) != null) {
                    isInject = true;
                }
            } else if ("class".equals(dir.getName())) {
                Node classNode = GraphQlToSparqlConverter.resolveClass(resolver, cxt, fieldName);
                String fieldIri = classNode.getURI();
                contrib = ConceptUtils.createForRdfType((String)fieldIri);
            }
            if (contrib == null) continue;
            if (isInject) {
                HashMap<Var, Node> varMap = new HashMap<Var, Node>();
                for (Var v : contrib.getVars()) {
                    Node jenaNode;
                    Context match;
                    String name = v.getName();
                    try {
                        match = cxt.findOnlyField(name);
                    }
                    catch (NoSuchElementException e) {
                        continue;
                    }
                    NodeQuery tgtNodeQuery = match.getNodeQuery();
                    FacetPath tgtFacetPath = tgtNodeQuery.getFacetPath();
                    FacetPath delta = (FacetPath)facetPath.relativize((Path)tgtFacetPath);
                    ConstraintNode cn = (ConstraintNode)nodeQuery.constraints().resolve(delta);
                    Node substVar = jenaNode = cn.asJenaNode();
                    varMap.put(v, substVar);
                }
                MappedFragment mr = MappedFragment.of((Fragment)contrib, varMap);
                nodeQuery.addInjectFragment(mr);
                continue;
            }
            filterRelations.add(contrib.toFragment1());
        }
        Fragment1 filterRelation = filterRelations.stream().reduce((a, b) -> a.joinOn(new Var[]{a.getVar()}).with(b).toFragment1()).orElse(null);
        nodeQuery.setFilterFragment(filterRelation);
    }

    public static Fragment tryParseSparqlQuery(Context cxt, Directive dir, String argName) {
        String queryStr = Optional.ofNullable(dir).map(d -> d.getArgument(argName)).map(Argument::getValue).map(GraphQlUtils::toString).orElse(null);
        Fragment result = null;
        if (queryStr != null) {
            String base = cxt.getFinalBase();
            PrefixMappingAdapter pm = new PrefixMappingAdapter(cxt.getFinalPrefixMap());
            SparqlQueryParserImpl parser = SparqlQueryParserImpl.create((SparqlParserConfig)SparqlParserConfig.newInstance().setBaseURI(base).setPrefixMapping((PrefixMapping)pm));
            Query query = (Query)parser.apply((Object)queryStr);
            result = FragmentUtils.fromQuery((Query)query);
        }
        return result;
    }

    public static Range<Long> tryParseSlice(Multimap<String, Value<?>> args, Map<String, Value<?>> assignments) {
        Long offset = GraphQlUtils.toLong(GraphQlUtils.getArgumentValue(args, "offset", assignments));
        Long limit = GraphQlUtils.toLong(GraphQlUtils.getArgumentValue(args, "limit", assignments));
        Range result = offset == null && limit == null ? null : RangeUtils.createRange((Long)limit, (Long)offset);
        return result;
    }

    public FacetPath resolveProperty(Context cxt, String fieldName) {
        String fieldIri;
        FacetPath result = "xid".equals(fieldName) ? FacetPath.newRelativePath((FacetStep[])new FacetStep[0]) : ((fieldIri = GraphQlToSparqlConverter.deriveFieldIri(cxt, fieldName)) != null ? FacetPath.newRelativePath((FacetStep)FacetStep.fwd((Node)NodeFactory.createURI((String)fieldIri))) : this.resolver.resolveKeyToProperty(fieldName));
        return result;
    }

    public static Node resolveClass(GraphQlResolver resolver, Context cxt, String fieldName) {
        String fieldIri = GraphQlToSparqlConverter.deriveFieldIri(cxt, fieldName);
        Set<Node> classes = fieldIri != null ? Set.of(NodeFactory.createURI((String)fieldIri)) : resolver.resolveKeyToClasses(fieldName);
        Node result = (Node)IterableUtils.expectZeroOrOneItems(classes);
        return result;
    }

    public NodeQuery resolveKeyToClasses(NodeQuery nq, Node cls) {
        NodeQuery result = null;
        if (cls != null) {
            result = (NodeQuery)((ConstraintNode)((ConstraintFacade)((ConstraintNode)nq.constraints().fwd(RDF.type.asNode())).enterConstraints().eq(cls).activate()).leaveConstraints()).getRoot();
        }
        return result;
    }

    public static void tryApplySlice(NodeQuery nodeQuery, Multimap<String, Value<?>> args, Map<String, Value<?>> assignments) {
        Range<Long> slice = GraphQlToSparqlConverter.tryParseSlice(args, assignments);
        if (slice != null) {
            long offset = QueryUtils.rangeToOffset(slice);
            if (offset != 0L) {
                nodeQuery.offset(Long.valueOf(offset));
            }
            long limit = QueryUtils.rangeToLimit(slice);
            nodeQuery.limit(Long.valueOf(limit));
        }
    }

    public static PrefixMap tryGetPrefixMap(Value<?> value) {
        PrefixMap result = null;
        if (value instanceof ObjectValue) {
            ObjectValue obj = (ObjectValue)value;
            result = PrefixMapFactory.create();
            for (ObjectField field : obj.getObjectFields()) {
                String prefix = field.getName();
                String namespace = GraphQlUtils.toString(field.getValue());
                result.add(prefix, namespace);
            }
        }
        return result;
    }

    public static ScopedCardinality getCardinality(DirectivesContainer<?> container) {
        List directives = container.getDirectives();
        ScopedCardinality result = directives.stream().map(GraphQlToSparqlConverter::getCardinality).filter(Objects::nonNull).reduce((a, b) -> b).orElse(null);
        return result;
    }

    public static ScopedCardinality getCardinality(Directive d) {
        Cardinality cardinality;
        ScopedCardinality result = null;
        String name = d.getName();
        Cardinality cardinality2 = "one".equalsIgnoreCase(name) ? Cardinality.ONE : (cardinality = "many".equalsIgnoreCase(name) ? Cardinality.MANY : null);
        if (cardinality != null) {
            boolean cascade = Optional.ofNullable(GraphQlUtils.getArgAsBoolean(d, "cascade", null)).orElse(false);
            boolean self = Optional.ofNullable(GraphQlUtils.getArgAsBoolean(d, "self", null)).orElse(true);
            result = new ScopedCardinality(cardinality, cascade, self);
        }
        return result;
    }

    public class GraphQlQueryWorker {
        protected Document document;
        protected Map<String, Value<?>> assignments;
        protected Map<String, FragmentDefinition> fragmentsByName;
        protected Stack<Context> contextStack = new Stack();

        public GraphQlQueryWorker(Document document, Map<String, Value<?>> assignments) {
            this.document = Objects.requireNonNull(document);
            this.fragmentsByName = new LinkedHashMap<String, FragmentDefinition>();
            this.assignments = assignments != null ? assignments : Collections.emptyMap();
        }

        public void convertDocument(GraphQlToSparqlMapping result) {
            for (graphql.language.Node child : this.document.getChildren()) {
                if (child instanceof FragmentDefinition) {
                    FragmentDefinition fragmentDefinition = (FragmentDefinition)child;
                    this.fragmentsByName.put(fragmentDefinition.getName(), fragmentDefinition);
                    continue;
                }
                if (child instanceof OperationDefinition) {
                    OperationDefinition operationDefinition = (OperationDefinition)child;
                    SelectionSet selectionSet = operationDefinition.getSelectionSet();
                    this.convertTopLevelFields(selectionSet, result);
                    continue;
                }
                throw new RuntimeException("Unknown element: " + String.valueOf(child));
            }
        }

        public void convertTopLevelFields(SelectionSet selectionSet, GraphQlToSparqlMapping result) {
            this.contextStack.push(new Context(null, null));
            for (Field field : selectionSet.getSelectionsOfType(Field.class)) {
                this.convertTopLevelField(field, result);
            }
        }

        public void convertTopLevelField(Field field, GraphQlToSparqlMapping result) {
            Context context = this.contextStack.peek().newChildContext(field);
            GraphQlToSparqlConverter.setupContext(context);
            this.contextStack.push(context);
            NodeQuery nodeQuery = NodeQueryImpl.newRoot();
            context.setNodeQuery(nodeQuery);
            Multimap<String, Value<?>> args = GraphQlUtils.indexArguments(field);
            String fieldName = field.getName();
            if (logger.isDebugEnabled()) {
                logger.debug("Seen top level field: " + fieldName);
            }
            NodeQuery fieldQuery = nodeQuery;
            SelectionSet subSelection = field.getSelectionSet();
            GraphToJsonMapperNode nodeMapper = this.convertInnerSelectionSet(subSelection, nodeQuery);
            if (fieldQuery != null) {
                GraphQlToSparqlConverter.tryApplySlice(nodeQuery, args, this.assignments);
                this.tryApplyOrderBy(nodeQuery, args);
            }
            GraphQlToSparqlConverter.processSparqlDirectives(context, GraphQlToSparqlConverter.this.resolver);
            PrefixMap prefixMap = PrefixMapFactory.create((PrefixMap)context.getFinalPrefixMap());
            boolean isSingle = Cardinality.ONE.equals((Object)context.getThisCardinality());
            result.addEntry(field, prefixMap, nodeQuery, nodeMapper, isSingle);
            this.contextStack.pop();
        }

        public GraphToJsonMapperNode convertInnerSelectionSet(SelectionSet selectionSet, NodeQuery nodeQuery) {
            GraphToJsonNodeMapperLiteral result;
            if (selectionSet == null) {
                result = GraphToJsonNodeMapperLiteral.get();
            } else {
                GraphToJsonNodeMapperObject nodeMapperObject = new GraphToJsonNodeMapperObject();
                this.convertInnerSelectionSet((GraphToJsonNodeMapperObjectLike)nodeMapperObject, selectionSet, nodeQuery);
                result = nodeMapperObject;
            }
            return result;
        }

        public GraphToJsonMapperNode convertInnerSelectionSet(GraphToJsonNodeMapperObjectLike nodeMapperObject, SelectionSet selectionSet, NodeQuery nodeQuery) {
            for (Selection selection : selectionSet.getSelections()) {
                if (selection instanceof Field) {
                    Field field = (Field)selection;
                    this.convertInnerField(field, nodeQuery, nodeMapperObject);
                    continue;
                }
                SelectionSet resolvedSelectionSet = null;
                List resolvedbDirectives = null;
                TypeName resolvedTypeName = null;
                if (selection instanceof FragmentSpread) {
                    FragmentSpread fragmentSpread = (FragmentSpread)selection;
                    String name = fragmentSpread.getName();
                    FragmentDefinition def = this.fragmentsByName.get(name);
                    if (def == null) {
                        throw new RuntimeException("Fragment with name " + name + " not found");
                    }
                    resolvedSelectionSet = def.getSelectionSet();
                    resolvedbDirectives = def.getDirectives();
                    resolvedTypeName = def.getTypeCondition();
                } else if (selection instanceof InlineFragment) {
                    InlineFragment inlineFragment = (InlineFragment)selection;
                    resolvedSelectionSet = inlineFragment.getSelectionSet();
                    resolvedbDirectives = inlineFragment.getDirectives();
                    resolvedTypeName = inlineFragment.getTypeCondition();
                }
                if (resolvedSelectionSet == null) continue;
                String name = resolvedTypeName.getName();
                Field dummyField = Field.newField().name(name).directives(resolvedbDirectives).build();
                Context context = this.contextStack.peek().newChildContext(dummyField);
                GraphQlToSparqlConverter.setupContext(context);
                this.contextStack.push(context);
                NodeQuery nodeFragment = nodeQuery.addFragment();
                context.setNodeQuery(nodeFragment);
                GraphQlToSparqlConverter.processSparqlDirectives(context, GraphQlToSparqlConverter.this.resolver);
                Node node = NodeFactory.createLiteral((String)nodeFragment.relationQuery().getScopeBaseName());
                GraphToJsonNodeMapperFragmentHead fragmentMapper = GraphToJsonNodeMapperFragmentHead.of((Node)node, (boolean)true);
                GraphToJsonNodeMapperFragmentBody bodyMapper = new GraphToJsonNodeMapperFragmentBody();
                fragmentMapper.setTargetNodeMapper((GraphToJsonNodeMapperObjectLike)bodyMapper);
                this.convertInnerSelectionSet(fragmentMapper.getTargetNodeMapper(), resolvedSelectionSet, nodeFragment);
                P_Link key = GraphQlToSparqlConverter.this.jsonMode ? new P_Link(NodeFactory.createLiteralString((String)node.getLiteralLexicalForm())) : new P_Link(node);
                nodeMapperObject.getPropertyMappers().put(key, fragmentMapper);
                this.contextStack.pop();
            }
            GraphToJsonNodeMapperObjectLike result = nodeMapperObject;
            return result;
        }

        public GraphToJsonPropertyMapper convertInnerField(Field field, NodeQuery nodeQuery, GraphToJsonNodeMapperObjectLike nodeMapperObject) {
            String jsonKeyName = (String)ObjectUtils.firstNonNull((Object[])new String[]{field.getAlias(), field.getName()});
            Context context = this.contextStack.peek().newChildContext(field);
            GraphQlToSparqlConverter.setupContext(context);
            this.contextStack.push(context);
            GraphToJsonPropertyMapper propertyMapper = null;
            Multimap<String, Value<?>> args = GraphQlUtils.indexArguments(field);
            String fieldName = field.getName();
            Map directives = field.getDirectivesByName();
            boolean isSingle = Cardinality.ONE.equals((Object)context.getThisCardinality());
            FacetPath keyPath = GraphQlToSparqlConverter.this.resolveProperty(context, fieldName);
            if (keyPath != null) {
                boolean isInverse = directives.containsKey("inverse");
                if (isInverse && keyPath.getNameCount() == 1) {
                    keyPath = FacetPath.newRelativePath((FacetStep)((FacetStep)((FacetPath)keyPath.getName(0)).toSegment()).toggleDirection());
                }
                NodeQuery fieldQuery = nodeQuery.resolve(keyPath);
                context.setNodeQuery(fieldQuery);
                if (keyPath.getNameCount() == 1) {
                    Collection<Object> propertyShapes;
                    FacetStep step = (FacetStep)((FacetPath)keyPath.getFileName()).toSegment();
                    P_Path0 basicPath = PathUtils.createStep((Node)step.getNode(), (boolean)step.getDirection().isForward());
                    boolean useRelationId = true;
                    if (useRelationId) {
                        Node node = NodeFactory.createLiteral((String)fieldQuery.relationQuery().getScopeBaseName());
                        propertyMapper = GraphToJsonPropertyMapper.of((Node)node, (boolean)step.getDirection().isForward());
                    } else {
                        propertyMapper = GraphToJsonPropertyMapper.of((P_Path0)basicPath);
                    }
                    propertyMapper.setSingle(isSingle);
                    try {
                        propertyShapes = GraphQlToSparqlConverter.this.resolver.getGlobalPropertyShapes(basicPath);
                    }
                    catch (UnsupportedOperationException e) {
                        propertyShapes = Collections.emptySet();
                    }
                    if (!propertyShapes.isEmpty()) {
                        boolean allMaxCountsAreOne = propertyShapes.stream().map(ShPropertyShape::getMaxCount).allMatch(v -> v != null && v.intValue() == 1);
                        boolean isUniqueLang = propertyShapes.stream().map(ShPropertyShape::isUniqueLang).allMatch(v -> v != null && v == true);
                        if (allMaxCountsAreOne) {
                            propertyMapper.setMaxCount(1);
                        }
                        if (isUniqueLang) {
                            propertyMapper.setUniqueLang(true);
                        }
                    }
                    if (directives.containsKey("hide")) {
                        propertyMapper.setHidden(true);
                    }
                }
                SelectionSet subSelection = field.getSelectionSet();
                GraphToJsonMapperNode childConverterContrib = this.convertInnerSelectionSet(subSelection, fieldQuery);
                if (propertyMapper != null) {
                    propertyMapper.setTargetNodeMapper(childConverterContrib);
                }
                GraphQlToSparqlConverter.tryApplySlice(fieldQuery, args, this.assignments);
                this.tryApplyOrderBy(fieldQuery, args);
            }
            GraphQlToSparqlConverter.processSparqlDirectives(context, GraphQlToSparqlConverter.this.resolver);
            this.contextStack.pop();
            if (nodeMapperObject != null) {
                P_Link key;
                Object object = key = GraphQlToSparqlConverter.this.jsonMode ? new P_Link(NodeFactory.createLiteralString((String)jsonKeyName)) : ((FacetStep)((FacetPath)keyPath.getFileName()).toSegment()).getStep();
                if (propertyMapper != null) {
                    nodeMapperObject.getPropertyMappers().put(key, propertyMapper);
                }
            }
            return propertyMapper;
        }

        public Object tryApplyOrderBy(NodeQuery nodeQuery, Multimap<String, Value<?>> args) {
            Value<?> val = GraphQlUtils.getArgumentValue(args, "orderBy");
            if (val instanceof ArrayValue) {
                ArrayValue array = (ArrayValue)val;
                for (Value item : array.getValues()) {
                    this.tryApplySortCondition(nodeQuery, item);
                }
            } else {
                this.tryApplyOrderBy(nodeQuery, val);
            }
            return null;
        }

        public Object tryApplyOrderBy(NodeQuery nodeQuery, Value<?> v) {
            if (v instanceof ObjectValue) {
                ObjectValue ov = (ObjectValue)v;
                this.tryApplyOrderBy(nodeQuery, ov);
            }
            return null;
        }

        public FacetPath toFacetPath(Value<?> value) {
            FacetPath result = null;
            if (value instanceof ArrayValue) {
                ArrayValue av = (ArrayValue)value;
                result = FacetPath.newRelativePath((FacetStep[])new FacetStep[0]);
                for (Value v : av.getValues()) {
                    FacetPath contrib = this.toFacetPathSingle(v);
                    if (contrib == null) {
                        result = null;
                        break;
                    }
                    result = (FacetPath)result.resolve((Path)contrib);
                }
            } else {
                result = this.toFacetPathSingle(value);
            }
            return result;
        }

        public FacetPath toFacetPathSingle(Value<?> value) {
            FacetPath result = null;
            String key = null;
            if (value instanceof StringValue) {
                key = ((StringValue)value).getValue();
            } else if (value instanceof EnumValue) {
                key = ((EnumValue)value).getName();
            }
            if (key != null) {
                result = GraphQlToSparqlConverter.this.resolver.resolveKeyToProperty(key);
            }
            return result;
        }

        public Object tryApplyOrderBy(NodeQuery nodeQuery, ObjectValue ov) {
            Multimap<String, Value<?>> mm = GraphQlUtils.indexValues(ov);
            for (Map.Entry e : mm.asMap().entrySet()) {
                String fieldName = (String)e.getKey();
                Value val = (Value)Iterables.getOnlyElement((Iterable)((Iterable)e.getValue()));
                String orderStr = GraphQlUtils.toString(val);
                int order = "ASC".equalsIgnoreCase(orderStr) ? 1 : ("DESC".equalsIgnoreCase(orderStr) ? -1 : -2);
                Context match = this.contextStack.peek().findOnlyField(fieldName);
                NodeQuery nq = match.getNodeQuery();
                FacetPath facetPath = nq.getFacetPath();
                FacetPath base = nodeQuery.getFacetPath();
                FacetPath rel = (FacetPath)base.relativize((Path)facetPath);
                ConstraintNode sortNode = (ConstraintNode)nodeQuery.constraints().resolve(rel);
                sortNode.sort(order);
            }
            return null;
        }

        public Object tryApplySortCondition(NodeQuery nodeQuery, Value<?> value) {
            if (value instanceof ObjectValue) {
                ObjectValue ov = (ObjectValue)value;
                this.tryApplyOrderBy(nodeQuery, ov);
            }
            return null;
        }
    }
}

