/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.common.graph.Traverser;
import graphql.language.Field;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathStr;
import org.aksw.jenax.arq.util.prefix.PrefixMap2;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.graphql.sparql.Cardinality;
import org.aksw.jenax.graphql.sparql.GraphQlUtils;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.graph.PrefixMappingAdapter;

public class Context {
    protected Field field;
    protected Context parent;
    protected String base = null;
    protected PrefixMap localPrefixMap = null;
    protected String iri;
    protected String ns;
    protected PrefixMap finalPrefixMap = null;
    protected String finalBase = null;
    protected String finalNs = null;
    protected String finalIri = null;
    protected NodeQuery nodeQuery;
    protected Map<String, Context> childContexts = new LinkedHashMap<String, Context>();
    protected Cardinality thisCardinality;
    protected Cardinality inheritedCardinality;

    public Context(Context parent, Field field) {
        this.parent = parent;
        this.field = field;
        if (parent != null) {
            this.inheritedCardinality = parent.getInheritedCardinality();
            this.thisCardinality = parent.getInheritedCardinality();
        } else {
            this.inheritedCardinality = Cardinality.MANY;
            this.thisCardinality = Cardinality.MANY;
        }
    }

    public Path<String> getPath() {
        PathStr parentPath = this.parent != null ? this.parent.getPath() : PathStr.newAbsolutePath((String[])new String[0]);
        PathStr result = this.field == null ? parentPath : parentPath.resolve((Object)this.field.getName());
        return result;
    }

    public NodeQuery getNodeQuery() {
        return this.nodeQuery;
    }

    public void setNodeQuery(NodeQuery nodeQuery) {
        this.nodeQuery = nodeQuery;
    }

    public Field getField() {
        return this.field;
    }

    public Context newChildContext(Field field) {
        String fieldName = field.getName();
        Context result = new Context(this, field);
        this.childContexts.put(fieldName, result);
        return result;
    }

    public Context getParent() {
        return this.parent;
    }

    public Map<String, Context> getChildContexts() {
        return this.childContexts;
    }

    public Optional<Context> tryGetParent() {
        return Optional.ofNullable(this.parent);
    }

    public void setBase(String iri) {
        this.base = iri;
    }

    public String getBase() {
        String result = this.base != null ? this.base : (this.parent != null ? this.parent.getBase() : null);
        return result;
    }

    public PrefixMap getLocalPrefixMap() {
        return this.localPrefixMap;
    }

    public void setLocalPrefixMap(PrefixMap prefixMap) {
        this.localPrefixMap = prefixMap;
        this.update();
    }

    public String getIri() {
        return this.iri;
    }

    public void setIri(String iri) {
        this.iri = iri;
    }

    public String getNs() {
        return this.ns;
    }

    public void setNs(String ns) {
        this.ns = ns;
    }

    public static <T> T combine(T a, T b, BinaryOperator<T> combiner, Supplier<T> nullCase) {
        T result = a == null ? (b == null ? nullCase.get() : b) : (b == null ? a : combiner.apply(a, b));
        return result;
    }

    public void update() {
        this.updatePrefixes();
    }

    public void updatePrefixes() {
        this.finalPrefixMap = this.buildFinalPrefixMap();
        PrefixMappingAdapter pm = new PrefixMappingAdapter(this.finalPrefixMap);
        this.finalBase = this.base == null ? null : Optional.ofNullable(pm.getNsPrefixURI(this.base)).orElseGet(() -> this.lambda$updatePrefixes$0((PrefixMapping)pm));
        this.finalNs = this.ns == null ? null : Optional.ofNullable(pm.getNsPrefixURI(this.ns)).orElseGet(() -> this.lambda$updatePrefixes$1((PrefixMapping)pm));
        this.finalIri = this.iri == null ? null : Optional.ofNullable(pm.getNsPrefixURI(this.iri)).orElseGet(() -> this.lambda$updatePrefixes$2((PrefixMapping)pm));
    }

    public PrefixMap buildFinalPrefixMap() {
        PrefixMap parentMap = this.parent == null ? null : this.parent.getFinalPrefixMap();
        PrefixMap result = Context.combine(parentMap, this.localPrefixMap, PrefixMap2::new, PrefixMapFactory::emptyPrefixMap);
        return result;
    }

    public PrefixMap getFinalPrefixMap() {
        return this.finalPrefixMap;
    }

    public String getFinalBase() {
        return this.finalBase != null ? this.finalBase : (String)this.tryGetParent().map(Context::getFinalBase).orElse(null);
    }

    public String getFinalNs() {
        return this.finalNs != null ? this.finalNs : (String)this.tryGetParent().map(Context::getFinalNs).orElse(null);
    }

    public String getFinalIri() {
        return this.finalIri != null ? this.finalIri : (String)this.tryGetParent().map(Context::getFinalIri).orElse(null);
    }

    public Context findOnlyField(String fieldName) {
        Set<Context> matches = this.findField(fieldName);
        List matchingPaths = matches.stream().map(Context::getPath).collect(Collectors.toList());
        if (matches.isEmpty()) {
            throw new NoSuchElementException("Could not resolve field name " + fieldName + " at path " + String.valueOf(this.getPath()));
        }
        if (matches.size() > 1) {
            throw new IllegalArgumentException("Ambiguous resolution. Field name + " + fieldName + " expected to resolve to 1 field. Got " + matchingPaths.size() + " fields: " + String.valueOf(matchingPaths));
        }
        Context match = (Context)Iterables.getOnlyElement(matches);
        return match;
    }

    public Set<Context> findField(String name) {
        Set<Context> result = Streams.stream((Iterable)Traverser.forTree(cxt -> cxt.getChildContexts().values()).depthFirstPreOrder((Object)this)).filter(cxt -> {
            Field field = cxt.getField();
            Set<String> names = Context.getEffectiveFieldNames(field);
            boolean r = names.contains(name);
            return r;
        }).collect(Collectors.toSet());
        return result;
    }

    public static Set<String> getEffectiveFieldNames(Field field) {
        Set<String> result = Context.getAliases(field);
        if (result.isEmpty()) {
            result = Set.of(field.getName());
        }
        return result;
    }

    public static Set<String> getAliases(Field field) {
        Set<String> result = field.getDirectives("as").stream().map(d -> GraphQlUtils.getArgValueAsString(d, "name", null)).collect(Collectors.toSet());
        return result;
    }

    public Cardinality getThisCardinality() {
        return this.thisCardinality;
    }

    public void setThisCardinality(Cardinality thisCardinality) {
        this.thisCardinality = thisCardinality;
    }

    public Cardinality getInheritedCardinality() {
        return this.inheritedCardinality;
    }

    public void setInheritedCardinality(Cardinality inheritedCardinality) {
        this.inheritedCardinality = inheritedCardinality;
    }

    private /* synthetic */ String lambda$updatePrefixes$2(PrefixMapping pm) {
        return pm.expandPrefix(this.iri);
    }

    private /* synthetic */ String lambda$updatePrefixes$1(PrefixMapping pm) {
        return pm.expandPrefix(this.ns);
    }

    private /* synthetic */ String lambda$updatePrefixes$0(PrefixMapping pm) {
        return pm.expandPrefix(this.base);
    }
}

