/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.impl.common;

import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import graphql.language.Document;
import graphql.parser.Parser;
import java.io.IOException;
import java.io.OutputStream;
import org.aksw.jenax.graphql.impl.common.GraphQlExecToJsonObject;
import org.aksw.jenax.graphql.impl.common.GraphQlResultWriterImpl;
import org.aksw.jenax.graphql.json.api.GraphQlDataProvider;
import org.aksw.jenax.graphql.json.api.GraphQlExec;
import org.aksw.jenax.graphql.json.api.GraphQlExecFactory;

public class GraphQlExecUtils {
    public static JsonObject collectMetadata(GraphQlExec exec) {
        JsonObject metadata = new JsonObject();
        for (GraphQlDataProvider stream : exec.getDataProviders()) {
            JsonObject streamMetadata = stream.getMetadata();
            if (streamMetadata == null) continue;
            metadata.add(stream.getName(), (JsonElement)streamMetadata);
        }
        return metadata;
    }

    public static JsonObject collectExtensions(GraphQlExec exec) {
        JsonObject result = new JsonObject();
        JsonObject metadata = GraphQlExecUtils.collectMetadata(exec);
        if (!metadata.keySet().isEmpty()) {
            result.add("metadata", (JsonElement)metadata);
        }
        return result;
    }

    public static GraphQlExec execJson(GraphQlExecFactory gef, String jsonRequest) {
        return GraphQlExecUtils.execJson(gef, new Gson(), jsonRequest);
    }

    public static GraphQlExec execJson(GraphQlExecFactory gef, Gson gson, String jsonRequest) {
        JsonObject jsonObject = (JsonObject)gson.fromJson(jsonRequest, JsonObject.class);
        return GraphQlExecUtils.execJson(gef, jsonObject);
    }

    public static GraphQlExec execJson(GraphQlExecFactory gef, JsonObject jsonObject) {
        Preconditions.checkArgument((jsonObject != null ? 1 : 0) != 0, (Object)"Expected a GraphQL document in JSON but got null");
        JsonElement queryElt = jsonObject.get("query");
        Preconditions.checkArgument((queryElt != null ? 1 : 0) != 0, (Object)"JSON object does not have a query field");
        Preconditions.checkArgument((boolean)queryElt.isJsonPrimitive(), (Object)"Value for 'query' is not a string");
        JsonPrimitive primitive = queryElt.getAsJsonPrimitive();
        Preconditions.checkArgument((boolean)primitive.isString(), (Object)"Value for 'query' must be a string");
        String queryStr = primitive.getAsString();
        GraphQlExec result = GraphQlExecUtils.exec(gef, queryStr);
        return result;
    }

    public static GraphQlExec exec(GraphQlExecFactory gef, String queryStr) {
        Parser parser = new Parser();
        Document document = parser.parseDocument(queryStr);
        GraphQlExec result = gef.create(document, null);
        return result;
    }

    public static JsonObject materialize(GraphQlExecFactory gef, String queryStr) {
        GraphQlExec ge = GraphQlExecUtils.exec(gef, queryStr);
        JsonObject result = GraphQlExecUtils.materialize(ge);
        return result;
    }

    public static JsonObject materialize(GraphQlExec exec) {
        return new GraphQlExecToJsonObject().write(exec);
    }

    public static void write(OutputStream out, GraphQlExec exec) {
        GraphQlExecUtils.write(out, exec, new GsonBuilder().serializeNulls().create());
    }

    public static void writePretty(OutputStream out, GraphQlExec exec) {
        GraphQlExecUtils.write(out, exec, new GsonBuilder().serializeNulls().setPrettyPrinting().create());
    }

    public static void write(OutputStream out, GraphQlExec exec, Gson gson) {
        try {
            new GraphQlResultWriterImpl(gson).write(out, exec);
            out.write(10);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

