/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.impl.common;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeOnce<T> {
    private static final Logger logger = LoggerFactory.getLogger(ComputeOnce.class);
    protected String taskName;
    protected Callable<ListenableFuture<T>> computationTask;
    protected transient ListenableFuture<T> computation = null;

    public ComputeOnce(String taskName, Callable<ListenableFuture<T>> computationTask) {
        this.taskName = taskName;
        this.computationTask = computationTask;
    }

    public static <T> ComputeOnce<T> of(String taskName, Callable<ListenableFuture<T>> computationTask) {
        return new ComputeOnce<T>(taskName, computationTask);
    }

    public static <T> ComputeOnce<T> ofWithLogging(String taskName, Callable<ListenableFuture<T>> delegateCreation) {
        ComputeOnce<T> result = new ComputeOnce<T>(taskName, () -> {
            if (logger.isInfoEnabled()) {
                logger.info("Submitting task for async " + taskName + " creation");
            }
            ListenableFuture r = (ListenableFuture)delegateCreation.call();
            if (logger.isInfoEnabled()) {
                logger.info("Successfully submitted task for async " + taskName + " creation");
            }
            return r;
        });
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<T> get() {
        if (this.computation == null) {
            ComputeOnce computeOnce = this;
            synchronized (computeOnce) {
                if (this.computation == null) {
                    try {
                        this.computation = this.computationTask.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.computation;
    }

    public T getWithLogging() {
        return ComputeOnce.getWithLogging(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getWithLogging(ComputeOnce<T> delegateCreation) {
        Object delegate;
        boolean hasToWait;
        ListenableFuture<T> future = delegateCreation.get();
        Thread thread = Thread.currentThread();
        boolean bl = hasToWait = !future.isDone();
        if (hasToWait && logger.isInfoEnabled()) {
            logger.info("Thread " + thread.getName() + " (id=" + thread.getId() + ") awaiting async GraphQlExecFactory creation");
        }
        try {
            delegate = Futures.getUnchecked(future);
        }
        finally {
            if (hasToWait && logger.isInfoEnabled()) {
                logger.info("Thread " + thread.getName() + " (id=" + thread.getId() + ") successfully received GraphQlExecfactory");
            }
        }
        return (T)delegate;
    }
}

