/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.graphql.impl.common.GraphQlResolverAlwaysFail;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlExecBuilder;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlExecFactory;
import org.aksw.jenax.graphql.sparql.DatasetMetadata;
import org.aksw.jenax.graphql.sparql.GraphQlExecBuilderOverSparql;
import org.aksw.jenax.graphql.sparql.GraphQlResolver;
import org.aksw.jenax.graphql.sparql.GraphQlResolverImpl;
import org.aksw.jenax.graphql.sparql.GraphQlResolverImplLazy;
import org.aksw.jenax.graphql.sparql.GraphQlToSparqlMappingBuilderImpl;
import org.aksw.jenax.graphql.sparql.GraphQlToSparqlMappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphQlExecFactoryOverSparql
implements RdfGraphQlExecFactory {
    private static final Logger logger = LoggerFactory.getLogger(GraphQlExecFactoryOverSparql.class);
    protected RDFDataSource dataSource;
    protected GraphQlToSparqlMappingFactory mappingFactory;

    public GraphQlExecFactoryOverSparql(RDFDataSource dataSource, GraphQlToSparqlMappingFactory mappingFactory) {
        this.dataSource = dataSource;
        this.mappingFactory = mappingFactory;
    }

    @Override
    public RdfGraphQlExecBuilder newBuilder() {
        return new GraphQlExecBuilderOverSparql(this.dataSource, this.mappingFactory);
    }

    public static RdfGraphQlExecFactory of(RDFDataSource dataSource, GraphQlToSparqlMappingFactory mappingFactory) {
        return new GraphQlExecFactoryOverSparql(dataSource, mappingFactory);
    }

    public static RdfGraphQlExecFactory of(RDFDataSource dataSource) {
        return GraphQlExecFactoryOverSparql.of(dataSource, new GraphQlResolverAlwaysFail());
    }

    public static RdfGraphQlExecFactory of(RDFDataSource dataSource, GraphQlResolver resolver) {
        GraphQlToSparqlMappingFactory mappingFactory = () -> new GraphQlToSparqlMappingBuilderImpl().setResolver(resolver);
        return GraphQlExecFactoryOverSparql.of(dataSource, mappingFactory);
    }

    public static GraphQlResolver resolverOf(DatasetMetadata metadata) {
        return new GraphQlResolverImpl(metadata.getVoidDataset(), metadata.getShaclModel());
    }

    public static RdfGraphQlExecFactory of(RDFDataSource dataSource, DatasetMetadata metadata) {
        GraphQlResolver resolver = GraphQlExecFactoryOverSparql.resolverOf(metadata);
        GraphQlToSparqlMappingFactory mappingFactory = () -> new GraphQlToSparqlMappingBuilderImpl().setResolver(resolver);
        RdfGraphQlExecFactory result = GraphQlExecFactoryOverSparql.of(dataSource, mappingFactory);
        return result;
    }

    public static RdfGraphQlExecFactory autoConfEager(RDFDataSource dataSource) {
        DatasetMetadata metadata = (DatasetMetadata)Futures.getUnchecked(DatasetMetadata.fetch(dataSource, MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.newDirectExecutorService())));
        GraphQlResolver resolver = GraphQlExecFactoryOverSparql.resolverOf(metadata);
        GraphQlToSparqlMappingFactory mappingFactory = () -> new GraphQlToSparqlMappingBuilderImpl().setResolver(resolver);
        return GraphQlExecFactoryOverSparql.of(dataSource, mappingFactory);
    }

    public static RdfGraphQlExecFactory autoConfLazy(RDFDataSource dataSource) {
        GraphQlResolver resolver = GraphQlResolverImplLazy.of(() -> {
            ListeningExecutorService executorService = MoreExecutors.listeningDecorator((ExecutorService)MoreExecutors.getExitingExecutorService((ThreadPoolExecutor)((ThreadPoolExecutor)Executors.newCachedThreadPool())));
            ListenableFuture<DatasetMetadata> metadataFuture = DatasetMetadata.fetch(dataSource, executorService);
            ListenableFuture r = Futures.transform(metadataFuture, metadata -> {
                if (logger.isInfoEnabled()) {
                    Set classes = metadata.getVoidDataset().getClassPartitionMap().keySet();
                    logger.info("Autodetected classes: " + String.valueOf(classes));
                    Set properties = metadata.getVoidDataset().getPropertyPartitionMap().keySet();
                    logger.info("Autodetected properties: " + String.valueOf(properties));
                }
                GraphQlResolver s = GraphQlExecFactoryOverSparql.resolverOf(metadata);
                return s;
            }, (Executor)executorService);
            r.addListener(() -> executorService.shutdown(), (Executor)executorService);
            return r;
        });
        GraphQlToSparqlMappingFactory mappingFactory = () -> new GraphQlToSparqlMappingBuilderImpl().setResolver(resolver);
        RdfGraphQlExecFactory result = GraphQlExecFactoryOverSparql.of(dataSource, mappingFactory);
        return result;
    }
}

