/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.impl.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import org.aksw.jenax.graphql.impl.common.GraphQlExecUtils;
import org.aksw.jenax.graphql.json.api.GraphQlDataProvider;
import org.aksw.jenax.graphql.json.api.GraphQlExec;

public class GraphQlExecToJsonObject {
    public JsonObject write(GraphQlExec exec) {
        JsonObject dataObject = new JsonObject();
        for (GraphQlDataProvider dataProvider : exec.getDataProviders()) {
            String name = dataProvider.getName();
            JsonArray items = new JsonArray();
            try (Stream<JsonElement> stream = dataProvider.openStream();){
                stream.forEach(arg_0 -> ((JsonArray)items).add(arg_0));
            }
            dataObject.add(name, (JsonElement)items);
        }
        JsonArray errorsArray = new JsonArray();
        JsonObject result = new JsonObject();
        result.add("data", (JsonElement)dataObject);
        result.add("errors", (JsonElement)errorsArray);
        JsonObject metadata = GraphQlExecUtils.collectExtensions(exec);
        if (!metadata.keySet().isEmpty()) {
            result.add("extensions", (JsonElement)metadata);
        }
        return result;
    }
}

