/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import graphql.language.Document;
import graphql.language.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.io.json.graph.GraphToJsonMapperNode;
import org.apache.jena.riot.system.PrefixMap;

public class GraphQlToSparqlMapping {
    protected Document document;
    protected Map<String, Entry> topLevelMappings;

    public GraphQlToSparqlMapping(Document document) {
        this(document, new LinkedHashMap<String, Entry>());
    }

    public GraphQlToSparqlMapping(Document document, Map<String, Entry> topLevelMappings) {
        this.document = document;
        this.topLevelMappings = topLevelMappings;
    }

    public Document getDocument() {
        return this.document;
    }

    public Map<String, Entry> getTopLevelMappings() {
        return this.topLevelMappings;
    }

    public void addEntry(Field topLevelField, PrefixMap prefixMap, NodeQuery nodeQuery, GraphToJsonMapperNode mapper, boolean isSingle) {
        String fieldName = topLevelField.getName();
        this.topLevelMappings.put(fieldName, new Entry(topLevelField, prefixMap, nodeQuery, mapper, isSingle));
    }

    public static class Entry {
        protected Field topLevelField;
        protected PrefixMap prefixMap;
        protected NodeQuery nodeQuery;
        protected GraphToJsonMapperNode mapper;
        protected boolean isSingle;

        public Entry(Field topLevelField, PrefixMap prefixMap, NodeQuery nodeQuery, GraphToJsonMapperNode mapper, boolean isSingle) {
            this.nodeQuery = nodeQuery;
            this.prefixMap = prefixMap;
            this.mapper = mapper;
            this.topLevelField = topLevelField;
            this.isSingle = isSingle;
        }

        public Field getTopLevelField() {
            return this.topLevelField;
        }

        public PrefixMap getPrefixMap() {
            return this.prefixMap;
        }

        public NodeQuery getNodeQuery() {
            return this.nodeQuery;
        }

        public GraphToJsonMapperNode getMapper() {
            return this.mapper;
        }

        public boolean isSingle() {
            return this.isSingle;
        }
    }
}

