/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.commons.util.direction.Direction;
import org.aksw.jenax.graphql.sparql.GraphQlResolver;
import org.aksw.jenax.model.shacl.domain.ShPropertyShape;
import org.aksw.jenax.model.shacl.util.ShUtils;
import org.aksw.jenax.model.voidx.api.VoidDataset;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.path.P_Path0;

public class GraphQlResolverImpl
implements GraphQlResolver {
    protected VoidDataset voidDataset;
    protected Model shaclModel;
    protected Multimap<P_Path0, ShPropertyShape> globalPropertyShapes;

    public GraphQlResolverImpl(VoidDataset voidDataset, Model shaclModel) {
        this.voidDataset = voidDataset;
        this.shaclModel = shaclModel;
        this.globalPropertyShapes = ShUtils.indexGlobalPropertyShapes((Model)shaclModel);
    }

    public Multimap<P_Path0, ShPropertyShape> getGlobalPropertyShapes() {
        return this.globalPropertyShapes;
    }

    @Override
    public Collection<ShPropertyShape> getGlobalPropertyShapes(P_Path0 path) {
        return this.globalPropertyShapes.get((Object)path);
    }

    @Override
    public Set<Node> resolveKeyToClasses(String key) {
        Set classes = this.voidDataset.getClassPartitionMap().keySet();
        Set<Node> result = classes.stream().filter(Node::isURI).filter(node -> node.getLocalName().equals(key)).collect(Collectors.toSet());
        return result;
    }

    @Override
    public FacetPath resolveKeyToProperty(String rawKey) {
        FacetPath result;
        String key;
        boolean isFwd = !rawKey.startsWith("inv_");
        String string = key = isFwd ? rawKey : rawKey.substring(1);
        if (Objects.equals(key, "xid")) {
            result = FacetPath.newRelativePath((FacetStep[])new FacetStep[0]);
        } else {
            Set allProperties = this.voidDataset.getPropertyPartitionMap().keySet();
            List matchingProperties = allProperties.stream().filter(Node::isURI).filter(node -> node.getLocalName().equals(key)).collect(Collectors.toList());
            Node p = (Node)IterableUtils.expectZeroOrOneItems(matchingProperties);
            if (p != null) {
                FacetStep step = FacetStep.of((Node)p, (Direction)Direction.ofFwd((boolean)isFwd), (String)"", (Node)FacetStep.TARGET);
                result = FacetPath.newRelativePath((FacetStep)step);
            } else {
                result = null;
            }
        }
        return result;
    }
}

