/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.schema.generator;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import graphql.language.Argument;
import graphql.language.Definition;
import graphql.language.Directive;
import graphql.language.Document;
import graphql.language.FieldDefinition;
import graphql.language.InterfaceTypeDefinition;
import graphql.language.ListType;
import graphql.language.ObjectTypeDefinition;
import graphql.language.StringValue;
import graphql.language.Type;
import graphql.language.TypeName;
import graphql.language.Value;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jenax.arq.util.node.NodeCollection;
import org.aksw.jenax.arq.util.prefix.ShortNameMgr;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.graphql.sparql.DatasetMetadata;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Table;

public class GraphQlSchemaGenerator {
    public static final Node UNTYPED = NodeFactory.createLiteralString((String)"Untyped");
    public static final Node EMPTY = NodeFactory.createLiteralString((String)"emptyType");
    public static final Type TYPE_SCALAR = TypeName.newTypeName((String)"Scalar").build();
    protected ShortNameMgr shortNameMgr = new ShortNameMgr();
    protected DatasetMetadata datasetMetadata;
    protected Map<Node, ClassInfo> classMap = new LinkedHashMap<Node, ClassInfo>();
    protected Map<Set<Node>, Node> unionClassToName = new LinkedHashMap<Set<Node>, Node>();
    protected Map<ExclusionType, Node> exclusionTypeMap = new LinkedHashMap<ExclusionType, Node>();
    protected Map<Set<PropertyInfo>, Node> propertiesToStructuralClass = new LinkedHashMap<Set<PropertyInfo>, Node>();
    int classCounter = 0;

    public static List<TypeInfo> summarize(RDFDataSource dataSource) {
        Query dataSummary = SparqlStmtMgr.loadQuery((String)"data-summary.rq");
        Table table = dataSource.asLinkSource().newQuery().query(dataSummary).table();
        List<TypeInfo> result = table.toRowSet().stream().map(b -> new TypeInfo((Set)NodeCollection.extractOrNull((Node)b.get("srcTypes")), b.get("p"), (Boolean)b.get("isForward").getLiteral().getValue(), (Set)NodeCollection.extractOrNull((Node)b.get("allTgtTypes")), ((Number)b.get("maxTgtCard").getLiteral().getValue()).longValue() > 1L, (Set)NodeCollection.extractOrNull((Node)b.get("allTgtDTypes")), ((Number)b.get("maxTgtDCard").getLiteral().getValue()).longValue() > 1L)).toList();
        return result;
    }

    public Document process(List<TypeInfo> list) {
        this.init(list);
        for (ClassInfo ci : new ArrayList<ClassInfo>(this.classMap.values())) {
            for (PropertyInfo pi : new ArrayList<PropertyInfo>(ci.propertyMap().values())) {
                this.makeUnionTypeProperty(pi);
            }
        }
        Document result = this.convert();
        return result;
    }

    protected void makeUnionTypeProperty(PropertyInfo pi) {
        LinkedHashSet<Node> ots = new LinkedHashSet<Node>(pi.objectTypes());
        if (ots.size() > 1) {
            Node newType = this.createUnionType(ots);
            pi.objectTypes().clear();
            pi.objectTypes().add(newType);
        }
    }

    protected void init(List<TypeInfo> list) {
        HashMultimap sIndex = HashMultimap.create();
        list.forEach(arg_0 -> GraphQlSchemaGenerator.lambda$init$2((Multimap)sIndex, arg_0));
        Map map = sIndex.asMap();
        for (Map.Entry sts : map.entrySet()) {
            Node sourceType = (Node)sts.getKey();
            Collection typeInfos = (Collection)sts.getValue();
            LinkedHashSet<Node> properties = new LinkedHashSet<Node>();
            LinkedHashMap pMap = new LinkedHashMap();
            HashMultimap propertyTypes = HashMultimap.create();
            HashMultimap propertyDTypes = HashMultimap.create();
            HashMap<Node, Boolean> propertyRCard = new HashMap<Node, Boolean>();
            HashMap<Node, Boolean> propertyLCard = new HashMap<Node, Boolean>();
            for (TypeInfo typeInfo : typeInfos) {
                Node p = typeInfo.property();
                properties.add(p);
                propertyTypes.putAll((Object)p, typeInfo.objectTypes());
                propertyDTypes.putAll((Object)p, typeInfo.objectDatatypes());
                propertyLCard.compute(p, (k, v) -> v != null && v != false || typeInfo.maxLiteralCard());
                propertyRCard.compute(p, (k, v) -> v != null && v != false || typeInfo.maxResourceCard());
            }
            ClassInfo classInfo = new ClassInfo(sourceType, new LinkedHashMap<Node, PropertyInfo>(), new LinkedHashSet<Node>());
            for (Node p : properties) {
                LinkedHashSet<Node> objectTypes = (LinkedHashSet<Node>)propertyTypes.get((Object)p);
                LinkedHashSet<Node> objectDTypes = (LinkedHashSet<Node>)propertyDTypes.get((Object)p);
                if (objectTypes == null) {
                    objectTypes = new LinkedHashSet<Node>();
                }
                if (objectDTypes == null) {
                    objectDTypes = new LinkedHashSet<Node>();
                }
                boolean rCard = (Boolean)propertyRCard.get(p);
                boolean lCard = (Boolean)propertyLCard.get(p);
                PropertyInfo pi = new PropertyInfo(p, objectTypes, rCard, objectDTypes, lCard);
                classInfo.propertyMap().put(p, pi);
            }
            this.registerClass(classInfo);
        }
        this.classMap.computeIfAbsent(UNTYPED, cls -> new ClassInfo((Node)cls, (Map<Node, PropertyInfo>)new LinkedHashMap<Node, PropertyInfo>(), (Set<Node>)new LinkedHashSet<Node>()));
    }

    protected void registerClass(ClassInfo classInfo) {
        Node className = classInfo.name();
        LinkedHashSet<PropertyInfo> propertySet = new LinkedHashSet<PropertyInfo>(classInfo.propertyMap().values());
        this.classMap.put(className, classInfo);
    }

    public String toName(Node node) {
        String result;
        if (node.isURI()) {
            String iri = node.getURI();
            result = this.shortNameMgr.allocate(iri).shortName();
        } else if (node.isLiteral()) {
            result = node.getLiteralLexicalForm();
        } else {
            throw new RuntimeException("Unexpected node name: " + String.valueOf(node));
        }
        result = GraphQlSchemaGenerator.sanitize(result);
        return result;
    }

    public static String sanitize(String name) {
        return name;
    }

    protected Document convert() {
        boolean doMaterialize = true;
        if (doMaterialize) {
            for (Map.Entry<Node, ClassInfo> e : new ArrayList<Map.Entry<Node, ClassInfo>>(this.classMap.entrySet())) {
                e.setValue(this.materialize(e.getValue()));
            }
        }
        List<FieldDefinition> queryFields = this.classMap.values().stream().map(x -> FieldDefinition.newFieldDefinition().name(this.toName(x.name())).type((Type)ListType.newListType((Type)TypeName.newTypeName((String)this.toName(x.name())).build()).build()).build()).filter(x -> !x.getName().startsWith("class") || x.getName().endsWith("dummy")).toList();
        ObjectTypeDefinition query = ObjectTypeDefinition.newObjectTypeDefinition().name("Query").fieldDefinitions(queryFields).build();
        List<Definition> definitions = this.classMap.values().stream().map(this::convertType).map(x -> x).toList();
        Document result = Document.newDocument().definitions(definitions).definition((Definition)query).build();
        return result;
    }

    public boolean subsumes(Node parent, Node child) {
        boolean result;
        if (Objects.equals(parent, child)) {
            result = true;
        } else {
            ClassInfo ci = this.classMap.get(parent);
            result = ci.superTypes().stream().anyMatch(p -> this.subsumes((Node)p, child));
        }
        return result;
    }

    public Set<Node> normalize(Set<Node> types) {
        LinkedHashSet<Node> result = new LinkedHashSet<Node>(types);
        for (Node parent : types) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                Node child = (Node)it.next();
                if (parent == child || !this.subsumes(parent, child)) continue;
                it.remove();
            }
        }
        return result;
    }

    protected ClassInfo materialize(ClassInfo classInfo) {
        Set<Node> objectTypes;
        Node name = classInfo.name();
        Map<Node, PropertyInfo> propertyMap = this.createPropertyMap(name);
        this.normalize(propertyMap);
        for (PropertyInfo propertyInfo : propertyMap.values()) {
            Node pName = propertyInfo.name();
            objectTypes = propertyInfo.objectTypes();
            this.makeUnionTypeProperty(propertyInfo);
        }
        for (Map.Entry entry : propertyMap.entrySet()) {
            PropertyInfo pi = (PropertyInfo)entry.getValue();
            objectTypes = pi.objectTypes();
            if (objectTypes.size() <= 1) continue;
            throw new IllegalStateException("Unexpected multivalued property on class " + String.valueOf(classInfo.name()) + ": " + String.valueOf(pi.name()) + " - " + String.valueOf(objectTypes));
        }
        ClassInfo result = new ClassInfo(name, propertyMap, new LinkedHashSet<Node>());
        return result;
    }

    protected Definition convertType(ClassInfo classInfo) {
        ObjectTypeDefinition result;
        boolean generateObjectTypeDefinitions;
        Node nameNode = classInfo.name();
        String name = this.toName(nameNode);
        Directive dir = Directive.newDirective().name("uri").argument(Argument.newArgument((String)"value", (Value)StringValue.of((String)GraphQlSchemaGenerator.toURI(nameNode))).build()).build();
        if (name.startsWith("class") || name.equals("Untyped")) {
            dir = null;
        }
        List<Type> implementz = classInfo.superTypes().stream().map(t -> TypeName.newTypeName((String)this.toName((Node)t)).build()).map(t -> t).toList();
        List fieldDefs = classInfo.propertyMap().values().stream().map(this::convertProperty).collect(Collectors.toCollection(ArrayList::new));
        String FieldName_URI = "uri";
        FieldDefinition uriField = FieldDefinition.newFieldDefinition().name(FieldName_URI).directive(Directive.newDirective().name("to").build()).type(TYPE_SCALAR).build();
        boolean hasUriField = fieldDefs.stream().anyMatch(x -> x.getName().equals(FieldName_URI));
        if (!hasUriField) {
            fieldDefs.add(0, uriField);
        }
        if (fieldDefs.isEmpty()) {
            FieldDefinition dummyField = FieldDefinition.newFieldDefinition().name("_" + name + "_dummy").type(TYPE_SCALAR).build();
            fieldDefs.add(dummyField);
        }
        if (generateObjectTypeDefinitions = true) {
            ObjectTypeDefinition.Builder resultBuilder = ObjectTypeDefinition.newObjectTypeDefinition().name(name).implementz(implementz).fieldDefinitions(fieldDefs);
            if (dir != null) {
                resultBuilder = resultBuilder.directive(dir);
            }
            result = resultBuilder.build();
        } else {
            InterfaceTypeDefinition.Builder bu = InterfaceTypeDefinition.newInterfaceTypeDefinition().name(name).implementz(implementz).definitions(fieldDefs);
            if (dir != null) {
                bu = bu.directive(dir);
            }
            result = bu.build();
        }
        return result;
    }

    public static String toURI(Node node) {
        String result = node.isURI() ? node.getURI() : (node.isLiteral() ? node.getLiteralLexicalForm() : null);
        Objects.requireNonNull(result);
        return result;
    }

    protected FieldDefinition convertProperty(PropertyInfo propertyInfo) {
        FieldDefinition result;
        Set<Node> objectTypes = propertyInfo.objectTypes();
        if (objectTypes.size() > 1) {
            throw new IllegalStateException("Property had more than 1 type; multiple types should have been combined into a single new one: " + String.valueOf(propertyInfo));
        }
        Node objectType = objectTypes.isEmpty() ? null : objectTypes.iterator().next();
        String name = this.toName(propertyInfo.name());
        Directive dir = Directive.newDirective().name("uri").argument(Argument.newArgument((String)"value", (Value)StringValue.of((String)GraphQlSchemaGenerator.toURI(propertyInfo.name()))).build()).build();
        if (objectType != null) {
            String pTypeName = this.toName(objectType);
            TypeName type = TypeName.newTypeName((String)pTypeName).build();
            if (propertyInfo.maxResourceCard || propertyInfo.maxLiteralCard) {
                type = ListType.newListType((Type)type).build();
            }
            result = FieldDefinition.newFieldDefinition().name(name).type((Type)type).directive(dir).build();
        } else {
            Type type = TYPE_SCALAR;
            if (propertyInfo.maxResourceCard || propertyInfo.maxLiteralCard) {
                type = ListType.newListType((Type)type).build();
            }
            result = FieldDefinition.newFieldDefinition().name(name).type(type).directive(dir).build();
        }
        return result;
    }

    protected Node createUnionType(Set<Node> types) {
        Node result = this.unionClassToName.get(types = this.normalize(types));
        if (result == null) {
            if (types.isEmpty()) {
                result = this.getOrCreateUnionType(types);
            } else if (types.size() == 1) {
                result = types.iterator().next();
            } else {
                Node safeTypeName;
                result = this.getOrCreateUnionType(types);
                ClassInfo resultCi = this.classMap.get(result);
                Map<Node, PropertyInfo> propertyMap = this.createPropertyMap(types);
                this.normalize(propertyMap);
                for (PropertyInfo propertyInfo : propertyMap.values()) {
                    this.makeUnionTypeProperty(propertyInfo);
                }
                LinkedHashSet<Node> conflictProperties = new LinkedHashSet<Node>();
                for (Node typeName : types) {
                    Map<Node, PropertyInfo> pm = this.createPropertyMap(typeName);
                    for (Map.Entry<Node, PropertyInfo> e2 : propertyMap.entrySet()) {
                        Node p = e2.getKey();
                        Set<Node> allSeenObjectTypes = e2.getValue().objectTypes();
                        Set<Node> allSeenDObjectTypes = e2.getValue().objectDatatypes();
                        PropertyInfo pi = pm.get(p);
                        if (pi == null) continue;
                        Set<Node> objectTypes = pi.objectTypes();
                        Set<Node> objectDatatypes = pi.objectDatatypes();
                        if (objectTypes.equals(allSeenObjectTypes) && objectDatatypes.equals(allSeenDObjectTypes)) continue;
                        conflictProperties.add(p);
                    }
                }
                Set set = types.stream().map(type -> this.severProperty((Node)type, (Set<Node>)conflictProperties)).collect(Collectors.toCollection(LinkedHashSet::new));
                Map<Node, PropertyInfo> conflictPropertyMap = propertyMap.entrySet().stream().filter(e -> conflictProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                if (!conflictPropertyMap.isEmpty()) {
                    Node conflictResolvedType = this.getOrCreateStructuralType(conflictPropertyMap);
                    set.add(conflictResolvedType);
                }
                if ((safeTypeName = this.unionClassToName.get(set)) != null) {
                    result = safeTypeName;
                    this.unionClassToName.put(set, result);
                } else {
                    this.unionClassToName.put(set, result);
                }
                resultCi.superTypes().addAll(set);
            }
        }
        return result;
    }

    protected Node getEmptyType() {
        Node result = EMPTY;
        this.classMap.computeIfAbsent(result, r -> new ClassInfo((Node)r, (Map<Node, PropertyInfo>)new LinkedHashMap<Node, PropertyInfo>(), (Set<Node>)new LinkedHashSet<Node>()));
        return result;
    }

    protected Node getOrCreateUnionType(Set<Node> superTypes) {
        Node result;
        if (superTypes.size() == 0) {
            result = this.getEmptyType();
        } else if (superTypes.size() == 1) {
            result = superTypes.iterator().next();
        } else {
            LinkedHashSet<Node> superTypesKey = new LinkedHashSet<Node>(superTypes);
            result = this.unionClassToName.computeIfAbsent(superTypesKey, set -> {
                Node r = this.allocateClassName();
                ClassInfo ci = new ClassInfo(r, new LinkedHashMap<Node, PropertyInfo>(), new LinkedHashSet<Node>());
                this.classMap.put(r, ci);
                return r;
            });
        }
        return result;
    }

    protected Node getOrCreateStructuralType(Map<Node, PropertyInfo> propertyMap) {
        if (propertyMap.isEmpty()) {
            return this.getEmptyType();
        }
        Map pMap = propertyMap.entrySet().stream().collect(Collectors.toMap(e -> (Node)e.getKey(), e -> ((PropertyInfo)e.getValue()).clone(), (u, v) -> v, LinkedHashMap::new));
        LinkedHashSet pSet = new LinkedHashSet(pMap.values());
        return this.propertiesToStructuralClass.computeIfAbsent(pSet, ps -> {
            Node r = this.allocateClassName();
            ClassInfo ci = new ClassInfo(r, pMap, new LinkedHashSet<Node>());
            this.classMap.put(r, ci);
            return r;
        });
    }

    public Stream<Node> getTypes(Node node) {
        Set<Node> superNodes = this.classMap.get(node).superTypes();
        return Stream.concat(Stream.of(node), superNodes.stream().flatMap(this::getTypes));
    }

    protected Node severProperty(Node cls, Set<Node> exclusions) {
        Node result;
        if (exclusions.isEmpty()) {
            result = cls;
        } else {
            ClassInfo ci = this.classMap.get(cls);
            for (PropertyInfo pi2 : ci.propertyMap.values()) {
                this.makeUnionTypeProperty(pi2);
            }
            LinkedHashMap safeProperties = new LinkedHashMap();
            LinkedHashMap<Node, PropertyInfo> conflictProperties = new LinkedHashMap<Node, PropertyInfo>();
            ci.propertyMap().forEach((p, pi) -> {
                if (exclusions.contains(p)) {
                    conflictProperties.put((Node)p, (PropertyInfo)pi);
                } else {
                    safeProperties.put(p, pi);
                }
            });
            LinkedHashSet<Node> oldSuperTypes = new LinkedHashSet<Node>(ci.superTypes());
            Set<Node> newSuperTypes = oldSuperTypes.stream().map(superType -> this.severProperty((Node)superType, exclusions)).collect(Collectors.toCollection(LinkedHashSet::new));
            if (newSuperTypes.equals(oldSuperTypes) && conflictProperties.isEmpty()) {
                result = cls;
            } else if (conflictProperties.isEmpty() && newSuperTypes.size() == 1) {
                result = (Node)newSuperTypes.iterator().next();
            } else if (newSuperTypes.size() > 1 && conflictProperties.isEmpty() && safeProperties.isEmpty()) {
                result = this.getOrCreateUnionType(newSuperTypes);
            } else {
                Node conflictFreeClassName = this.allocateExclusionClassName(cls, exclusions);
                if (oldSuperTypes.contains(conflictFreeClassName)) {
                    result = cls;
                } else {
                    boolean nonEmptyConflictType = false;
                    ClassInfo conflictFreeCi = this.classMap.get(conflictFreeClassName);
                    if (conflictFreeCi == null) {
                        throw new RuntimeException("should not happen");
                    }
                    if (!conflictProperties.isEmpty()) {
                        Node conflictType = this.getOrCreateStructuralType(conflictProperties);
                        Set allTypes = newSuperTypes.stream().flatMap(t -> this.getTypes((Node)t)).collect(Collectors.toSet());
                        if (!allTypes.contains(conflictType) && !cls.equals((Object)conflictType)) {
                            nonEmptyConflictType = true;
                            newSuperTypes.add(conflictType);
                        }
                        newSuperTypes = this.normalize(newSuperTypes);
                        newSuperTypes.remove(EMPTY);
                    }
                    if (!nonEmptyConflictType) {
                        if (newSuperTypes.isEmpty()) {
                            result = cls;
                        } else {
                            if (!Objects.equals(conflictFreeClassName, EMPTY)) {
                                newSuperTypes.add(conflictFreeClassName);
                            }
                            result = this.createUnionType(newSuperTypes);
                        }
                        ci.propertyMap().clear();
                        ci.propertyMap().putAll(safeProperties);
                        ci.superTypes().clear();
                        ci.superTypes().addAll(new LinkedHashSet<Node>(newSuperTypes));
                        ci.superTypes().add(conflictFreeClassName);
                    } else {
                        result = cls;
                    }
                }
            }
        }
        ClassInfo xxx = this.classMap.get(result);
        return result;
    }

    protected Node allocateClassName() {
        return NodeFactory.createURI((String)("http://example.org/class" + this.classCounter++));
    }

    protected Node allocateExclusionClassNameFromType(Node baseName, Set<Node> exclusionProperties) {
        ExclusionType et = new ExclusionType(baseName, new LinkedHashSet<Node>(exclusionProperties));
        Node result = this.exclusionTypeMap.computeIfAbsent(et, x -> {
            Map<Node, PropertyInfo> pMap = this.createPropertyMap(baseName);
            Map<Node, PropertyInfo> finalMap = pMap.entrySet().stream().filter(e -> !exclusionProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            Node r = this.getOrCreateStructuralType(finalMap);
            return r;
        });
        return result;
    }

    protected Node allocateExclusionClassName(Node baseName, Set<Node> exclusionProperties) {
        return this.allocateExclusionClassNameFromStructure(baseName, exclusionProperties);
    }

    protected Node allocateExclusionClassNameFromStructure(Node baseName, Set<Node> exclusionProperties) {
        Map<Node, PropertyInfo> pMap = this.createPropertyMap(baseName);
        Map<Node, PropertyInfo> finalMap = pMap.entrySet().stream().filter(e -> !exclusionProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Node r = this.getOrCreateStructuralType(finalMap);
        return r;
    }

    protected Node allocateExclusionClassNameFromStructureOld(Node baseName, Set<Node> exclusionProperties) {
        Map<Node, PropertyInfo> pMap = this.createPropertyMap(baseName);
        Map<Node, PropertyInfo> finalMap = pMap.entrySet().stream().filter(e -> !exclusionProperties.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ExclusionType et = new ExclusionType(baseName, new LinkedHashSet<Node>(exclusionProperties));
        Node result = this.exclusionTypeMap.computeIfAbsent(et, x -> this.allocateClassName());
        return result;
    }

    protected Map<Node, PropertyInfo> createPropertyMap(Node type) {
        HashMap<Node, PropertyInfo> result = new HashMap<Node, PropertyInfo>();
        this.collectPropertyMap(type, result);
        return result;
    }

    protected void normalize(Map<Node, PropertyInfo> propertyMap) {
        propertyMap.values().forEach(this::normalize);
    }

    protected void normalize(PropertyInfo pi) {
        Set<Node> before = pi.objectTypes();
        Set<Node> after = this.normalize(before);
        pi.objectTypes().clear();
        pi.objectTypes().addAll(after);
    }

    protected Map<Node, PropertyInfo> createPropertyMap(Set<Node> types) {
        HashMap<Node, PropertyInfo> result = new HashMap<Node, PropertyInfo>();
        this.collectPropertyMap(types, result);
        return result;
    }

    protected void collectPropertyMap(Set<Node> types, Map<Node, PropertyInfo> result) {
        for (Node type : types) {
            this.collectPropertyMap(type, result);
        }
    }

    protected void collectPropertyMap(Node type, Map<Node, PropertyInfo> result) {
        ClassInfo ci = this.classMap.get(type);
        if (ci == null) {
            throw new IllegalStateException("No class info found for: " + String.valueOf(type));
        }
        HashMultimap propertyTypes = HashMultimap.create();
        HashMultimap propertyDTypes = HashMultimap.create();
        HashSet properties = new HashSet();
        HashMap propertyRCard = new HashMap();
        HashMap propertyLCard = new HashMap();
        ci.propertyMap().forEach((arg_0, arg_1) -> GraphQlSchemaGenerator.lambda$collectPropertyMap$31(properties, (Multimap)propertyTypes, (Multimap)propertyDTypes, propertyLCard, propertyRCard, arg_0, arg_1));
        for (Node p : properties) {
            Set objectTypes = (Set)propertyTypes.get((Object)p);
            Set objectDTypes = (Set)propertyDTypes.get((Object)p);
            boolean rCard = (Boolean)propertyRCard.get(p);
            boolean lCard = (Boolean)propertyLCard.get(p);
            PropertyInfo pi = new PropertyInfo(p, objectTypes, rCard, objectDTypes, lCard);
            PropertyInfo before = result.get(p);
            if (before != null) {
                before.objectTypes().addAll(objectTypes);
                before.objectDatatypes().addAll(objectDTypes);
                pi = before;
            }
            result.put(p, pi);
        }
        Set<Node> superTypes = ci.superTypes();
        this.collectPropertyMap(superTypes, result);
    }

    public GraphQlSchemaGenerator setDatasetMetadata(DatasetMetadata datasetMetadata) {
        this.datasetMetadata = datasetMetadata;
        return this;
    }

    private static /* synthetic */ void lambda$collectPropertyMap$31(Set properties, Multimap propertyTypes, Multimap propertyDTypes, Map propertyLCard, Map propertyRCard, Node property, PropertyInfo typeInfo) {
        properties.add(property);
        propertyTypes.putAll((Object)property, typeInfo.objectTypes());
        propertyDTypes.putAll((Object)property, typeInfo.objectDatatypes());
        propertyLCard.compute(property, (k, v) -> v != null && v != false || typeInfo.maxLiteralCard());
        propertyRCard.compute(property, (k, v) -> v != null && v != false || typeInfo.maxResourceCard());
    }

    private static /* synthetic */ void lambda$init$2(Multimap sIndex, TypeInfo item) {
        item.subjectTypes().forEach(st -> sIndex.put(st, (Object)item));
    }

    public record ClassInfo(Node name, Map<Node, PropertyInfo> propertyMap, Set<Node> superTypes) {
    }

    public record PropertyInfo(Node name, Set<Node> objectTypes, boolean maxResourceCard, Set<Node> objectDatatypes, boolean maxLiteralCard) {
        public PropertyInfo clone() {
            return new PropertyInfo(this.name, new LinkedHashSet<Node>(this.objectTypes), this.maxResourceCard, new LinkedHashSet<Node>(this.objectDatatypes), this.maxLiteralCard);
        }
    }

    public record TypeInfo(Set<Node> subjectTypes, Node property, boolean isForward, Set<Node> objectTypes, boolean maxResourceCard, Set<Node> objectDatatypes, boolean maxLiteralCard) {
    }

    public record ExclusionType(Node baseClass, Set<Node> excludedProperties) {
    }
}

