/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.impl.common;

import java.util.stream.Stream;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlDataProvider;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlExec;
import org.aksw.jenax.ron.RdfArray;
import org.aksw.jenax.ron.RdfArrayImpl;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.ron.RdfObject;
import org.aksw.jenax.ron.RdfObjectImpl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.ResourceFactory;

public class RdfGraphQlExecUtils {
    public static final Property data = ResourceFactory.createProperty((String)"urn:data");
    public static final Property errors = ResourceFactory.createProperty((String)"urn:errors");

    public static RdfObject write(RdfGraphQlExec exec) {
        RdfObjectImpl dataObject = new RdfObjectImpl();
        for (RdfGraphQlDataProvider dataProvider : exec.getDataProviders()) {
            String name = dataProvider.getName();
            RdfArrayImpl items = new RdfArrayImpl();
            try (Stream<RdfElement> stream = dataProvider.openStream();){
                stream.forEach(arg_0 -> ((RdfArray)items).add(arg_0));
            }
            Node nameIri = NodeFactory.createURI((String)name);
            dataObject.addForward(nameIri, (RdfElement)items);
        }
        RdfArrayImpl errorsArray = new RdfArrayImpl();
        RdfObjectImpl result = new RdfObjectImpl();
        result.addForward((RDFNode)data, (RdfElement)dataObject);
        result.addForward((RDFNode)errors, (RdfElement)errorsArray);
        return result;
    }
}

