/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.graphql.sparql;

import com.google.gson.JsonObject;
import graphql.language.Field;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecSelect;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.api.RelationQuery;
import org.aksw.jenax.facete.treequery2.impl.ElementGeneratorLateral;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlDataProvider;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlDataProviderBase;
import org.aksw.jenax.graphql.rdf.api.RdfGraphQlExec;
import org.aksw.jenax.graphql.sparql.GraphQlToSparqlMapping;
import org.aksw.jenax.io.json.accumulator.AccContextRdf;
import org.aksw.jenax.io.json.accumulator.AccJson;
import org.aksw.jenax.io.json.accumulator.AccJsonDriver;
import org.aksw.jenax.io.json.accumulator.AggJson;
import org.aksw.jenax.io.json.accumulator.AggJsonNode;
import org.aksw.jenax.io.json.graph.GraphToJsonMapperNode;
import org.aksw.jenax.io.json.writer.RdfObjectNotationWriter;
import org.aksw.jenax.ron.RdfElement;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecAdapter;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.graph.PrefixMappingAdapter;

public class RdfGraphQlExecImpl
implements RdfGraphQlExec {
    protected RDFDataSource dataSource;
    protected GraphQlToSparqlMapping mapping;
    protected List<RdfGraphQlDataProvider> dataProviders;

    public RdfGraphQlExecImpl(RDFDataSource dataSource, GraphQlToSparqlMapping mapping) {
        this.dataSource = dataSource;
        this.mapping = mapping;
    }

    public RDFDataSource getDataSource() {
        return this.dataSource;
    }

    public GraphQlToSparqlMapping getMapping() {
        return this.mapping;
    }

    @Override
    public Set<String> getDataProviderNames() {
        return this.mapping.getTopLevelMappings().keySet();
    }

    @Override
    public RdfGraphQlDataProvider getDataProvider(String name) {
        boolean useAccumulators;
        GraphQlToSparqlMapping.Entry entry = this.mapping.getTopLevelMappings().get(name);
        boolean isSingle = entry.isSingle();
        PrefixMap prefixMap = entry.getPrefixMap();
        NodeQuery nodeQuery = entry.getNodeQuery();
        GraphToJsonMapperNode jsonMapper = entry.getMapper();
        RelationQuery rq = nodeQuery.relationQuery();
        Query query = ElementGeneratorLateral.toQuery((RelationQuery)rq);
        query.setPrefixMapping((PrefixMapping)new PrefixMappingAdapter(prefixMap));
        Field field = entry.getTopLevelField();
        JsonObject metadata = null;
        if (field.hasDirective("debug")) {
            metadata = new JsonObject();
            metadata.addProperty("sparqlQuery", query.toString());
        }
        if (!(useAccumulators = true)) {
            throw new UnsupportedOperationException("legacy implementation no longer supported");
        }
        AggJsonNode agg = jsonMapper.toAggregator();
        Supplier<Stream> quadStreamSupplier = () -> SparqlRx.execConstructQuads(() -> QueryExecutionAdapter.adapt((QueryExec)QueryExecSelect.of((Query)query, q -> QueryExecAdapter.adapt((QueryExecution)this.dataSource.asQef().createQueryExecution(q)), (boolean)true))).blockingStream();
        RdfGraphQlDataProviderBase result = new RdfGraphQlDataProviderBase(name, metadata, (AggJson)agg, isSingle, quadStreamSupplier, query){
            final /* synthetic */ AggJson val$agg;
            final /* synthetic */ boolean val$isSingle;
            final /* synthetic */ Supplier val$quadStreamSupplier;
            final /* synthetic */ Query val$query;
            {
                this.val$agg = aggJson;
                this.val$isSingle = bl;
                this.val$quadStreamSupplier = supplier;
                this.val$query = query;
                super(name, extensions);
            }

            @Override
            public Stream<RdfElement> openStream() {
                AccJson acc = this.val$agg.newAccumulator();
                AccJsonDriver driver = AccJsonDriver.of((AccJson)acc, (boolean)this.val$isSingle);
                AccContextRdf context = AccContextRdf.materializing();
                Stream quadStream = (Stream)this.val$quadStreamSupplier.get();
                Stream<RdfElement> r = driver.asStream(context, quadStream).map(Map.Entry::getValue);
                return r;
            }

            @Override
            public Query getQuery() {
                return this.val$query;
            }

            @Override
            public void write(RdfObjectNotationWriter writer) throws IOException {
                AccJson acc = this.val$agg.newAccumulator();
                AccJsonDriver driver = AccJsonDriver.of((AccJson)acc, (boolean)this.val$isSingle);
                AccContextRdf context = AccContextRdf.serializing((RdfObjectNotationWriter)writer);
                ((Stream)this.val$quadStreamSupplier.get()).forEach(quad -> {
                    try {
                        driver.accumulate(quad, context);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                });
                driver.end(context);
                if (this.val$isSingle && driver.getSourcesSeen() == 0L) {
                    writer.nullValue();
                }
            }

            @Override
            public boolean isSingle() {
                return this.val$isSingle;
            }
        };
        return result;
    }
}

