/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.functionbinder;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.aksw.jena_sparql_api.common.DefaultPrefixes;
import org.aksw.jenax.arq.functionbinder.FunctionAdapter;
import org.aksw.jenax.arq.functionbinder.FunctionGenerator;
import org.aksw.jenax.reprogen.shared.AnnotationUtils;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionBinder {
    private static final Logger logger = LoggerFactory.getLogger(FunctionBinder.class);
    protected Supplier<FunctionRegistry> functionRegistrySupplier;
    protected FunctionGenerator functionGenerator;

    public FunctionBinder() {
        this(new FunctionGenerator(), FunctionRegistry::get);
    }

    public FunctionBinder(Supplier<FunctionRegistry> functionRegistrySupplier) {
        this(new FunctionGenerator(), functionRegistrySupplier);
    }

    public FunctionBinder(FunctionGenerator functionGenerator) {
        this(functionGenerator, FunctionRegistry::get);
    }

    public FunctionBinder(FunctionGenerator functionGenerator, Supplier<FunctionRegistry> functionRegistrySupplier) {
        this.functionGenerator = functionGenerator;
        this.functionRegistrySupplier = functionRegistrySupplier;
    }

    public FunctionGenerator getFunctionGenerator() {
        return this.functionGenerator;
    }

    public void register(String uri, Method method) {
        this.register(true, uri, method);
    }

    public void register(String uri, Method method, Object invocationTarget) {
        this.register(true, uri, method, invocationTarget);
    }

    public void register(Method method) {
        this.register(true, method);
    }

    public void register(Method method, Object invocationTarget) {
        this.register(true, method, invocationTarget);
    }

    public void registerAll(Class<?> clz) {
        this.registerAll(true, clz, null);
    }

    public void registerAll(Class<?> clz, Object invocationTarget) {
        this.registerAll(true, clz, invocationTarget);
    }

    public void register(boolean lazy, String functionIri, Method method) {
        this.register(functionIri, method, null);
    }

    public void register(boolean lazy, List<String> functionIris, Method method, Object invocationTarget) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Auto-binding SPARQL function(s) %s to %s (invocationTarget: %s)", functionIris, method, invocationTarget));
        }
        FunctionFactory factory = this.factory(lazy, method, invocationTarget);
        FunctionRegistry functionRegistry = this.functionRegistrySupplier.get();
        for (String iri : functionIris) {
            functionRegistry.put(iri, factory);
        }
    }

    public void register(boolean lazy, String functionIri, Method method, Object invocationTarget) {
        this.register(lazy, Collections.singletonList(functionIri), method, invocationTarget);
    }

    public void register(boolean lazy, Method method) {
        this.register(lazy, method, null);
    }

    public void register(boolean lazy, Method method, Object invocationTarget) {
        List iris = AnnotationUtils.deriveIrisFromMethod((Method)method, (PrefixMapping)DefaultPrefixes.get());
        if (iris.isEmpty()) {
            throw new RuntimeException("No @Iri or @IriNs annotation present on method");
        }
        this.register(lazy, iris, method, invocationTarget);
    }

    public void register(String iri, Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        try {
            this.register(iri, clazz.getMethod(methodName, paramTypes));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public void registerAll(boolean lazy, Class<?> clz) {
        this.registerAll(lazy, clz, null);
    }

    public void registerAll(boolean lazy, Class<?> clz, Object invocationTarget) {
        for (Method method : clz.getMethods()) {
            List iris = AnnotationUtils.deriveIrisFromMethod((Method)method, (PrefixMapping)DefaultPrefixes.get());
            if (iris.isEmpty()) continue;
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if ((invocationTarget != null || !isStatic) && (invocationTarget == null || isStatic)) continue;
            this.register(lazy, iris, method, invocationTarget);
        }
    }

    public FunctionFactory factory(boolean lazy, Method method) {
        return this.factory(lazy, method, null);
    }

    public FunctionFactory factory(boolean lazy, Method method, Object invocationTarget) {
        if (!lazy) {
            FunctionAdapter fn = this.functionGenerator.wrap(method, invocationTarget);
            return iri -> fn;
        }
        FunctionFactory result = iri -> this.functionGenerator.wrap(method, invocationTarget);
        return result;
    }

    public static Function getFunction(Method method) {
        return FunctionBinder.getFunction(FunctionRegistry.get(), method);
    }

    public static Function getFunction(FunctionRegistry registry, Method method) {
        List iris = AnnotationUtils.deriveIrisFromMethod((Method)method, (PrefixMapping)DefaultPrefixes.get());
        Function result = null;
        for (String iri : iris) {
            FunctionFactory factory = registry.get(iri);
            if (factory == null) continue;
            result = factory.create(iri);
            break;
        }
        return result;
    }
}

