/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.functionbinder;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.aksw.commons.util.convert.ConverterRegistries;
import org.aksw.commons.util.convert.ConverterRegistry;
import org.aksw.jenax.arq.functionbinder.Param;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.sse.builders.SSE_ExprBuildException;
import org.apache.jena.sparql.util.Context;

public class FunctionAdapter
implements Function {
    protected Object invocationTarget;
    protected Method method;
    protected java.util.function.Function<Object, NodeValue> returnValueConverter;
    protected ConverterRegistry converterRegistry;
    protected TypeMapper typeMapper;
    protected Param[] params;
    protected int mandatoryArgsCount;

    public FunctionAdapter(Method method, Object invocationTarget, java.util.function.Function<Object, NodeValue> returnValueConverter, Param[] params, TypeMapper typeMapper, ConverterRegistry converterRegistry) {
        this.method = method;
        this.invocationTarget = invocationTarget;
        this.returnValueConverter = returnValueConverter;
        this.params = params;
        this.converterRegistry = converterRegistry;
        this.typeMapper = typeMapper;
    }

    public void build(String uri, ExprList args, Context context) {
    }

    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
        Object[] javaArgs = this.buildJavaArgs(binding, args, env);
        NodeValue result = this.invokeWithJavaArgs(javaArgs);
        return result;
    }

    public NodeValue invokeWithJavaArgs(Object[] javaArgs) {
        Object val;
        try {
            val = this.method.invoke(this.invocationTarget, javaArgs);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new ExprEvalException((Throwable)e);
        }
        NodeValue result = this.returnValueConverter.apply(val);
        if (result == null) {
            throw new ExprEvalException(String.format("Null returned from %s for arguments %s", this.method, javaArgs));
        }
        return result;
    }

    public Object[] buildJavaArgs(Binding binding, ExprList args, FunctionEnv env) {
        int argCount = args.size();
        int paramCount = this.params.length;
        Object[] javaArgs = new Object[paramCount];
        boolean isVarArgs = this.method.isVarArgs();
        int varArgOffset = paramCount - 1;
        if (argCount < this.mandatoryArgsCount || argCount > paramCount && !isVarArgs) {
            throw new SSE_ExprBuildException(String.format("at least %d and at most %d args expected but %d provided", this.mandatoryArgsCount, this.params.length, argCount));
        }
        Param lastParam = paramCount > 0 ? this.params[varArgOffset] : null;
        Object javaVarArgsArr = null;
        int varArgCount = 0;
        if (isVarArgs) {
            varArgCount = Math.max(0, argCount - paramCount + 1);
            javaArgs[paramCount - 1] = javaVarArgsArr = Array.newInstance(lastParam.getParamClass().getComponentType(), varArgCount);
        }
        for (int i = 0; i < Math.max(argCount, paramCount); ++i) {
            Object javaArg;
            boolean isInVarArgs;
            Param param = i < paramCount ? this.params[i] : lastParam;
            Class<?> inputClass = param.getInputClass();
            Class<?> paramType = param.getParamClass();
            boolean bl = isInVarArgs = isVarArgs && i >= varArgOffset;
            if (isInVarArgs) {
                paramType = paramType.getComponentType();
            }
            if (i < argCount) {
                Expr expr = args.get(i);
                NodeValue arg = expr.eval(binding, env);
                NodeValue nv = arg.getConstant();
                Node node = nv.asNode();
                Object intermediateObj = inputClass != null && Node.class.isAssignableFrom(inputClass) ? node : node.getLiteralValue();
                javaArg = ConverterRegistries.convert((ConverterRegistry)this.converterRegistry, (Object)intermediateObj, paramType);
            } else {
                javaArg = param.defaultValue;
            }
            if (isInVarArgs) {
                if (i >= argCount) continue;
                Array.set(javaVarArgsArr, i - varArgOffset, javaArg);
                continue;
            }
            javaArgs[i] = javaArg;
        }
        return javaArgs;
    }

    public Object getInvocationTarget() {
        return this.invocationTarget;
    }

    public Method getMethod() {
        return this.method;
    }
}

