/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.functionbinder;

import com.google.common.collect.Iterables;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aksw.commons.collections.IterableUtils;
import org.aksw.commons.util.convert.ConvertFunctionRaw;
import org.aksw.commons.util.convert.ConvertFunctionRawImpl;
import org.aksw.commons.util.convert.ConverterRegistries;
import org.aksw.commons.util.convert.ConverterRegistry;
import org.aksw.commons.util.convert.ConverterRegistryImpl;
import org.aksw.jenax.annotation.reprogen.DefaultValue;
import org.aksw.jenax.arq.functionbinder.FunctionAdapter;
import org.aksw.jenax.arq.functionbinder.Param;
import org.aksw.jenax.arq.util.node.NodeList;
import org.apache.commons.lang3.ClassUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.expr.NodeValue;

public class FunctionGenerator {
    protected TypeMapper typeMapper;
    protected ConverterRegistry converterRegistry;
    protected Map<Class<?>, Class<?>> javaToRdfTypeMap;
    protected Map<Class<?>, String> typeByClassOverrides = new HashMap();

    public FunctionGenerator() {
        this(TypeMapper.getInstance(), (ConverterRegistry)new ConverterRegistryImpl(), new HashMap());
    }

    public FunctionGenerator(TypeMapper typeMapper, ConverterRegistry converterRegistry, Map<Class<?>, Class<?>> returnTypeMap) {
        this.typeMapper = typeMapper;
        this.converterRegistry = converterRegistry;
        this.javaToRdfTypeMap = returnTypeMap;
    }

    public Map<Class<?>, String> getTypeByClassOverrides() {
        return this.typeByClassOverrides;
    }

    public TypeMapper getTypeMapper() {
        return this.typeMapper;
    }

    public ConverterRegistry getConverterRegistry() {
        return this.converterRegistry;
    }

    public Map<Class<?>, Class<?>> getJavaToRdfTypeMap() {
        return this.javaToRdfTypeMap;
    }

    public ConvertFunctionRaw getPreConvert(Class<?> targetJavaType, Class<?> internalJavaType) {
        ConvertFunctionRaw preConvert = null;
        if (internalJavaType != null && !ClassUtils.isAssignable(targetJavaType, internalJavaType) && (preConvert = this.converterRegistry.getConverter(targetJavaType, internalJavaType)) == null) {
            throw new RuntimeException(String.format("Conversion from %1$s to %2$s declared but no converter found", targetJavaType, internalJavaType));
        }
        return preConvert;
    }

    public FunctionAdapter wrap(Method method) {
        return this.wrap(method, null);
    }

    public FunctionAdapter wrap(Method method, Object invocationTarget) {
        Class<?> targetJavaType = method.getReturnType();
        Class<?> internalJavaType = this.javaToRdfTypeMap.get(targetJavaType);
        Class<?> workingType = internalJavaType != null ? internalJavaType : targetJavaType;
        ConvertFunctionRaw preConvert = internalJavaType == null ? null : this.getPreConvert(targetJavaType, internalJavaType);
        ConvertFunctionRaw internalTypeToNodeValue = FunctionGenerator.createNodeValueMapper(workingType, this.converterRegistry, this.typeMapper, this.typeByClassOverrides);
        ConvertFunctionRaw resultConverter = preConvert == null ? internalTypeToNodeValue : preConvert.andThen(internalTypeToNodeValue);
        Function<Object, NodeValue> returnValueConverter = in -> in == null ? null : (NodeValue)resultConverter.convertRaw(in);
        int n = method.getParameterCount();
        Class<?>[] pts = method.getParameterTypes();
        Annotation[][] pas = method.getParameterAnnotations();
        int firstDefaultValueIdx = -1;
        Param[] params = new Param[n];
        for (int i = 0; i < n; ++i) {
            Param param;
            boolean isNodeType;
            Annotation[] as = pas[i];
            Class<?> paramClass = pts[i];
            Class<?> componentClass = paramClass.isArray() ? paramClass.getComponentType() : paramClass;
            Class<?> internalJavaType2 = this.javaToRdfTypeMap.get(componentClass);
            Class<?> rdfClass = internalJavaType2 != null ? internalJavaType2 : componentClass;
            ConvertFunctionRaw inputConverter = internalJavaType2 == null ? null : this.getPreConvert(internalJavaType2, componentClass);
            String datatypeIri = this.typeByClassOverrides.get(rdfClass);
            RDFDatatype dtype = datatypeIri != null ? this.typeMapper.getTypeByName(datatypeIri) : this.typeMapper.getTypeByClass(rdfClass);
            boolean bl = isNodeType = rdfClass != null && Node.class.isAssignableFrom(rdfClass);
            if (dtype == null && !isNodeType) {
                throw new RuntimeException(String.format("TypeMapper does not contain an entry for the java class %1$s derived from %2$s", internalJavaType2, paramClass));
            }
            DefaultValue defaultValueAnnotation = (DefaultValue)IterableUtils.expectZeroOrOneItems((Iterable)Iterables.filter(Arrays.asList(as), DefaultValue.class));
            Object defaultValue = null;
            if (defaultValueAnnotation != null) {
                String str;
                if (firstDefaultValueIdx < 0) {
                    firstDefaultValueIdx = i;
                }
                if ((str = defaultValueAnnotation.value()) != null) {
                    Object internalObj = dtype.parse(str);
                    defaultValue = ConverterRegistries.convert((ConverterRegistry)this.converterRegistry, (Object)internalObj, paramClass);
                } else {
                    defaultValue = null;
                }
            } else if (firstDefaultValueIdx >= 0) {
                throw new RuntimeException(String.format("Parameter at index %d does not declare a default value although a prior parameter at index %d declared one", i, firstDefaultValueIdx));
            }
            params[i] = param = new Param(paramClass, rdfClass, inputConverter, defaultValue);
        }
        FunctionAdapter result = new FunctionAdapter(method, invocationTarget, returnValueConverter, params, this.typeMapper, this.converterRegistry);
        return result;
    }

    public static ConvertFunctionRaw createNodeValueMapper(Class<?> clz, ConverterRegistry converterRegistry, TypeMapper typeMapper, Map<Class<?>, String> typeByClassOverrides) {
        ConvertFunctionRaw result = converterRegistry.getConverter(clz, NodeValue.class);
        if (result == null) {
            RDFDatatype dtype;
            String datatypeIri = typeByClassOverrides.get(clz);
            RDFDatatype rDFDatatype = dtype = datatypeIri != null ? typeMapper.getTypeByName(datatypeIri) : typeMapper.getTypeByClass(clz);
            if (dtype == null) {
                throw new RuntimeException(String.format("No RDF datatype registered for %1$s", clz));
            }
            result = new ConvertFunctionRawImpl(clz, NodeValue.class, obj -> {
                NodeValue r = null;
                if (obj != null) {
                    Node node = NodeFactory.createLiteralByValue((Object)obj, (RDFDatatype)dtype);
                    r = NodeValue.makeNode((Node)node);
                }
                return r;
            });
        }
        return result;
    }

    private /* synthetic */ Object lambda$wrap$1(Class componentClass, int n, Class paramClass, Object in) {
        NodeList nodeList = (NodeList)in;
        Object xr = null;
        if (nodeList != null) {
            int xn = nodeList.size();
            xr = Array.newInstance(componentClass, n);
            int xi = 0;
            for (Node node : nodeList) {
                Object value = ConverterRegistries.convert((ConverterRegistry)this.converterRegistry, (Object)node, (Class)componentClass);
                Array.set(xr, xi, value);
                ++xi;
            }
        }
        return paramClass.cast(xr);
    }
}

