/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.arq.functionbinder;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.jenax.arq.functionbinder.FunctionAdapter;
import org.aksw.jenax.arq.functionbinder.FunctionBinder;
import org.aksw.jenax.arq.functionbinder.FunctionBinders;
import org.aksw.jenax.arq.functionbinder.FunctionGenerator;
import org.aksw.jenax.arq.functionbinder.FunctionMultiAdapter;
import org.aksw.jenax.arq.functionbinder.FunctionWrapperBase;
import org.aksw.jenax.arq.util.security.ArqSecurity;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.function.Function;
import org.apache.jena.sparql.function.FunctionEnv;
import org.apache.jena.sparql.function.FunctionFactory;
import org.apache.jena.sparql.function.FunctionRegistry;
import org.apache.jena.sparql.util.Context;

public class FunctionRegistryWithAutoProxying
extends FunctionRegistry {
    public FunctionFactory get(String uri) {
        int methodNameSplit;
        String prefix;
        FunctionFactory result = null;
        if (!this.isRegistered(uri) && uri.startsWith(prefix = "java:") && (methodNameSplit = uri.lastIndexOf("#")) >= 0) {
            String fqcn = uri.substring(prefix.length(), methodNameSplit);
            String methodName = uri.substring(methodNameSplit + 1);
            String source = null;
            int sourceSplit = methodName.indexOf(64);
            if (sourceSplit >= 0) {
                String tmp = methodName.substring(0, sourceSplit);
                source = methodName.substring(sourceSplit + 1);
                methodName = tmp;
            }
            FunctionBinder binder = FunctionBinders.getDefaultFunctionBinder();
            FunctionGenerator generator = binder.getFunctionGenerator();
            Class<?> cls = null;
            try {
                cls = Class.forName(fqcn);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            String finalMethodName = methodName;
            if (cls != null) {
                List<FunctionAdapter> methods = Arrays.asList(cls.getMethods()).stream().filter(m -> m.getName().equals(finalMethodName)).flatMap(method -> {
                    Stream<Object> r;
                    try {
                        FunctionAdapter adapter = generator.wrap((Method)method);
                        r = Stream.of(adapter);
                    }
                    catch (Exception e) {
                        r = Stream.empty();
                    }
                    return r;
                }).collect(Collectors.toList());
                FunctionMultiAdapter fn = methods.size() == 1 ? (Function)methods.iterator().next() : new FunctionMultiAdapter(methods);
                result = anyUri -> new FunctionWrapperBase(fn){

                    @Override
                    public NodeValue exec(Binding binding, ExprList args, String uri, FunctionEnv env) {
                        ArqSecurity.requireFileAccess((Context)env.getContext());
                        return super.exec(binding, args, uri, env);
                    }
                };
                super.put(uri, result);
            }
        }
        if (result == null) {
            result = super.get(uri);
        }
        return result;
    }
}

