/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.difs.builder;

import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Streams;
import com.kstruct.gethostname4j.Hostname;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategy;
import org.aksw.commons.io.util.symlink.SymbolicLinkStrategyStandard;
import org.aksw.commons.lock.LockManager;
import org.aksw.commons.lock.LockManagerCompound;
import org.aksw.commons.lock.LockManagerPath;
import org.aksw.commons.lock.ThreadLockManager;
import org.aksw.commons.txn.api.TxnMgr;
import org.aksw.commons.txn.impl.ResourceRepoImpl;
import org.aksw.commons.txn.impl.ResourceRepository;
import org.aksw.commons.txn.impl.TxnMgrImpl;
import org.aksw.difs.index.api.RdfTermIndexerFactory;
import org.aksw.difs.index.impl.DatasetGraphIndexerFromFileSystem;
import org.aksw.difs.sys.vocab.jena.DIFS;
import org.aksw.difs.system.domain.IndexDefinition;
import org.aksw.difs.system.domain.StoreDefinition;
import org.aksw.jena_sparql_api.difs.main.DatasetGraphFromTxnMgr;
import org.apache.jena.dboe.sys.ProcessUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.DatasetGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DifsFactory {
    private static final Logger logger = LoggerFactory.getLogger(DifsFactory.class);
    protected SymbolicLinkStrategy symbolicLinkStrategy;
    protected Path repoRootPath;
    protected Path configFileRelPath;
    protected Path storeRelPath;
    protected Path indexRelPath;
    protected boolean createIfNotExists;
    protected boolean isParallel = true;
    protected StoreDefinition storeDefinition;
    protected long maximumNamedGraphCacheSize = -1L;
    protected boolean useJournal = true;
    protected Random random = new Random();

    public static DifsFactory newInstance() {
        DifsFactory result = new DifsFactory();
        return result;
    }

    public boolean isCreateIfNotExists() {
        return this.createIfNotExists;
    }

    public DifsFactory setParallel(boolean isParallel) {
        this.isParallel = isParallel;
        return this;
    }

    public DifsFactory setCreateIfNotExists(boolean createIfNotExists) {
        this.createIfNotExists = createIfNotExists;
        return this;
    }

    public DifsFactory setMaximumNamedGraphCacheSize(long size) {
        this.maximumNamedGraphCacheSize = size;
        return this;
    }

    public static Stream<Resource> listResources(Model model, Collection<Property> properties) {
        return properties.stream().flatMap(p -> Streams.stream((Iterator)model.listResourcesWithProperty(p)));
    }

    public StoreDefinition loadStoreDefinition(Path confFilePath) throws IOException {
        StoreDefinition result;
        String filenameOrIri = confFilePath.getFileName().toString();
        Lang lang = RDFDataMgr.determineLang((String)filenameOrIri, null, null);
        Model model = ModelFactory.createDefaultModel();
        try (InputStream in = Files.newInputStream(confFilePath, new OpenOption[0]);){
            RDFDataMgr.read((Model)model, (InputStream)in, (Lang)lang);
        }
        List<Property> mainProperties = Arrays.asList(DIFS.storePath, DIFS.indexPath, DIFS.index, DIFS.heartbeatInterval);
        Set resources = DifsFactory.listResources(model, mainProperties).collect(Collectors.toSet());
        if (resources.isEmpty()) {
            logger.info("No config resources found in " + filenameOrIri);
            result = null;
        } else if (resources.size() == 1) {
            result = (StoreDefinition)((Resource)resources.iterator().next()).as(StoreDefinition.class);
        } else {
            throw new RuntimeException("Multiple configurations detected");
        }
        return result;
    }

    public DatasetGraphIndexerFromFileSystem loadIndexDefinition(IndexDefinition idxDef) {
        try {
            Node p = idxDef.getPredicate();
            String folderName = idxDef.getPath();
            String className = idxDef.getMethod();
            Class<?> clz = Class.forName(className);
            Object obj = clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            RdfTermIndexerFactory indexer = (RdfTermIndexerFactory)obj;
            DatasetGraphIndexerFromFileSystem result = this.addIndex(p, folderName, indexer.getMapper());
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public DifsFactory setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
        return this;
    }

    public boolean isUseJournal() {
        return this.useJournal;
    }

    public DifsFactory setRepoRootPath(Path repoRootPath) {
        this.repoRootPath = repoRootPath;
        return this;
    }

    public Path getRepoRootPath() {
        return this.repoRootPath;
    }

    public DifsFactory setConfigFile(Path configFile) {
        this.configFileRelPath = configFile;
        return this;
    }

    public Path getConfigFile() {
        return this.configFileRelPath;
    }

    public StoreDefinition getStoreDefinition() {
        return this.storeDefinition;
    }

    public DifsFactory setStoreDefinition(StoreDefinition storeDefinition) {
        this.storeDefinition = storeDefinition;
        return this;
    }

    public DifsFactory setStoreDefinition(Consumer<StoreDefinition> mutator) {
        this.storeDefinition = (StoreDefinition)ModelFactory.createDefaultModel().createResource().as(StoreDefinition.class);
        mutator.accept(this.storeDefinition);
        return this;
    }

    public DatasetGraphIndexerFromFileSystem addIndex(Node predicate, String name, Function<Node, String[]> objectToPath) throws IOException {
        Path repoRootPath = this.repoRootPath == null ? this.configFileRelPath.getParent() : this.repoRootPath;
        Path indexFolder = repoRootPath.resolve("index").resolve(name);
        ResourceRepository resStore = ResourceRepoImpl.createWithUriToPath((Path)repoRootPath.resolve("store"));
        Objects.requireNonNull(this.symbolicLinkStrategy, "Symbolic link strategy not set");
        DatasetGraphIndexerFromFileSystem result = new DatasetGraphIndexerFromFileSystem(this.symbolicLinkStrategy, resStore, predicate, indexFolder, objectToPath);
        return result;
    }

    public SymbolicLinkStrategy getSymbolicLinkStrategy() {
        return this.symbolicLinkStrategy;
    }

    public DifsFactory setSymbolicLinkStrategy(SymbolicLinkStrategy symlinkStrategy) {
        this.symbolicLinkStrategy = symlinkStrategy;
        return this;
    }

    protected Path getConfigFilePath() {
        Path result = this.repoRootPath == null ? this.configFileRelPath : (this.configFileRelPath == null ? this.repoRootPath.resolve("store.conf.ttl") : this.repoRootPath.resolve(this.configFileRelPath));
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StoreDefinition createEffectiveStoreDefinition() throws IOException {
        Path configFile = this.getConfigFile();
        if (configFile == null) {
            if (this.storeDefinition != null) return this.storeDefinition;
            throw new RuntimeException("Neither config file nor store definition provided");
        }
        if (Files.exists(configFile, new LinkOption[0])) return this.loadStoreDefinition(configFile);
        if (!this.createIfNotExists) throw new RuntimeException(String.format("Config file %s does not exist and auto-creation is disabled", configFile));
        if (this.storeDefinition == null) {
            throw new RuntimeException(String.format("Config file %s does not exist and no default config was specified", configFile));
        }
        logger.info(String.format("Creating new config file %s", configFile));
        try (OutputStream out = Files.newOutputStream(configFile, StandardOpenOption.CREATE, StandardOpenOption.WRITE);){
            RDFDataMgr.write((OutputStream)out, (Model)this.storeDefinition.getModel(), (RDFFormat)RDFFormat.TURTLE_PRETTY);
            return this.storeDefinition;
        }
    }

    public TxnMgr createTxnMgr() throws IOException {
        StoreDefinition effStoreDef = this.createEffectiveStoreDefinition();
        return this.createTxnMgr(effStoreDef);
    }

    public TxnMgr createTxnMgr(StoreDefinition effStoreDef) throws IOException {
        PathMatcher pathMatcher;
        ResourceRepository resStore;
        Path repoRootPath;
        long heartbeatIntervalMs = Optional.ofNullable(effStoreDef.getHeartbeatInterval()).orElse(5000L);
        Duration heartbeatInterval = Duration.ofMillis(heartbeatIntervalMs);
        boolean isSingleFileMode = Boolean.TRUE.equals(effStoreDef.isSingleFile());
        Path path = repoRootPath = this.repoRootPath != null ? this.repoRootPath : this.getConfigFile().getParent();
        if (this.createIfNotExists) {
            Files.createDirectories(repoRootPath, new FileAttribute[0]);
        }
        Path storeRelPath = Optional.ofNullable(effStoreDef.getStorePath()).map(x$0 -> Path.of(x$0, new String[0])).orElse(Path.of("", new String[0]));
        Path indexRelPath = Optional.ofNullable(effStoreDef.getIndexPath()).map(x$0 -> Path.of(x$0, new String[0])).orElse(Path.of("index", new String[0]));
        Path storeAbsPath = repoRootPath.resolve(storeRelPath);
        Path indexAbsPath = repoRootPath.resolve(indexRelPath);
        Path txnStore = repoRootPath.resolve("txns");
        LockManagerPath processLockMgr = new LockManagerPath(repoRootPath);
        ThreadLockManager threadLockMgr = new ThreadLockManager();
        LockManagerCompound lockMgr = new LockManagerCompound(Arrays.asList(processLockMgr, threadLockMgr));
        FileSystem repoFs = repoRootPath.getFileSystem();
        if (isSingleFileMode) {
            String fileName = storeAbsPath.getFileName().toString();
            storeAbsPath = storeAbsPath.getParent();
            resStore = new ResourceRepoImpl(storeAbsPath, iri -> new String[0]);
            pathMatcher = repoFs.getPathMatcher("glob:**/" + fileName);
        } else {
            resStore = ResourceRepoImpl.createWithUriToPath((Path)storeAbsPath);
            pathMatcher = repoFs.getPathMatcher("glob:**/*.trig");
        }
        ResourceRepository resLocks = ResourceRepoImpl.createWithUrlEncode((Path)repoRootPath.resolve("locks"));
        SymbolicLinkStrategy effSymlinkStrategy = this.symbolicLinkStrategy != null ? this.symbolicLinkStrategy : new SymbolicLinkStrategyStandard();
        String hostname = Hostname.getHostname();
        int pid = ProcessUtils.getPid((int)-1);
        String txnMgrId = hostname + "-" + pid + "-" + this.random.nextInt();
        logger.info("Creating txn manager with id: " + txnMgrId);
        TxnMgrImpl result = new TxnMgrImpl(txnMgrId, repoRootPath, pathMatcher, (TemporalAmount)heartbeatInterval, (LockManager)lockMgr, txnStore, resStore, resLocks, effSymlinkStrategy);
        return result;
    }

    public Dataset connectAsDataset() throws IOException {
        DatasetGraph dg = this.connect();
        return DatasetFactory.wrap((DatasetGraph)dg);
    }

    public DatasetGraph connect() throws IOException {
        boolean isSingleFileMode;
        StoreDefinition effStoreDef = this.createEffectiveStoreDefinition();
        boolean allowEmptyGraphs = Optional.ofNullable(effStoreDef.isAllowEmptyGraphs()).orElse(false);
        TxnMgr txnMgr = this.createTxnMgr(effStoreDef);
        Collection indexers = effStoreDef.getIndexDefinition().stream().map(this::loadIndexDefinition).collect(Collectors.toList());
        CacheBuilder namedGraphCacheBuilder = CacheBuilder.newBuilder();
        if (this.maximumNamedGraphCacheSize > 0L) {
            namedGraphCacheBuilder.maximumSize(this.maximumNamedGraphCacheSize);
        }
        String dataFileName = (isSingleFileMode = Boolean.TRUE.equals(effStoreDef.isSingleFile())) ? Path.of(this.storeDefinition.getStorePath(), new String[0]).getFileName().toString() : "data.trig";
        DatasetGraphFromTxnMgr result = new DatasetGraphFromTxnMgr(dataFileName, this.useJournal, txnMgr, allowEmptyGraphs, this.isParallel, indexers, namedGraphCacheBuilder);
        result.cleanupStaleTxns();
        logger.info("Done checking existing txns");
        return result;
    }
}

