/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.collections.generator.Generator;
import org.aksw.jena_sparql_api.data_query.api.PathAccessorRdf;
import org.aksw.jena_sparql_api.data_query.impl.QueryFragment;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorImpl2;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.syntax.Element;

public class PathToRelationMapper<P> {
    protected PathAccessorRdf<P> pathAccessor;
    protected Map<P, Fragment2> map;
    protected Set<Var> forbiddenVars;
    protected Generator<Var> varGen;

    public Map<P, Fragment2> getMap() {
        return this.map;
    }

    public static <P> NodeTransform createNodeTransformSubstitutePathReferences(Function<? super Node, ? extends P> tryMapToPath, Function<? super P, ? extends Node> mapToNode) {
        return n -> Optional.ofNullable(tryMapToPath.apply((Node)n)).map(x -> (Node)mapToNode.apply((Object)x)).orElse((Node)n);
    }

    public PathToRelationMapper(PathAccessorRdf<P> pathAccessor) {
        this(pathAccessor, null);
    }

    public PathToRelationMapper(PathAccessorRdf<P> pathAccessor, String baseName) {
        this(pathAccessor, new HashMap(), new LinkedHashSet<Var>(), (Generator<Var>)VarGeneratorImpl2.create((String)baseName));
    }

    public PathAccessorRdf<P> getPathAccessor() {
        return this.pathAccessor;
    }

    public Node getNode(P path) {
        Fragment2 br = this.getOrCreate(path);
        Var result = br.getTargetVar();
        return result;
    }

    public PathToRelationMapper(PathAccessorRdf<P> pathAccessor, Map<P, Fragment2> map, Set<Var> forbiddenVars, Generator<Var> varGen) {
        this.pathAccessor = pathAccessor;
        this.map = map;
        this.forbiddenVars = forbiddenVars;
        this.varGen = varGen;
    }

    public Fragment2 getOverallRelation(P path) {
        this.getOrCreate(path);
        SuccessorsFunction fn = p -> Optional.ofNullable(this.pathAccessor.getParent(p)).map(Collections::singleton).orElse(Collections.emptySet());
        ArrayList segments = Lists.newArrayList((Iterable)Traverser.forTree((SuccessorsFunction)fn).depthFirstPostOrder(path));
        List brs = segments.stream().map(this.map::get).collect(Collectors.toList());
        List elts = brs.stream().filter(x -> !x.isEmpty()).map(HasElement::getElement).collect(Collectors.toList());
        Element elt = ElementUtils.groupIfNeeded(elts);
        Var s = ((Fragment2)Iterables.getFirst(brs, null)).getSourceVar();
        Var o = ((Fragment2)Iterables.getLast(brs, null)).getTargetVar();
        Fragment2Impl result = new Fragment2Impl(elt, s, o);
        return result;
    }

    public Fragment2 getOrCreate(P path) {
        Fragment2 result = QueryFragment.toElement(path, this.pathAccessor, this.map, this.forbiddenVars, this.varGen);
        return result;
    }
}

