/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.aksw.commons.beans.model.EntityModel;
import org.aksw.commons.beans.model.EntityOps;
import org.aksw.commons.beans.model.PropertyOps;
import org.aksw.commons.collections.trees.TreeUtils;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.facete.v3.api.path.Resolver;
import org.aksw.facete.v3.api.path.StepImpl;
import org.aksw.facete.v3.experimental.ResolverNodeImpl;
import org.aksw.facete.v3.experimental.ResolverTemplate;
import org.aksw.facete.v3.experimental.Resolvers;
import org.aksw.jena_sparql_api.algebra.utils.AlgebraUtils;
import org.aksw.jena_sparql_api.data_query.api.DataNode;
import org.aksw.jena_sparql_api.data_query.api.DataQuery;
import org.aksw.jena_sparql_api.data_query.api.DataQueryVarView;
import org.aksw.jena_sparql_api.data_query.api.NodePath;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jena_sparql_api.data_query.api.QuerySpec;
import org.aksw.jena_sparql_api.data_query.api.QuerySpecImpl;
import org.aksw.jena_sparql_api.data_query.api.ResolverNode;
import org.aksw.jena_sparql_api.data_query.api.SPath;
import org.aksw.jena_sparql_api.data_query.impl.CountUtils;
import org.aksw.jena_sparql_api.data_query.impl.FacetedQueryGenerator;
import org.aksw.jena_sparql_api.data_query.impl.NodePathletPath;
import org.aksw.jena_sparql_api.data_query.impl.NodeTransformPathletPathResolver;
import org.aksw.jena_sparql_api.data_query.impl.NodeTransformPathletVarRefResolver;
import org.aksw.jena_sparql_api.data_query.impl.PathAccessorSPath;
import org.aksw.jena_sparql_api.data_query.impl.PathAccessorUtils;
import org.aksw.jena_sparql_api.data_query.impl.PathToRelationMapper;
import org.aksw.jena_sparql_api.data_query.impl.SPathImpl;
import org.aksw.jena_sparql_api.mapper.impl.type.RdfTypeFactoryImpl;
import org.aksw.jena_sparql_api.pathlet.Path;
import org.aksw.jena_sparql_api.pathlet.PathletJoinerImpl;
import org.aksw.jena_sparql_api.pathlet.PathletSimple;
import org.aksw.jena_sparql_api.relationlet.Relationlet;
import org.aksw.jena_sparql_api.relationlet.RelationletElementImpl;
import org.aksw.jena_sparql_api.relationlet.RelationletSimple;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.triple.TripleUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactories;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.FragmentImpl;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingComparator;
import org.apache.jena.sparql.expr.E_Random;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.aggregate.AggSample;
import org.apache.jena.sparql.expr.aggregate.Aggregator;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.VarUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataQueryImpl<T extends RDFNode>
implements DataQuery<T> {
    private static final Logger logger = LoggerFactory.getLogger(DataQueryImpl.class);
    protected RDFDataSource dataSource;
    protected Element baseElement;
    protected List<Var> primaryKeyVars;
    protected Node superRootNode;
    protected Var defaultVar;
    protected Template template;
    protected List<DataNode> dataNodes;
    protected Long limit;
    protected Long offset;
    protected Fragment1 filter;
    protected List<Element> directFilters = new ArrayList<Element>();
    protected boolean ordered;
    protected boolean randomOrder;
    protected boolean sample;
    protected Random pseudoRandom = null;
    protected Class<T> resultClass;
    protected List<SortCondition> sortConditions = new ArrayList<SortCondition>();
    protected Set<Path> projectedPaths = new LinkedHashSet<Path>();

    public DataQueryImpl(RDFDataSource dataSource, Fragment1 baseRelation, Template template, Class<T> resultClass) {
        this(dataSource, baseRelation.getElement(), baseRelation.getVar(), template, resultClass);
    }

    public DataQueryImpl(RDFDataSource dataSource, Element baseQueryPattern, Var rootVar, Template template, Class<T> resultClass) {
        this(dataSource, baseQueryPattern, Arrays.asList(rootVar), (Node)rootVar, rootVar, template, resultClass);
    }

    public DataQueryImpl(RDFDataSource dataSource, Element baseElement, List<Var> primaryKeyVars, Node superRootNode, Var defaultVar, Template template, Class<T> resultClass) {
        this.dataSource = dataSource;
        this.baseElement = baseElement;
        this.primaryKeyVars = primaryKeyVars;
        this.superRootNode = superRootNode;
        this.defaultVar = defaultVar;
        this.template = template;
        this.resultClass = resultClass;
    }

    @Deprecated
    public DataQueryImpl(SparqlQueryConnection conn, Fragment1 baseRelation, Template template, Class<T> resultClass) {
        this(conn, baseRelation.getElement(), baseRelation.getVar(), template, resultClass);
    }

    @Deprecated
    public DataQueryImpl(SparqlQueryConnection conn, Element baseQueryPattern, Var rootVar, Template template, Class<T> resultClass) {
        this(conn, baseQueryPattern, Arrays.asList(rootVar), (Node)rootVar, rootVar, template, resultClass);
    }

    @Deprecated
    public DataQueryImpl(SparqlQueryConnection conn, Element baseElement, List<Var> primaryKeyVars, Node superRootNode, Var defaultVar, Template template, Class<T> resultClass) {
        this(RDFDataSources.ofQueryConnection((SparqlQueryConnection)conn), baseElement, primaryKeyVars, superRootNode, defaultVar, template, resultClass);
    }

    public <U extends RDFNode> DataQuery<U> as(Class<U> clazz) {
        return new DataQueryImpl<U>(this.dataSource, this.baseElement, this.primaryKeyVars, this.superRootNode, this.defaultVar, this.template, clazz);
    }

    public RDFDataSource dataSource() {
        return this.dataSource;
    }

    public DataQuery<T> dataSource(RDFDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public Var getDefaultVar() {
        return this.defaultVar;
    }

    public DataQuery<T> limit(Long limit) {
        this.limit = limit;
        return this;
    }

    public DataQuery<T> offset(Long offset) {
        this.offset = offset;
        return this;
    }

    public DataQuery<T> sample(boolean onOrOff) {
        this.sample = onOrOff;
        return this;
    }

    public boolean isSampled() {
        return this.sample;
    }

    public DataQuery<T> ordered(boolean onOrOff) {
        this.ordered = onOrOff;
        return this;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isRandomOrder() {
        return this.randomOrder;
    }

    public DataQuery<T> randomOrder(boolean onOrOff) {
        this.randomOrder = onOrOff;
        return this;
    }

    public DataQuery<T> pseudoRandom(Random pseudoRandom) {
        this.pseudoRandom = pseudoRandom;
        return this;
    }

    public Concept fetchPredicates() {
        throw new RuntimeException("not implemented yet");
    }

    public DataNode getRoot() {
        throw new RuntimeException("not implemented yet");
    }

    public DataQuery<T> addOptional(Property property) {
        Path path = Path.newPath().optional((Object)property).fwd((Resource)property);
        this.projectedPaths.add(path);
        return this;
    }

    public DataQuery<T> add(Property property) {
        Path path = Path.newPath().fwd((Resource)property);
        this.projectedPaths.add(path);
        return this;
    }

    public DataQuery<T> filter(Fragment1 concept) {
        if (concept != null) {
            this.filter = this.filter == null ? concept : this.filter.joinOn(new Var[]{this.filter.getVar()}).with(concept).toFragment1();
        }
        return this;
    }

    public DataQuery<T> filterDirect(Element element) {
        this.directFilters.add(element);
        return this;
    }

    public DataQuery<T> peek(Consumer<? super DataQuery<T>> consumer) {
        consumer.accept(this);
        return this;
    }

    public DataQuery<T> filterUsing(Fragment relation, String ... attrNames) {
        if (relation != null) {
            List vars = Arrays.asList(attrNames).stream().map(this::resolveAttrToVar).collect(Collectors.toList());
            ArrayList baseVars = new ArrayList(PatternVars.vars((Element)this.baseElement));
            this.baseElement = new FragmentImpl(this.baseElement, baseVars).joinOn(vars).with(relation, new Var[0]).getElement();
        }
        return this;
    }

    public Var resolveAttrToVar(String attr) {
        EntityModel entityOps = EntityModel.createDefaultModel(this.resultClass, null);
        PropertyOps pops = entityOps.getProperty(attr);
        String iri = RdfTypeFactoryImpl.createDefault().getIri((EntityOps)entityOps, pops);
        Triple match = this.template.getBGP().getList().stream().filter((? super T t) -> t.getPredicate().getURI().equals(iri)).findFirst().orElse(null);
        Node node = Optional.ofNullable(match.getObject()).orElseThrow(() -> new RuntimeException("No member with name " + attr + " in " + String.valueOf(this.resultClass)));
        Var result = (Var)node;
        return result;
    }

    public NodePath get(String attr) {
        Var var = this.resolveAttrToVar(attr);
        Model m = ModelFactory.createDefaultModel();
        SPathImpl tmp = new SPathImpl(m.createResource().asNode(), (EnhGraph)m);
        tmp.setAlias(var.getName());
        NodePath result = new NodePath((SPath)tmp);
        return result;
    }

    public DataQuery<T> filter(Expr expr) {
        PathAccessorSPath pathAccessor = new PathAccessorSPath();
        PathToRelationMapper mapper = new PathToRelationMapper(pathAccessor, "w");
        Collection<Element> elts = FacetedQueryGenerator.createElementsForExprs(mapper, pathAccessor, Collections.singleton(expr), false);
        SPath root = PathAccessorUtils.getPathsMentioned(expr, arg_0 -> ((PathAccessor)pathAccessor).tryMapToPath(arg_0)).values().stream().map(p -> (SPath)TreeUtils.findRoot((Object)p, arg_0 -> ((PathAccessor)pathAccessor).getParent(arg_0))).findFirst().orElseThrow(() -> new RuntimeException("Should not happen: Expr without path - " + String.valueOf(expr)));
        this.filterDirect(ElementUtils.groupIfNeeded(elts));
        return this;
    }

    public Node getSuperRootNode() {
        return this.superRootNode;
    }

    public List<Var> getPrimaryKeyVars() {
        return this.primaryKeyVars;
    }

    public QuerySpec toConstructQueryNew() {
        Element effectivePattern;
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>();
        vars.addAll(this.primaryKeyVars);
        Query query = new Query();
        query.setQuerySelectType();
        Element baseQueryPattern = this.baseElement();
        Element element = effectivePattern = this.filter == null ? baseQueryPattern : new FragmentImpl(baseQueryPattern, new ArrayList(PatternVars.vars((Element)baseQueryPattern))).joinOn(new Var[]{this.defaultVar}).with(this.filter).getElement();
        if (!this.directFilters.isEmpty()) {
            effectivePattern = ElementUtils.groupIfNeeded((Iterable)Iterables.concat(Collections.singleton(effectivePattern), this.directFilters));
        }
        boolean deterministic = this.pseudoRandom != null;
        LinkedHashSet<Var> allVars = new LinkedHashSet<Var>();
        allVars.addAll(vars);
        allVars.addAll(PatternVars.vars((Element)baseQueryPattern));
        VarGeneratorBlacklist varGen = VarGeneratorBlacklist.create(allVars);
        if (this.sample) {
            Var innerRootVar = (Var)varGen.next();
            if (this.primaryKeyVars.size() != 1 || !this.primaryKeyVars.get(0).equals((Object)this.superRootNode)) {
                throw new RuntimeException("Sampling can only be done if superRootNode is equal to the only primaryKeyVar " + String.valueOf(this.superRootNode) + " != " + String.valueOf(this.primaryKeyVars));
            }
            Var rootVar = (Var)this.superRootNode;
            Element innerE = ElementUtils.createRenamedElement((Element)effectivePattern, Collections.singletonMap(rootVar, innerRootVar));
            Query inner = new Query();
            inner.setQuerySelectType();
            inner.setQueryPattern(innerE);
            Expr agg = inner.allocAggregate((Aggregator)new AggSample((Expr)new ExprVar(innerRootVar)));
            for (Var var : this.primaryKeyVars) {
                inner.getProject().add(var, agg);
            }
            if (!this.randomOrder || !deterministic) {
                QueryUtils.applySlice((Query)inner, (Long)this.offset, (Long)this.limit, (boolean)false);
            }
            Element e = ElementUtils.groupIfNeeded((Element[])new Element[]{new ElementSubQuery(inner), effectivePattern});
            query.setQueryPattern(e);
        } else {
            query.setDistinct(true);
            query.setQueryPattern(effectivePattern);
            if (!this.randomOrder || !deterministic) {
                QueryUtils.applySlice((Query)query, (Long)this.offset, (Long)this.limit, (boolean)false);
            }
        }
        if (this.ordered) {
            for (Var primaryKeyVar : this.primaryKeyVars) {
                query.addOrderBy((Node)primaryKeyVar, 1);
            }
        }
        if (this.randomOrder && !deterministic) {
            query.addOrderBy((Expr)new E_Random(), 1);
        }
        for (SortCondition sc : this.sortConditions) {
            query.addOrderBy(sc);
        }
        Template effectiveTemplate = this.template != null ? new Template(new BasicPattern(this.template.getBGP())) : new Template(new BasicPattern());
        Query resolverConstruct = new Query();
        resolverConstruct.setQueryConstructType();
        resolverConstruct.setConstructTemplate(effectiveTemplate);
        resolverConstruct.setQueryPattern(effectivePattern);
        ResolverTemplate resolver = Resolvers.from(resolverConstruct, this.superRootNode);
        PathletJoinerImpl pathlet = new PathletJoinerImpl((Resolver)resolver);
        Var pathRoot = this.defaultVar;
        pathlet.add((Relationlet)new PathletSimple(pathRoot, pathRoot, new RelationletElementImpl(query.getQueryPattern()).pinAllVars()));
        LinkedHashSet<Triple> newTemplateTriples = new LinkedHashSet<Triple>();
        for (Path path : this.projectedPaths) {
            ResolverTemplate resolverTemplate = Resolvers.from(resolverConstruct, this.superRootNode);
            pathlet.resolvePath(path);
            List steps = Path.getSteps((Path)path);
            Node startNode = resolverTemplate.getStartNode();
            for (int i = 0; i < steps.size(); ++i) {
                ResolverTemplate next;
                StepImpl step = (StepImpl)steps.get(i);
                if (!(step.getKey() instanceof P_Path0)) continue;
                P_Path0 stepPath = (P_Path0)step.getKey();
                Node p = stepPath.getNode();
                boolean isFwd = stepPath.isForward();
                String alias = step.getAlias();
                ResolverTemplate resolverTemplate2 = next = resolverTemplate != null ? resolverTemplate.resolveTemplateSimple(stepPath, alias) : null;
                if (next != null) {
                    startNode = next.getStartNode();
                    resolverTemplate = next;
                    continue;
                }
                Path endPath = Path.newPath();
                for (StepImpl tmp : steps.subList(0, i)) {
                    endPath = endPath.appendStep(tmp);
                }
                endPath = endPath.appendStep(step);
                NodePathletPath endNode = NodePathletPath.create(endPath);
                Triple t = TripleUtils.create((Node)startNode, (Node)p, (Node)endNode, (boolean)isFwd);
                newTemplateTriples.add(t);
            }
        }
        BasicPattern basicPattern = effectiveTemplate.getBGP();
        for (Triple t : newTemplateTriples) {
            basicPattern.add(t);
        }
        NodeTransformPathletPathResolver nodeTransformPathletPathResolver = new NodeTransformPathletPathResolver(pathlet);
        query = QueryUtils.applyNodeTransform((Query)query, (NodeTransform)nodeTransformPathletPathResolver);
        effectiveTemplate = DataQueryImpl.applyNodeTransform(effectiveTemplate, nodeTransformPathletPathResolver);
        RelationletSimple rn = pathlet.materialize();
        NodeTransformPathletVarRefResolver xform2 = new NodeTransformPathletVarRefResolver(rn);
        query = QueryUtils.applyNodeTransform((Query)query, (NodeTransform)xform2);
        effectiveTemplate = DataQueryImpl.applyNodeTransform(effectiveTemplate, xform2);
        Element e = rn.getElement();
        VarUtils.addVars(vars, (BasicPattern)effectiveTemplate.getBGP());
        VarExprList vel = query.getProject();
        for (Var v : vars) {
            vel.add(v);
        }
        query.setQueryPattern(e);
        Rewrite rewrite = AlgebraUtils.createDefaultRewriter();
        query = QueryUtils.rewrite((Query)query, arg_0 -> ((Rewrite)rewrite).rewrite(arg_0));
        Query c = QueryUtils.selectToConstruct((Query)query, (Template)effectiveTemplate);
        return new QuerySpecImpl(c, this.superRootNode, this.primaryKeyVars);
    }

    public static Template applyNodeTransform(Template template, NodeTransform xform) {
        BasicPattern before = template.getBGP();
        BasicPattern after = NodeTransformLib.transform((NodeTransform)xform, (BasicPattern)before);
        Template result = new Template(after);
        return result;
    }

    public static List<Map.Entry<P_Path0, String>> toSimpleSteps(Path path) {
        ArrayList<Map.Entry<P_Path0, String>> result = new ArrayList<Map.Entry<P_Path0, String>>();
        for (StepImpl step : Path.getSteps((Path)path)) {
            Object key = step.getKey();
            if (!(key instanceof P_Path0)) continue;
            String alias = step.getAlias();
            P_Path0 p = (P_Path0)key;
            result.add(Maps.immutableEntry((Object)p, (Object)alias));
        }
        return result;
    }

    public Flowable<T> exec() {
        boolean deterministic;
        Objects.requireNonNull(this.dataSource);
        QuerySpec e = this.toConstructQueryNew();
        logger.debug("Executing query:\n" + String.valueOf(e));
        Flowable rawFlow = SparqlRx.execConstructGrouped((RDFDataSource)this.dataSource, (Query)e.getQuery(), (List)e.getPrimaryKeyVars(), (Node)e.getRootNode(), (boolean)true);
        boolean bl = deterministic = this.pseudoRandom != null;
        if (deterministic && this.randomOrder) {
            List scs = e.getPrimaryKeyVars().stream().map(v -> new SortCondition(v, 1)).collect(Collectors.toList());
            BindingComparator cmp = new BindingComparator(scs);
            rawFlow = rawFlow.toList().map(arg_0 -> this.lambda$exec$6((Comparator)cmp, arg_0)).toFlowable().flatMap(Flowable::fromIterable);
        }
        Flowable result = rawFlow.map(Map.Entry::getValue).map(r -> r.as(this.resultClass));
        return result;
    }

    public DataQuery<T> addOrderBy(Node node, int direction) {
        this.sortConditions.add(new SortCondition(node, direction));
        return this;
    }

    public DataQuery<T> addOrderBy(Path path, int direction) {
        return this.addOrderBy((Node)new NodePathletPath(path), direction);
    }

    public Element baseElement() {
        return this.baseElement;
    }

    public List<Var> primaryKeyVars() {
        return this.primaryKeyVars;
    }

    public Single<Model> execConstruct() {
        return this.exec().toList().map(l -> {
            Model r = ModelFactory.createDefaultModel();
            for (RDFNode item : l) {
                Model tmp = item.getModel();
                if (tmp == null) continue;
                r.add(tmp);
            }
            return r;
        });
    }

    public Single<CountInfo> count() {
        return this.count(null, null);
    }

    public Single<CountInfo> count(Long distinctItemCount, Long rowCount) {
        QuerySpec e = this.toConstructQueryNew();
        Query query = e.getQuery();
        query.setQuerySelectType();
        query.setDistinct(true);
        query.setQueryResultStar(false);
        query.getProject().clear();
        e.getPrimaryKeyVars().forEach(arg_0 -> ((VarExprList)query.getProject()).add(arg_0));
        Single result = SparqlRx.fetchCountQueryPartition((QueryExecutionFactoryQuery)QueryExecutionFactories.of((RDFDataSource)this.dataSource), (Query)query, (Collection)e.getPrimaryKeyVars(), (Long)distinctItemCount, (Long)rowCount).map(range -> CountUtils.toCountInfo((Range<Long>)range));
        return result;
    }

    public ResolverNode resolver() {
        QuerySpec e = this.toConstructQueryNew();
        ResolverNodeImpl result = ResolverNodeImpl.from(e.getQuery(), this.superRootNode, this);
        return result;
    }

    public Node nodeForPath(Path path) {
        return new NodePathletPath(path);
    }

    public DataQueryVarView<T> getAttr(String attrName) {
        throw new RuntimeException("not implemented yet");
    }

    private /* synthetic */ List lambda$exec$6(Comparator cmp, List l) throws Throwable {
        Collections.sort(l, (a, b) -> cmp.compare((Binding)a.getKey(), (Binding)b.getKey()));
        Collections.shuffle(l, this.pseudoRandom);
        Range available = Range.closed((Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(l.size()));
        Range requested = QueryUtils.toRange((Long)this.offset, (Long)this.limit);
        Range effective = available.intersection(requested);
        long o = (Long)effective.lowerEndpoint();
        long size = (Long)effective.upperEndpoint() - o;
        return l.subList((int)o, (int)size);
    }
}

