/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import java.util.Collection;
import java.util.function.Supplier;
import org.aksw.facete.v3.api.FacetConstraint;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetNodeResource;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.FacetedQueryResource;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.bgp.api.XFacetedQuery;
import org.aksw.facete.v3.impl.FacetNodeImpl;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.vocabulary.RDF;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class FacetedQueryImpl
implements FacetedQueryResource {
    protected RDFDataSource dataSource;
    protected Supplier<? extends Fragment1> conceptSupplier;
    protected XFacetedQuery modelRoot;

    public static FacetedQueryImpl create(SparqlQueryConnection conn) {
        return FacetedQueryImpl.create(ModelFactory.createDefaultModel(), conn);
    }

    public static FacetedQueryImpl create(Model model, SparqlQueryConnection conn) {
        return FacetedQueryImpl.create((XFacetedQuery)model.createResource().as(XFacetedQuery.class), conn);
    }

    public static FacetedQueryImpl create(Resource modelRoot, SparqlQueryConnection conn) {
        return FacetedQueryImpl.create((XFacetedQuery)modelRoot.as(XFacetedQuery.class), conn);
    }

    public static void initResource(Resource resource) {
        FacetedQueryImpl.initResource((XFacetedQuery)resource.as(XFacetedQuery.class));
    }

    public static void initResource(XFacetedQuery modelRoot) {
        if (modelRoot.getBgpRoot() == null) {
            modelRoot.setBgpRoot((BgpNode)modelRoot.getModel().createResource().addProperty(RDF.type, (RDFNode)Vocab.BgpNode).as(BgpNode.class));
        }
        if (modelRoot.getFocus() == null) {
            modelRoot.setFocus(modelRoot.getBgpRoot());
        }
    }

    public static FacetedQueryImpl create(XFacetedQuery modelRoot, RDFDataSource rdfDataSource) {
        FacetedQueryImpl.initResource(modelRoot);
        return new FacetedQueryImpl(modelRoot, () -> ConceptUtils.subjectConcept, rdfDataSource);
    }

    public static FacetedQueryImpl create(XFacetedQuery modelRoot, SparqlQueryConnection conn) {
        FacetedQueryImpl.initResource(modelRoot);
        return new FacetedQueryImpl(modelRoot, () -> ConceptUtils.subjectConcept, RDFDataSources.ofQueryConnection((SparqlQueryConnection)conn));
    }

    public FacetedQueryImpl(XFacetedQuery modelRoot, Supplier<? extends Fragment1> conceptSupplier, RDFDataSource rdfDataSource) {
        this.modelRoot = modelRoot;
        this.conceptSupplier = conceptSupplier;
        this.dataSource = rdfDataSource;
    }

    public XFacetedQuery modelRoot() {
        return this.modelRoot;
    }

    public FacetNodeResource root() {
        return new FacetNodeImpl(this, this.modelRoot.getBgpRoot());
    }

    public FacetNodeResource focus() {
        return new FacetNodeImpl(this, this.modelRoot.getFocus());
    }

    public void focus(FacetNode facetNode) {
        FacetNodeImpl impl = (FacetNodeImpl)facetNode;
        this.modelRoot.setFocus(impl.state());
    }

    public Concept toConcept() {
        throw new UnsupportedOperationException("not implemented");
    }

    public FacetedQuery baseConcept(Supplier<? extends Fragment1> conceptSupplier) {
        this.conceptSupplier = conceptSupplier;
        return this;
    }

    public FacetedQuery baseConcept(Fragment1 concept) {
        return this.baseConcept(() -> concept);
    }

    public Fragment1 baseConcept() {
        Fragment1 result = this.conceptSupplier.get();
        return result;
    }

    public FacetedQuery dataSource(RDFDataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public RDFDataSource dataSource() {
        return this.dataSource;
    }

    public Collection<FacetConstraint> constraints() {
        return this.modelRoot.constraints();
    }
}

