/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.aksw.facete.v3.api.FacetConstraintControl;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetNodeResource;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.FacetedQueryResource;
import org.aksw.facete.v3.api.HLFacetConstraint;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.bgp.utils.PathAccessorImpl;
import org.aksw.facete.v3.impl.FacetNodeImpl;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jena_sparql_api.data_query.impl.PathAccessorUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.util.ExprUtils;

public class HLFacetConstraintImpl<P>
implements HLFacetConstraint<P> {
    protected P parent;
    protected FacetNode facetNode;
    protected FacetConstraintControl state;

    public HLFacetConstraintImpl(P parent, FacetNode facetNode, FacetConstraintControl state) {
        this.parent = parent;
        this.facetNode = facetNode;
        this.state = state;
    }

    public FacetConstraintControl state() {
        return this.state;
    }

    public Expr expr() {
        Expr result = this.state.expr();
        return result;
    }

    public static Map<Node, BgpNode> mentionedBgpNodes(Model model, Expr baseExpr) {
        PathAccessorImpl pathAccessor = new PathAccessorImpl(model);
        Map<Node, BgpNode> result = PathAccessorUtils.getPathsMentioned(baseExpr, arg_0 -> ((PathAccessor)pathAccessor).tryMapToPath(arg_0));
        return result;
    }

    public static Map<Node, FacetNode> mentionedFacetNodes(FacetedQuery fq, Expr baseExpr) {
        FacetedQueryResource fqr = (FacetedQueryResource)fq.as(FacetedQueryResource.class);
        FacetNodeResource fnr = (FacetNodeResource)fq.root().as(FacetNodeResource.class);
        BgpNode rootState = fnr.state();
        Map<Node, BgpNode> paths = HLFacetConstraintImpl.mentionedBgpNodes(rootState.getModel(), baseExpr);
        LinkedHashMap<Node, FacetNode> result = new LinkedHashMap<Node, FacetNode>();
        for (Map.Entry<Node, BgpNode> e : paths.entrySet()) {
            result.put(e.getKey(), (FacetNode)new FacetNodeImpl(fqr, e.getValue()));
        }
        return result;
    }

    public Map<Node, FacetNode> mentionedFacetNodes() {
        FacetedQueryResource fqr = (FacetedQueryResource)this.facetNode.query().as(FacetedQueryResource.class);
        Expr baseExpr = this.state.expr();
        Map<Node, FacetNode> result = HLFacetConstraintImpl.mentionedFacetNodes((FacetedQuery)fqr, baseExpr);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = obj instanceof HLFacetConstraint && Objects.equals(this.state, ((HLFacetConstraint)obj).state());
        return result;
    }

    public boolean isActive() {
        Collection items = this.facetNode.enterConstraints().list();
        boolean result = items.contains(this.state);
        return result;
    }

    public boolean setActive() {
        Collection items = this.facetNode.enterConstraints().list();
        boolean result = items.add(this.state);
        return result;
    }

    public boolean remove() {
        Collection items = this.facetNode.enterConstraints().list();
        boolean result = items.remove(this.state);
        return result;
    }

    public P parent() {
        return this.parent;
    }

    public String toString() {
        Expr expr = this.state.expr();
        Map<Node, FacetNode> map = this.mentionedFacetNodes();
        Expr e = org.aksw.jenax.arq.util.expr.ExprUtils.applyNodeTransform((Expr)expr, n -> {
            FacetNode fn = (FacetNode)map.get(n);
            Node r = fn != null ? NodeFactory.createLiteral((String)("[" + String.valueOf(fn) + "]")) : n;
            return r;
        });
        String result = ExprUtils.fmtSPARQL((Expr)e);
        return result;
    }
}

