/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.experimental;

import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import java.util.LinkedHashMap;
import org.aksw.facete.v3.api.traversal.TraversalDirNode;
import org.aksw.facete.v3.api.traversal.TraversalMultiNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;

public abstract class PathDirNode<N, M extends TraversalMultiNode<N>>
implements TraversalDirNode<N, M> {
    protected N parent;
    protected boolean isFwd;
    protected Table<Resource, Node, M> propComponentToMultiNode = Tables.newCustomTable(new LinkedHashMap(), LinkedHashMap::new);

    public PathDirNode(N parent, boolean isFwd) {
        this.parent = parent;
        this.isFwd = isFwd;
    }

    public boolean isFwd() {
        return this.isFwd;
    }

    public M via(Resource property, Node component) {
        TraversalMultiNode result = this.propComponentToMultiNode.row((Object)property).computeIfAbsent(component, c -> this.viaImpl(property, (Node)c));
        return (M)result;
    }

    protected abstract M viaImpl(Resource var1, Node var2);
}

