/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.util.direction.Direction;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.api.QueryContext;
import org.aksw.jenax.facete.treequery2.api.RelationQuery;
import org.aksw.jenax.facete.treequery2.impl.ConstraintNodeImpl;
import org.aksw.jenax.facete.treequery2.impl.FacetRelationUtils;
import org.aksw.jenax.facete.treequery2.impl.NodeQueryBase;
import org.aksw.jenax.facete.treequery2.impl.RelationQueryImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.MappedFragment;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;

public class NodeQueryImpl
extends NodeQueryBase
implements NodeQuery {
    protected RelationQuery relationQuery;
    protected Var var;
    protected FacetStep reachingStep;
    protected Map<FacetStep, RelationQuery> children = new LinkedHashMap<FacetStep, RelationQuery>();
    protected Map<FacetStep, NodeQuery> subPaths = new LinkedHashMap<FacetStep, NodeQuery>();
    protected ConstraintNode<NodeQuery> constraintRoot;
    protected Fragment1 filterRelation = null;
    protected List<MappedFragment<Node>> injectRelations = new ArrayList<MappedFragment<Node>>();

    @Override
    public NodeQuery addFragment() {
        long nextStepId = this.children.keySet().stream().filter(step -> step.getStep().equals((Object)FacetStep.FRAGMENT_PATH)).count();
        FacetStep step2 = FacetStep.fwd((Node)FacetStep.PATH_NODE, (String)Long.toString(nextStepId));
        return this.getOrCreateChild(step2);
    }

    @Override
    public NodeQuery addInjectFragment(MappedFragment<Node> relation) {
        this.injectRelations.add(relation);
        return this;
    }

    @Override
    public List<MappedFragment<Node>> getInjectFragments() {
        return this.injectRelations;
    }

    public NodeQueryImpl(RelationQueryImpl relationQuery, Var var, FacetStep reachingStep) {
        this.relationQuery = relationQuery;
        this.var = var;
        this.reachingStep = reachingStep;
        this.constraintRoot = new ConstraintNodeImpl(this, FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]));
    }

    @Override
    public NodeQuery getParent() {
        return this.relationQuery == null ? null : this.relationQuery.getParentNode();
    }

    @Override
    public NodeQuery setFilterFragment(Fragment1 filterRelation) {
        this.filterRelation = filterRelation;
        return this;
    }

    @Override
    public Fragment1 getFilterFragment() {
        return this.filterRelation;
    }

    @Override
    public ConstraintNode<NodeQuery> constraints() {
        return this.constraintRoot;
    }

    @Override
    public NodeQuery sort(int sortDirection) {
        RelationQuery.doSort(this.relationQuery(), (Expr)new ExprVar(this.var), sortDirection);
        return this;
    }

    @Override
    public int getSortDirection() {
        int result = RelationQuery.getSortDirection(this.relationQuery(), (Expr)new ExprVar(this.var));
        return result;
    }

    @Override
    public Map<FacetStep, RelationQuery> children() {
        return this.children;
    }

    @Override
    public Collection<NodeQuery> getChildren() {
        return this.subPaths.values();
    }

    @Override
    public FacetStep reachingStep() {
        return this.reachingStep;
    }

    @Override
    public NodeQuery resolve(FacetPath facetPath) {
        NodeQuery result;
        if (facetPath.isAbsolute()) {
            FacetPath relativePath = (FacetPath)FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]).relativize((Path)facetPath);
            RelationQuery rootRelation = this.relationQuery.root();
            result = rootRelation.target().resolve(relativePath);
        } else if (facetPath.getNameCount() == 0) {
            result = this;
        } else {
            FacetPath startPath = (FacetPath)facetPath.subpath(0, 1);
            FacetStep step = (FacetStep)startPath.toSegment();
            NodeQuery rn = this.getOrCreateChild(step);
            FacetPath remainingPath = (FacetPath)startPath.relativize((Path)facetPath);
            result = rn.resolve(remainingPath);
        }
        return result;
    }

    @Override
    public NodeQuery getOrCreateChild(FacetStep step) {
        NodeQuery result = this.subPaths.computeIfAbsent(step, ss -> {
            FacetStep relationStep = FacetStep.of((Node)step.getNode(), (Direction)step.getDirection(), (String)step.getAlias(), (Node)FacetStep.TUPLE);
            RelationQueryImpl tmp = (RelationQueryImpl)this.children.computeIfAbsent(relationStep, fs -> {
                Node property = fs.getNode();
                Fragment baseRelation = this.relationQuery().getContext().getPropertyResolver().resolve(property);
                if (step.getDirection().equals((Object)Direction.BACKWARD)) {
                    if (baseRelation.getVars().size() != 2) {
                        throw new IllegalArgumentException("Reverse step via " + String.valueOf(property) + " did not resolve to a binary relation: " + String.valueOf(baseRelation));
                    }
                    baseRelation = baseRelation.toFragment2().reverse();
                }
                Var sourceVar = FacetRelationUtils.resolveComponent((Node)FacetStep.SOURCE, baseRelation);
                Var targetVar = this.var;
                QueryContext cxt = this.relationQuery.getContext();
                String scopeName = (String)cxt.getScopeNameGenerator().next();
                Set<Var> usedVars = cxt.getUsedVars();
                Map<Var, Var> toScoped = FacetRelationUtils.createVarMap(baseRelation, sourceVar, targetVar, scopeName, usedVars);
                Fragment relation = FacetRelationUtils.applyNodeTransform(baseRelation, toScoped);
                usedVars.addAll(relation.getVarsMentioned());
                if (FacetStep.isFragment((FacetStep)fs)) {
                    Fragment2 r = relation.toFragment2();
                    relation = new Fragment2Impl((Element)new ElementBind(r.getTargetVar(), (Expr)new ExprVar(r.getSourceVar())), r.getSourceVar(), r.getTargetVar());
                }
                Fragment finalRelation = relation;
                Map<Var, Node> varToComponent = FacetRelationUtils.createVarToComponentMap(relation);
                return new RelationQueryImpl(scopeName, this, () -> finalRelation, relationStep, this.relationQuery.getContext(), varToComponent);
            });
            Var tgtVar = FacetRelationUtils.resolveComponent(step.getTargetComponent(), tmp.getRelation());
            NodeQuery r = tmp.nodeFor(tgtVar);
            return r;
        });
        return result;
    }

    @Override
    public RelationQuery relationQuery() {
        return this.relationQuery;
    }

    @Override
    public Var var() {
        return this.var;
    }

    public String toString() {
        return "RootNodeImpl [var=" + String.valueOf(this.var) + ", relationQuery=" + String.valueOf(this.relationQuery) + "]";
    }

    public static NodeQuery newRoot() {
        RelationQuery rq = RelationQuery.of(Vars.s);
        NodeQuery result = rq.nodeFor(Vars.s);
        return result;
    }
}

