/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import com.google.common.io.BaseEncoding;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.facete.v4.impl.FacetPathUtils;
import org.aksw.jenax.facete.treequery2.api.FacetPathMapping;
import org.aksw.jenax.facete.treequery2.api.ScopedFacetPath;
import org.aksw.jenax.facete.treequery2.api.ScopedVar;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetPathMappingImpl
implements FacetPathMapping {
    public static final BaseEncoding DEFAULT_ENCODING = BaseEncoding.base32().omitPadding();
    public static final HashFunction DEFAULT_HASH_FUNCTION = Hashing.md5();
    private static final Logger logger = LoggerFactory.getLogger(FacetPathMappingImpl.class);
    protected BiMap<FacetPath, HashCode> pathToHashCode = HashBiMap.create();
    protected HashFunction hashing;
    protected BaseEncoding encoding;

    public FacetPathMappingImpl() {
        this(DEFAULT_HASH_FUNCTION, DEFAULT_ENCODING);
    }

    public FacetPathMappingImpl(HashFunction hashing, BaseEncoding encoding) {
        this.hashing = hashing;
        this.encoding = encoding;
    }

    public BiMap<FacetPath, HashCode> getPathToName() {
        return this.pathToHashCode;
    }

    public BaseEncoding getEncoding() {
        return this.encoding;
    }

    public HashFunction getHashing() {
        return this.hashing;
    }

    public byte[] increment(byte[] arr) {
        byte[] result = Arrays.copyOf(arr, arr.length);
        int i = arr.length - 1;
        while (i >= 0) {
            byte before = result[i];
            int n = i--;
            result[n] = (byte)(result[n] + 1);
            byte after = result[n];
            if (after > before) break;
        }
        return result;
    }

    @Override
    public String allocate(FacetPath rawFacetPath) {
        FacetPath facetPath = FacetPathUtils.toElementId(rawFacetPath);
        HashCode hc = (HashCode)this.pathToHashCode.computeIfAbsent((Object)facetPath, fp -> {
            FacetPath clashPath;
            HashCode hashCode = this.hashing.hashString((CharSequence)facetPath.toString(), StandardCharsets.UTF_8);
            BiMap nameToPath = this.pathToHashCode.inverse();
            while ((clashPath = (FacetPath)nameToPath.get((Object)hashCode)) != null) {
                logger.info("Mitigated hash clash: Hash " + this.hashCodeToString(hashCode) + " clashed for [" + String.valueOf(fp) + "] and [" + String.valueOf(clashPath) + "]");
                hashCode = HashCode.fromBytes((byte[])this.increment(hashCode.asBytes()));
            }
            return hashCode;
        });
        String result = this.hashCodeToString(hc);
        return result;
    }

    public static String toString(HashCode hashCode) {
        byte[] bytes = hashCode.asBytes();
        String result = DEFAULT_ENCODING.encode(bytes).toLowerCase();
        return result;
    }

    public String hashCodeToString(HashCode hashCode) {
        byte[] bytes = hashCode.asBytes();
        String result = this.encoding.encode(bytes).toLowerCase();
        return result;
    }

    public static ScopedVar resolveVar(FacetPathMapping facetPathMapping, ScopedFacetPath sfp) {
        return FacetPathMappingImpl.resolveVar(facetPathMapping, sfp.getScope(), sfp.getFacetPath());
    }

    public static ScopedVar resolveVar(FacetPathMapping facetPathMapping, VarScope scope, FacetPath facetPath) {
        return FacetPathMappingImpl.resolveVar(facetPathMapping, scope.getScopeName(), scope.getStartVar(), facetPath);
    }

    public static ScopedVar resolveVar(FacetPathMapping facetPathMapping, String baseScopeName, Var rootVar, FacetPath facetPath) {
        ScopedVar result;
        if (facetPath.getParent() == null) {
            result = ScopedVar.of("", "", rootVar);
        } else {
            FacetPath parentPath = (FacetPath)facetPath.getParent();
            FacetStep lastStep = (FacetStep)((FacetPath)facetPath.getFileName()).toSegment();
            Node component = lastStep.getTargetComponent();
            if (FacetStep.isSource((Node)component)) {
                result = FacetPathMappingImpl.resolveVar(facetPathMapping, baseScopeName, rootVar, parentPath);
            } else {
                String pathScope = facetPathMapping.allocate(facetPath);
                result = ScopedVar.of(baseScopeName, pathScope, (Var)component);
            }
        }
        return result;
    }
}

