/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Table;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.facete.treequery2.impl.ConstraintApi2Impl;
import org.apache.jena.sparql.expr.Expr;

public class FacetConstraints<T> {
    protected Class<?> constraintClass;
    protected Table<Set<T>, Expr, Boolean> model = HashBasedTable.create();

    public FacetConstraints(Class<?> constraintClass) {
        this.constraintClass = constraintClass;
    }

    public Collection<Expr> getExprs() {
        return this.model.columnKeySet();
    }

    public ConstraintApi2Impl<T> getFacade(T node) {
        return new ConstraintApi2Impl<T>(this, node);
    }

    public Class<?> getConstraintClass() {
        return this.constraintClass;
    }

    public String toString() {
        return Objects.toString(this.model);
    }

    public static <T> SetMultimap<T, Expr> createConstraintIndex(Class<?> constraintClass, Collection<Expr> exprs) {
        HashMultimap constraintIndex = HashMultimap.create();
        for (Expr expr : exprs) {
            Set paths = NodeCustom.mentionedValues(constraintClass, (Expr)expr);
            for (Object path : paths) {
                constraintIndex.put(path, (Object)expr);
            }
        }
        return constraintIndex;
    }
}

