/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.facete.treequery2.impl.FacetPathMappingImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class ScopedVar {
    protected String scopeName;
    protected String pathName;
    protected Var baseVar;
    public static final Pattern SCOPED_VAR_PATTERN = Pattern.compile("^_(([^_]|__)*)_(([^_]|__)*)_(.*)_$");

    public ScopedVar(String scopeName, String pathName, Var baseVar) {
        this.scopeName = scopeName;
        this.pathName = pathName;
        this.baseVar = baseVar;
    }

    public String getScopeName() {
        return this.scopeName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public Var getBaseVar() {
        return this.baseVar;
    }

    public Var asVar() {
        return ScopedVar.scopeVar(this.baseVar, this.scopeName, this.pathName);
    }

    public String toString() {
        return "ScopedVar [scopeName=" + this.scopeName + ", pathName=" + this.pathName + ", baseVar=" + String.valueOf(this.baseVar) + "]";
    }

    public static ScopedVar of(String scopeName, String pathName, Var baseVar) {
        return new ScopedVar(scopeName, pathName, baseVar);
    }

    public static Var scopeVar(Var var, String scopeName, String pathName) {
        Var result;
        if (scopeName.isEmpty() && pathName.isEmpty()) {
            result = var;
        } else {
            String originalName = var.getName();
            String scopedName = "_" + scopeName.replace("_", "__") + "_" + pathName.replace("_", "__") + "_" + originalName + "_";
            result = Var.alloc((String)scopedName);
        }
        return result;
    }

    public static ScopedVar unscopeVar(Var var) {
        String originalName = var.getName();
        Matcher matcher = SCOPED_VAR_PATTERN.matcher(originalName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Scoped variables must start and end with an underscore (_).");
        }
        ScopedVar result = new ScopedVar(matcher.group(1).replace("__", "_"), matcher.group(3).replace("__", "_"), Var.alloc((String)matcher.group(5)));
        return result;
    }

    public static void main(String[] args) {
        FacetPathMappingImpl fpm = new FacetPathMappingImpl();
        Var var = Var.alloc((String)"foo_bar");
        Var scopedVar = ScopedVar.scopeVar(var, "s_cop__e", "pa_th");
        System.out.println(scopedVar);
        ScopedVar sc = ScopedVar.unscopeVar(scopedVar);
        Var unscopedVar = sc.getBaseVar();
        System.out.println(unscopedVar);
        System.out.println(sc.getScopeName());
        System.out.println(sc.getPathName());
        FacetPath fp = (FacetPath)((FacetPath)FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]).resolve((Object)FacetStep.fwd((Resource)RDFS.label))).resolve((Object)FacetStep.fwd((Resource)RDF.type));
        fp = FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]);
        ScopedVar sc2 = FacetPathMappingImpl.resolveVar(fpm, "base", Vars.s, fp);
        System.out.println(sc2.asVar());
    }
}

