/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.api;

import java.util.Arrays;
import java.util.List;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathSysBase;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.facete.treequery2.api.FacetPathMapping;
import org.aksw.jenax.facete.treequery2.api.ScopedVar;
import org.aksw.jenax.facete.treequery2.impl.FacetPathMappingImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetPathOps;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.vocabulary.RDF;

public class ScopedFacetPath
extends PathSysBase<FacetStep, ScopedFacetPath, VarScope> {
    public ScopedFacetPath(VarScope system, Path<FacetStep> delegate) {
        super((Object)system, delegate);
    }

    protected ScopedFacetPath wrap(Path<FacetStep> basePath) {
        return ScopedFacetPath.of((VarScope)this.system, basePath);
    }

    public FacetPath getDelegate() {
        return (FacetPath)super.getDelegate();
    }

    @Deprecated
    public FacetPath getFacetPath() {
        return this.getDelegate();
    }

    @Deprecated
    public VarScope getScope() {
        return (VarScope)this.getSystem();
    }

    public String toString() {
        return String.valueOf(this.getSystem()) + ":" + String.valueOf(this.getDelegate());
    }

    public static ScopedFacetPath newAbsolutePath(VarScope scope, FacetStep ... segments) {
        return ScopedFacetPath.newAbsolutePath(scope, Arrays.asList(segments));
    }

    public static ScopedFacetPath newAbsolutePath(VarScope scope, List<FacetStep> segments) {
        return ScopedFacetPath.of(scope, (Path<FacetStep>)FacetPathOps.get().newPath(true, segments));
    }

    public static ScopedFacetPath newRelativePath(VarScope scope, FacetStep ... segments) {
        return ScopedFacetPath.newRelativePath(scope, Arrays.asList(segments));
    }

    public static ScopedFacetPath newRelativePath(VarScope scope, List<FacetStep> segments) {
        return ScopedFacetPath.of(scope, (Path<FacetStep>)FacetPathOps.get().newPath(false, segments));
    }

    public static ScopedFacetPath of(Var startVar, FacetPath facetPath) {
        return ScopedFacetPath.of(VarScope.of((Var)startVar), (Path<FacetStep>)facetPath);
    }

    public static ScopedFacetPath of(VarScope system, Path<FacetStep> basePath) {
        return new ScopedFacetPath(system, basePath);
    }

    public static ScopedFacetPath of(String scopeName, Var var, Path<FacetStep> basePath) {
        return new ScopedFacetPath(VarScope.of((String)scopeName, (Var)var), basePath);
    }

    public ScopedVar toScopedVar(FacetPathMapping facetPathMapping) {
        return ScopedFacetPath.toScopedVar(this, facetPathMapping);
    }

    public static ScopedVar toScopedVar(ScopedFacetPath scopedFacetPath, FacetPathMapping facetPathMapping) {
        String scopeName = ((VarScope)scopedFacetPath.getSystem()).getScopeName();
        Var startVar = ((VarScope)scopedFacetPath.getSystem()).getStartVar();
        FacetPath facetPath = scopedFacetPath.getDelegate();
        return FacetPathMappingImpl.resolveVar(facetPathMapping, scopeName, startVar, facetPath);
    }

    public static void main(String[] args) {
        VarScope scope1 = VarScope.of((String)"scope1", (Var)Vars.x);
        VarScope scope2 = VarScope.of((String)"scope2", (Var)Vars.y);
        ScopedFacetPath path1 = ScopedFacetPath.newAbsolutePath(scope1, new FacetStep[0]);
        ScopedFacetPath path2 = (ScopedFacetPath)ScopedFacetPath.newRelativePath(scope1, new FacetStep[0]).resolve(FacetStep.fwd((Node)RDF.type.asNode()));
        ScopedFacetPath path3 = (ScopedFacetPath)path1.resolve((Path)path2);
        System.out.println((Object)path3);
        System.out.println(path3.getParent());
        System.out.println(path3.resolve((Path)path2));
    }
}

