/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.api;

import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.aksw.commons.path.core.Path;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.FacetPathMapping;
import org.aksw.jenax.facete.treequery2.api.FacetTraversable;
import org.aksw.jenax.facete.treequery2.api.HasSlice;
import org.aksw.jenax.facete.treequery2.api.OrderNode;
import org.aksw.jenax.facete.treequery2.api.RelationQuery;
import org.aksw.jenax.facete.treequery2.api.ScopedFacetPath;
import org.aksw.jenax.facete.treequery2.api.Selection;
import org.aksw.jenax.facete.treequery2.api.Sortable;
import org.aksw.jenax.facete.treequery2.impl.FacetPathMappingImpl;
import org.aksw.jenax.facete.treequery2.impl.OrderNodeImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.MappedFragment;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;

public interface NodeQuery
extends FacetTraversable<NodeQuery>,
HasSlice,
Sortable<NodeQuery>,
Selection {
    @Override
    default public boolean isNodeQuery() {
        return true;
    }

    @Override
    default public NodeQuery asNodeQuery() {
        return this;
    }

    default public Node asJenaNode() {
        return NodeCustom.of((Object)this);
    }

    public NodeQuery addFragment();

    public NodeQuery setFilterFragment(Fragment1 var1);

    public Fragment1 getFilterFragment();

    public NodeQuery addInjectFragment(MappedFragment<Node> var1);

    public List<MappedFragment<Node>> getInjectFragments();

    default public FacetPath getFacetPath() {
        FacetPath result;
        RelationQuery relationQuery = this.relationQuery();
        NodeQuery parentNode = relationQuery.getParentNode();
        if (parentNode == null) {
            result = FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]);
        } else {
            FacetPath base = parentNode.getFacetPath();
            FacetStep step = this.reachingStep();
            if (step == null) {
                throw new NullPointerException();
            }
            result = (FacetPath)base.resolve((Object)step);
        }
        return result;
    }

    default public ScopedFacetPath getScopedFacetPath() {
        RelationQuery relationQuery = this.relationQuery();
        String baseScopeName = relationQuery.getScopeBaseName();
        NodeQuery root = this.getRoot();
        Var rootVar = root.var();
        FacetPath facetPath = this.getFacetPath();
        ScopedFacetPath result = ScopedFacetPath.of(baseScopeName, rootVar, (Path<FacetStep>)facetPath);
        return result;
    }

    default public NodeQuery getRoot() {
        RelationQuery relationQuery = this.relationQuery();
        NodeQuery parentNode = relationQuery.getParentNode();
        NodeQuery result = parentNode == null ? this : parentNode.getRoot();
        return result;
    }

    public Collection<NodeQuery> getChildren();

    public ConstraintNode<NodeQuery> constraints();

    public RelationQuery relationQuery();

    public Var var();

    public FacetStep reachingStep();

    @Override
    public NodeQuery resolve(FacetPath var1);

    public Map<FacetStep, RelationQuery> children();

    @Override
    default public Long offset() {
        RelationQuery relationQuery = this.relationQuery();
        return relationQuery.offset();
    }

    @Override
    default public NodeQuery offset(Long offset) {
        RelationQuery relationQuery = this.relationQuery();
        relationQuery.offset(offset);
        return this;
    }

    @Override
    default public Long limit() {
        RelationQuery relationQuery = this.relationQuery();
        return relationQuery.limit();
    }

    @Override
    default public NodeQuery limit(Long limit) {
        RelationQuery relationQuery = this.relationQuery();
        relationQuery.limit(limit);
        return this;
    }

    default public OrderNode<NodeQuery> orderBy() {
        return new OrderNodeImpl(this);
    }

    public static VarScope computeVarScope(NodeQuery nodeQuery) {
        FacetPath facetPath = nodeQuery.getFacetPath();
        RelationQuery relationQuery = nodeQuery.relationQuery();
        FacetPathMapping pathMapping = relationQuery.getContext().getPathMapping();
        String baseScope = relationQuery.getScopeBaseName();
        String scopeContrib = pathMapping.allocate(facetPath);
        String finalScope = FacetPathMappingImpl.toString(FacetPathMappingImpl.DEFAULT_HASH_FUNCTION.newHasher().putString((CharSequence)baseScope, StandardCharsets.UTF_8).putString((CharSequence)scopeContrib, StandardCharsets.UTF_8).hash());
        VarScope result = VarScope.of((String)finalScope, (Var)nodeQuery.var());
        return result;
    }

    public static ScopedFacetPath toScopedFacetPath(NodeQuery nodeQuery, FacetPath constraintPath) {
        VarScope varScope = NodeQuery.computeVarScope(nodeQuery);
        ScopedFacetPath scopedFacetPath = ScopedFacetPath.of(varScope, (Path<FacetStep>)constraintPath);
        return scopedFacetPath;
    }
}

