/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jena_sparql_api.data_query.impl;

import com.google.common.collect.Range;
import com.google.common.collect.Table;
import com.google.common.collect.Tables;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.data_query.api.SPath;
import org.aksw.jena_sparql_api.data_query.impl.FacetedQueryGenerator;
import org.aksw.jena_sparql_api.data_query.impl.FactoryWithModel;
import org.aksw.jena_sparql_api.data_query.impl.PathAccessorSPath;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.aksw.jenax.sparql.query.rx.SparqlRx;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.syntax.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacetedBrowsingSessionImpl {
    private static final Logger logger = LoggerFactory.getLogger(FacetedBrowsingSessionImpl.class);
    protected RDFConnection conn;
    protected SPath root;
    protected SPath focus;
    protected FacetedQueryGenerator<SPath> queryGenerator;

    public FacetedBrowsingSessionImpl(RDFConnection conn) {
        this.conn = conn;
        FactoryWithModel<SPath> pathFactory = new FactoryWithModel<SPath>(SPath.class);
        this.root = pathFactory.get();
        PathAccessorSPath pathAccessor = new PathAccessorSPath();
        this.queryGenerator = new FacetedQueryGenerator<SPath>(pathAccessor);
        this.focus = this.root;
    }

    public SPath getRoot() {
        return this.root;
    }

    public Fragment2 createQueryFacetsAndCounts(SPath path, boolean isReverse, Fragment1 pConstraint) {
        Object relations = null;
        return null;
    }

    public Flowable<Table.Cell<Node, Node, Range<Long>>> getFacetValues(SPath facetPath, boolean isReverse, Fragment1 pFilter, Fragment1 oFilter) {
        Fragment3 tr = this.createQueryFacetValues(facetPath, isReverse, pFilter, oFilter);
        Query query = tr.toQuery();
        logger.info("Requesting facet value counts: " + String.valueOf(query));
        return SparqlRx.execSelectRaw(() -> this.conn.query(query)).map(b -> Tables.immutableCell((Object)b.get(tr.getS()), (Object)b.get(tr.getP()), (Object)Range.singleton((Comparable)Long.valueOf(((Number)b.get(tr.getO()).getLiteral().getValue()).longValue()))));
    }

    public Fragment3 createQueryFacetValues(SPath facetPath, boolean isReverse, Fragment1 pFilter, Fragment1 oFilter) {
        Map<String, Fragment3> facetValues = this.queryGenerator.getFacetValuesCore(null, this.focus, facetPath, pFilter, oFilter, isReverse, false, false, false);
        Var countVar = Vars.c;
        List elements = facetValues.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.s, Vars.p, Vars.o))).map(Fragment::toFragment3).map(e -> e.joinOn(new Var[]{e.getP()}).with(pFilter)).map(e -> FragmentUtils.groupBy((Fragment)e, (Var)Vars.s, (Var)countVar, (boolean)false)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment3Impl result = new Fragment3Impl(e2, Vars.p, Vars.o, countVar);
        return result;
    }
}

