/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.aksw.facete.v3.api.TreeQuery;
import org.aksw.facete.v3.api.TreeQueryImpl;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.core.Var;

class TreeRelation {
    protected Fragment relation;
    protected TreeQuery tree;
    protected BiMap<TreeQueryNode, Var> pathToVar;

    public TreeRelation(Fragment relation, TreeQuery tree, BiMap<TreeQueryNode, Var> pathToVar) {
        this.relation = relation;
        this.tree = tree;
        this.pathToVar = pathToVar;
    }

    public static Node varToIri(Var var) {
        Node result = NodeFactory.createURI((String)("urn:x-jenax:var:" + var.getName()));
        return result;
    }

    public static TreeRelation of(Fragment relation) {
        TreeQueryImpl tree = new TreeQueryImpl();
        List vars = relation.getVars();
        HashBiMap pathToVar = HashBiMap.create();
        for (Var v : vars) {
            Node property = TreeRelation.varToIri(v);
            FacetPath facetPath = FacetPath.newRelativePath((FacetStep)FacetStep.fwd((Node)property, null));
            TreeQueryNode varNode = tree.root().resolve(facetPath);
            pathToVar.put((Object)varNode, (Object)v);
        }
        return new TreeRelation(relation, (TreeQuery)tree, (BiMap<TreeQueryNode, Var>)pathToVar);
    }

    public static Table varsToTable(Collection<Var> vars) {
        List nodes = vars.stream().map(TreeRelation::varToIri).collect(Collectors.toList());
        Table result = TableUtils.createTable((Var)Vars.p, nodes);
        return result;
    }
}

