/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import org.aksw.commons.path.core.Path;
import org.aksw.facete.v3.api.ConstraintApiImpl;
import org.aksw.facete.v3.api.ConstraintFacade;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.FacetDirNode;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetedDataQuery;
import org.aksw.facete.v3.api.FacetedQuery;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.facete.v3.impl.FacetedDataQueryImpl;
import org.aksw.facete.v4.impl.ConstraintFacadeImpl;
import org.aksw.facete.v4.impl.ElementGenerator;
import org.aksw.facete.v4.impl.FacetDirNodeImpl;
import org.aksw.facete.v4.impl.FacetedQueryImpl;
import org.aksw.facete.v4.impl.FacetedRelationQuery;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.facete.treequery2.api.ScopedFacetPath;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.sparql.core.Var;

public class FacetNodeImpl
implements FacetNode {
    protected FacetedQueryImpl facetedQuery;
    protected TreeQueryNode node;

    public FacetNodeImpl(FacetedQueryImpl facetedQuery, TreeQueryNode node) {
        this.facetedQuery = facetedQuery;
        this.node = node;
    }

    public TreeQueryNode node() {
        return this.node;
    }

    public FacetNode resolve(FacetPath path) {
        TreeQueryNode target = this.node.resolve(path);
        return this.facetedQuery.wrapNode(target);
    }

    public FacetNode parent() {
        TreeQueryNode parent = this.node.getParent();
        FacetNode result = parent == null ? null : this.facetedQuery.wrapNode(parent);
        return result;
    }

    public FacetDirNode fwd() {
        return new FacetDirNodeImpl(this, Direction.FORWARD);
    }

    public FacetDirNode bwd() {
        return new FacetDirNodeImpl(this, Direction.BACKWARD);
    }

    public FacetedQuery query() {
        return this.facetedQuery;
    }

    public FacetNode chRoot() {
        this.node.chRoot();
        return this;
    }

    public FacetNode chFocus() {
        this.facetedQuery.focus = this.node;
        return this;
    }

    public FacetNode as(String varName) {
        throw new UnsupportedOperationException("this method will be removed");
    }

    public FacetNode as(Var var) {
        throw new UnsupportedOperationException("this method will be removed");
    }

    public Var alias() {
        throw new UnsupportedOperationException("this method will be removed");
    }

    public FacetStep reachingStep() {
        FacetPath path = this.node.getFacetPath();
        FacetStep result = path.getNameCount() == 0 ? null : (FacetStep)((FacetPath)path.getFileName()).toSegment();
        return result;
    }

    public Direction reachingDirection() {
        throw new UnsupportedOperationException("use reachingStep()");
    }

    public Node reachingPredicate() {
        throw new UnsupportedOperationException("use reachingStep()");
    }

    public String reachingAlias() {
        throw new UnsupportedOperationException("use reachingStep()");
    }

    public Node targetComponent() {
        throw new UnsupportedOperationException("use reachingStep()");
    }

    public Fragment2 getReachingRelation() {
        throw new UnsupportedOperationException();
    }

    public FacetNode root() {
        return this.facetedQuery.root();
    }

    public ConstraintFacade<? extends FacetNode> enterConstraints() {
        ConstraintApiImpl constraints = this.facetedQuery.relationQuery.constraints.getFacade(this.node);
        return new ConstraintFacadeImpl<FacetNodeImpl>(this, constraints);
    }

    public FacetedDataQuery<RDFNode> createValueQuery(boolean applySelfConstraints) {
        ElementGenerator eltGen = ElementGenerator.configure(this.facetedQuery);
        FacetedRelationQuery relationQuery = this.facetedQuery.relationQuery();
        String scopeName = relationQuery.getScopeBaseName();
        Var baseVar = this.facetedQuery.getBaseVar();
        VarScope varScope = VarScope.of((String)scopeName, (Var)baseVar);
        ScopedFacetPath sfp = ScopedFacetPath.of(varScope, (Path<FacetStep>)this.node.getFacetPath());
        Fragment baseRelation = this.facetedQuery.relationQuery().baseRelation.get();
        Fragment1 relation = eltGen.getAvailableValuesAt(sfp, applySelfConstraints);
        relation = relation.prependOn(relation.getVars()).with(baseRelation, new Var[0]).toFragment1();
        RDFDataSource dataSource = this.facetedQuery.dataSource();
        FacetedDataQueryImpl<RDFNode> result = new FacetedDataQueryImpl<RDFNode>(dataSource, relation.getElement(), relation.getVar(), null, RDFNode.class);
        return result;
    }

    public FacetedDataQuery<RDFNode> availableValues() {
        return this.createValueQuery(false);
    }

    public FacetedDataQuery<RDFNode> remainingValues() {
        return this.createValueQuery(true);
    }
}

