/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.facete.v3.api.TreeData;
import org.aksw.facete.v3.api.TreeDataMap;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.facete.v4.impl.ElementAcc;
import org.aksw.facete.v4.impl.ElementGenerator;
import org.aksw.facete.v4.impl.ElementGeneratorContext;
import org.aksw.facete.v4.impl.FacetPathUtils;
import org.aksw.facete.v4.impl.MappedElement;
import org.aksw.facete.v4.impl.PropertyResolver;
import org.aksw.jena_sparql_api.data_query.impl.FacetedQueryGenerator;
import org.aksw.jenax.arq.util.expr.ExprUtils;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.facete.treequery2.api.FacetPathMapping;
import org.aksw.jenax.facete.treequery2.api.ScopedFacetPath;
import org.aksw.jenax.facete.treequery2.impl.FacetConstraints;
import org.aksw.jenax.facete.treequery2.impl.FacetPathMappingImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.apache.jena.graph.Node;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;

public class ElementGeneratorWorker {
    protected Map<VarScope, ElementGeneratorContext> scopeToContext = new LinkedHashMap<VarScope, ElementGeneratorContext>();
    protected FacetPathMapping pathMapping;
    protected PropertyResolver propertyResolver;

    public ElementGeneratorWorker(FacetPathMapping pathMapping, PropertyResolver propertyResolver) {
        this((TreeData<ScopedFacetPath>)new TreeData(), (SetMultimap<ScopedFacetPath, Expr>)HashMultimap.create(), pathMapping, propertyResolver);
    }

    public ElementGeneratorWorker(TreeData<ScopedFacetPath> facetTree, SetMultimap<ScopedFacetPath, Expr> constraintIndex, FacetPathMapping pathMapping, PropertyResolver propertyResolver) {
        this.pathMapping = pathMapping;
        this.propertyResolver = propertyResolver;
        this.setFacetTree(facetTree);
        this.setConstraintIndex(constraintIndex);
    }

    public void setConstraintIndex(SetMultimap<ScopedFacetPath, Expr> constraintIndex) {
        SetMultimap<VarScope, Expr> localIndices = ElementGenerator.createUnscopedConstraintExprs(constraintIndex.values());
        for (Map.Entry e : localIndices.asMap().entrySet()) {
            ElementGeneratorContext cxt = this.getOrCreateContext((VarScope)e.getKey());
            SetMultimap localConstraintIndex = FacetConstraints.createConstraintIndex(FacetPath.class, (Collection)e.getValue());
            cxt.setConstraintIndex(localConstraintIndex);
        }
        for (Expr expr : new ArrayList(constraintIndex.values())) {
            this.analysePathModality(expr);
        }
    }

    public void setFacetTree(TreeData<ScopedFacetPath> facetTree) {
        for (ScopedFacetPath rootPath : facetTree.getRootItems()) {
            VarScope scope = rootPath.getScope();
            ElementGeneratorContext cxt = this.getOrCreateContext(scope);
            TreeData tree = facetTree.map(ScopedFacetPath::getFacetPath);
            cxt.setFacetTree((TreeData<FacetPath>)tree);
        }
    }

    public FacetPathMapping getPathMapping() {
        return this.pathMapping;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public BiMap<ScopedFacetPath, Var> getPathToVar() {
        BiMap result = (BiMap)this.scopeToContext.values().stream().flatMap(cxt -> cxt.getPathToVar().entrySet().stream().map(e -> new AbstractMap.SimpleEntry<ScopedFacetPath, Var>(ScopedFacetPath.of(cxt.scope, (Path<FacetStep>)((Path)e.getKey())), (Var)e.getValue()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, HashBiMap::create));
        return result;
    }

    public void analysePathModality(Expr expr) {
        Set paths = NodeCustom.mentionedValues(ScopedFacetPath.class, (Expr)expr);
        boolean isMandatory = !FacetedQueryGenerator.isAbsent(expr);
        for (ScopedFacetPath path : paths) {
            if (!isMandatory) continue;
            this.declareMandatoryPath(path);
        }
    }

    public void declareMandatoryPath(ScopedFacetPath scopedPath) {
        ElementGeneratorContext cxt = this.getOrCreateContext(scopedPath.getScope());
        this.declareMandatoryPath(cxt, scopedPath.getFacetPath());
    }

    public ElementGeneratorContext getOrCreateContext(VarScope scope) {
        ElementGeneratorContext result = this.scopeToContext.computeIfAbsent(scope, sc -> new ElementGeneratorContext((VarScope)sc));
        return result;
    }

    public void declareMandatoryPath(ElementGeneratorContext cxt, FacetPath path) {
        FacetPath eltId;
        Set<FacetPath> mandatoryElementIds = cxt.mandatoryElementIds;
        for (FacetPath current = path; current != null && !mandatoryElementIds.contains(eltId = FacetPathUtils.toElementId(current)); current = (FacetPath)current.getParent()) {
            mandatoryElementIds.add(eltId);
        }
    }

    public ElementAcc allocateEltAcc(Var parentVar, Var targetVar, ScopedFacetPath scopedPath) {
        ElementGeneratorContext cxt = this.getOrCreateContext(scopedPath.getScope());
        return this.allocateEltAcc(cxt, parentVar, targetVar, scopedPath.getFacetPath());
    }

    public ElementAcc allocateEltAcc(ElementGeneratorContext cxt, Var parentVar, Var targetVar, FacetPath path) {
        FacetPath eid = FacetPathUtils.toElementId(path);
        boolean isMandatory = cxt.mandatoryElementIds.contains(eid);
        Object coreElt = null;
        coreElt = !path.getSegments().isEmpty() ? this.createElementForLastStep(cxt, parentVar, targetVar, path) : new ElementGroup();
        boolean isEmptyGroup = coreElt instanceof ElementGroup && coreElt.isEmpty();
        BiFunction<Element, List<Element>, Element> combiner = isMandatory || coreElt instanceof ElementBind || isEmptyGroup ? ElementAcc::collectIntoGroup : ElementAcc::collectIntoOptionalGroup;
        return new ElementAcc((Element)coreElt, combiner);
    }

    public Element createElementForLastStep(ElementGeneratorContext cxt, Var parentVar, Var targetVar, FacetPath path) {
        ElementTriplesBlock coreElt;
        Node secondaryNode;
        FacetStep step = (FacetStep)((FacetPath)path.getFileName()).toSegment();
        Node predicateNode = step.getNode();
        boolean isFwd = step.isForward();
        Node c = step.getTargetComponent();
        if (NodeUtils.ANY_IRI.equals((Object)predicateNode)) {
            Var toggledComponent = FacetStep.isTarget((Node)c) ? FacetStep.PREDICATE : FacetStep.TARGET;
            FacetStep s = step.copyStep((Node)toggledComponent);
            FacetPath predicatePath = (FacetPath)path.resolveSibling((Object)s);
            secondaryNode = FacetPathMappingImpl.resolveVar(this.pathMapping, cxt.scope.getScopeName(), cxt.scope.getStartVar(), predicatePath).asVar();
        } else {
            secondaryNode = predicateNode;
        }
        if (FacetStep.isTarget((Node)c)) {
            Fragment rel = this.propertyResolver.resolve(secondaryNode);
            if (step.getDirection().isBackward()) {
                ArrayList<Var> swappedVars = new ArrayList<Var>(rel.getVars());
                Var first = (Var)swappedVars.get(0);
                int lastIndex = swappedVars.size() - 1;
                Var last = (Var)swappedVars.get(lastIndex);
                swappedVars.set(0, last);
                swappedVars.set(lastIndex, first);
                rel = rel.project(swappedVars);
            }
            String scopeName = cxt.getScope().getScopeName();
            HashMap<Var, Var> varRename = new HashMap<Var, Var>();
            int start = 1;
            List vars = rel.getVars();
            int n = vars.size();
            int end = n - 1;
            List<Var> intermediateVars = start >= end ? Collections.emptyList() : vars.subList(start, end);
            varRename.put((Var)vars.get(n - 1), targetVar);
            varRename.put((Var)vars.get(0), parentVar);
            for (Var v : intermediateVars) {
                Var scopedVar = FacetPathMappingImpl.resolveVar(this.pathMapping, scopeName, targetVar, path).asVar();
                varRename.put(v, scopedVar);
            }
            Fragment finalRel = rel.applyNodeTransform(NodeTransformLib2.wrapWithNullAsIdentity(varRename::get));
            coreElt = finalRel.getElement();
        } else {
            coreElt = ElementUtils.createElementTriple((Node)parentVar, (Node)targetVar, (Node)secondaryNode, (boolean)isFwd);
        }
        return coreElt;
    }

    public void allocateElements(Expr expr) {
        Set paths = NodeCustom.mentionedValues(ScopedFacetPath.class, (Expr)expr);
        for (ScopedFacetPath path : paths) {
            this.allocateElement(path);
        }
    }

    public Var allocateElement(ScopedFacetPath path) {
        ElementGeneratorContext cxt = this.getOrCreateContext(path.getScope());
        return this.allocateElement(cxt, path.getFacetPath());
    }

    public Var allocateElement(ElementGeneratorContext cxt, FacetPath path) {
        Var targetVar;
        FacetPath parentPath = (FacetPath)path.getParent();
        FacetPath eltId = FacetPathUtils.toElementId(path);
        ElementAcc elementAcc = (ElementAcc)cxt.facetPathToAcc.get((Object)eltId);
        if (elementAcc == null) {
            targetVar = FacetPathMappingImpl.resolveVar(this.pathMapping, cxt.scope, path).asVar();
            Var parentVar = parentPath != null ? this.allocateElement(cxt, parentPath) : targetVar;
            elementAcc = this.allocateEltAcc(cxt, parentVar, targetVar, path);
            cxt.facetPathToAcc.addItem((Object)((FacetPath)eltId.getParent()), (Object)eltId);
            cxt.facetPathToAcc.put((Object)eltId, (Object)elementAcc);
        } else {
            targetVar = cxt.pathToVar.computeIfAbsent(path, p -> FacetPathMappingImpl.resolveVar(this.pathMapping, cxt.scope, p).asVar());
        }
        return targetVar;
    }

    public void accumulateElements(ElementGeneratorContext cxt, ElementGroup globalAcc, Var parentVar, FacetPath path, Function<FacetPath, ? extends Iterable<FacetPath>> getChildren) {
        Set exprs;
        Iterable<FacetPath> children;
        FacetPath parentPath = (FacetPath)path.getParent();
        FacetPath parentEltId = parentPath == null ? null : FacetPathUtils.toElementId(parentPath);
        FacetPath eltId = FacetPathUtils.toElementId(path);
        Var targetVar = FacetPathMappingImpl.resolveVar(this.pathMapping, cxt.scope, path).asVar();
        cxt.pathToVar.put(path, targetVar);
        ElementAcc elementAcc = (ElementAcc)cxt.facetPathToAcc.get((Object)eltId);
        if (elementAcc == null) {
            elementAcc = this.allocateEltAcc(cxt, parentVar, targetVar, path);
            if (!cxt.facetPathToAcc.contains((Object)eltId)) {
                cxt.facetPathToAcc.addItem((Object)parentEltId, (Object)eltId);
            }
            cxt.facetPathToAcc.put((Object)eltId, (Object)elementAcc);
        }
        if ((children = getChildren.apply(path)) != null && children.iterator().hasNext()) {
            for (FacetPath subPath : children) {
                this.accumulateElements(cxt, globalAcc, targetVar, subPath, getChildren);
            }
        }
        if (!(exprs = cxt.localConstraintIndex.get((Object)path)).isEmpty()) {
            this.createElementsForExprs2(cxt, globalAcc, exprs, false);
        }
    }

    public MappedElement createElement() {
        ElementGroup filterGroup = new ElementGroup();
        MappedElement result = new MappedElement();
        for (ElementGeneratorContext cxt : this.scopeToContext.values()) {
            MappedElement part = this.createElement(cxt, filterGroup);
            result.putAll(part);
        }
        return result;
    }

    public MappedElement createElement(ElementGeneratorContext cxt, ElementGroup filterGroup) {
        FacetPath rootPath = FacetPath.newAbsolutePath((FacetStep[])new FacetStep[0]);
        Var rootVar = cxt.scope.getStartVar();
        for (FacetPath path : cxt.facetTree.getRootItems()) {
            this.accumulateElements(cxt, filterGroup, rootVar, path, arg_0 -> cxt.facetTree.getChildren(arg_0));
        }
        Element elt = ElementGeneratorWorker.collect(cxt.facetPathToAcc, rootPath);
        elt = ElementUtils.flatten((Element)elt);
        elt = ElementUtils.mergeElements((Element)elt, (Element)filterGroup);
        TreeDataMap facetPathToAcc = cxt.facetPathToAcc.mapKeys(facetPath -> ScopedFacetPath.of(cxt.getScope(), (Path<FacetStep>)facetPath));
        BiMap pathToVar = (BiMap)cxt.pathToVar.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<ScopedFacetPath, Var>(ScopedFacetPath.of(cxt.getScope(), (Path<FacetStep>)((Path)e.getKey())), (Var)e.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (u, v) -> u, HashBiMap::create));
        return new MappedElement((TreeDataMap<ScopedFacetPath, ElementAcc>)facetPathToAcc, (Map<ScopedFacetPath, Var>)pathToVar, elt);
    }

    public void createElementsForExprs2(ElementGeneratorContext cxt, ElementGroup globalAcc, Collection<Expr> baseExprs, boolean negate) {
        NodeTransform resolveFacetPaths = NodeCustom.createNodeTransform(FacetPath.class, fp -> this.resolve(ScopedFacetPath.of(cxt.getScope(), (Path<FacetStep>)fp)));
        LinkedHashSet<ElementFilter> result = new LinkedHashSet<ElementFilter>();
        LinkedHashSet<Expr> resolvedExprs = new LinkedHashSet<Expr>();
        List tmp = baseExprs.stream().map(e -> FacetedQueryGenerator.isAbsent(e) ? FacetedQueryGenerator.internalRewriteAbsent(e) : e).collect(Collectors.toList());
        ArrayList exprs = new ArrayList(tmp);
        Collections.sort(exprs, FacetedQueryGenerator::compareAbsent);
        for (Expr expr : exprs) {
            Expr resolved = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(resolveFacetPaths), (Expr)expr);
            resolvedExprs.add(resolved);
        }
        Expr resolvedPathExpr = ExprUtils.orifyBalanced(resolvedExprs);
        if (resolvedPathExpr != null) {
            if (negate) {
                resolvedPathExpr = new E_LogicalNot(resolvedPathExpr);
            }
            if (!NodeValue.TRUE.equals((Object)resolvedPathExpr)) {
                result.add(new ElementFilter(resolvedPathExpr));
            }
        }
        result.forEach(arg_0 -> ((ElementGroup)globalAcc).addElement(arg_0));
    }

    public Var resolve(ScopedFacetPath sfp) {
        return FacetPathMappingImpl.resolveVar(this.pathMapping, sfp).asVar();
    }

    public void createElementsForExprs(Collection<Expr> baseExprs, boolean negate) {
        LinkedHashSet seenExprs = new LinkedHashSet();
        NodeTransform resolveFacetPaths = NodeCustom.createNodeTransform(ScopedFacetPath.class, this::resolve);
        LinkedHashSet<ElementFilter> result = new LinkedHashSet<ElementFilter>();
        LinkedHashSet<Expr> resolvedExprs = new LinkedHashSet<Expr>();
        List tmp = baseExprs.stream().map(e -> FacetedQueryGenerator.isAbsent(e) ? FacetedQueryGenerator.internalRewriteAbsent(e) : e).collect(Collectors.toList());
        ArrayList exprs = new ArrayList(tmp);
        Collections.sort(exprs, FacetedQueryGenerator::compareAbsent);
        for (Expr expr : exprs) {
            this.allocateElements(expr);
        }
        for (Expr expr : exprs) {
            Expr resolved = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(resolveFacetPaths), (Expr)expr);
            resolvedExprs.add(resolved);
        }
        Expr resolvedPathExpr = ExprUtils.orifyBalanced(resolvedExprs);
        if (resolvedPathExpr != null) {
            if (negate) {
                resolvedPathExpr = new E_LogicalNot(resolvedPathExpr);
            }
            if (!NodeValue.TRUE.equals((Object)resolvedPathExpr)) {
                result.add(new ElementFilter(resolvedPathExpr));
            }
        }
    }

    public static Element collect(TreeDataMap<FacetPath, ElementAcc> tree, FacetPath currentPath) {
        ElementGroup result;
        ElementAcc eltAcc = (ElementAcc)tree.get((Object)currentPath);
        if (eltAcc != null) {
            Element elt = eltAcc.getElement();
            List children = tree.getChildren((Object)currentPath);
            ArrayList<Element> childElts = new ArrayList<Element>();
            if (children != null && children.iterator().hasNext()) {
                for (FacetPath childPath : children) {
                    Element childElt = ElementGeneratorWorker.collect(tree, childPath);
                    childElts.add(childElt);
                }
            }
            result = eltAcc.getFactory().apply(elt, childElts);
        } else {
            result = new ElementGroup();
        }
        return result;
    }
}

