/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import com.google.common.graph.Traverser;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.commons.path.core.Path;
import org.aksw.commons.path.core.PathBase;
import org.aksw.commons.path.core.PathWrapperBase;
import org.aksw.commons.util.direction.Direction;
import org.aksw.facete.v3.api.NodeFacetPath;
import org.aksw.facete.v3.api.TreeData;
import org.aksw.facete.v3.api.TreeQueryNode;
import org.aksw.facete.v3.api.VarScope;
import org.aksw.facete.v4.impl.ElementGeneratorContext;
import org.aksw.facete.v4.impl.ElementGeneratorUtils;
import org.aksw.facete.v4.impl.ElementGeneratorWorker;
import org.aksw.facete.v4.impl.FacetNodeImpl;
import org.aksw.facete.v4.impl.FacetPathUtils;
import org.aksw.facete.v4.impl.FacetedQueryImpl;
import org.aksw.facete.v4.impl.FacetedRelationQuery;
import org.aksw.facete.v4.impl.MappedElement;
import org.aksw.facete.v4.impl.MappedQuery;
import org.aksw.facete.v4.impl.PropertyResolver;
import org.aksw.facete.v4.impl.PropertyResolverImpl;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.FacetPathMapping;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.api.RelationQuery;
import org.aksw.jenax.facete.treequery2.api.ScopedFacetPath;
import org.aksw.jenax.facete.treequery2.impl.ElementGeneratorLateral;
import org.aksw.jenax.facete.treequery2.impl.FacetConstraints;
import org.aksw.jenax.facete.treequery2.impl.FacetPathMappingImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.path.core.HasFacetPath;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.api.HasElement;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.fragment.impl.FragmentUtils;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_NotOneOf;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementFilter;

public class ElementGenerator {
    protected Element baseElement;
    protected ScopedFacetPath focusPath;
    protected FacetPathMapping pathMapping;
    protected PropertyResolver propertyResolver = new PropertyResolverImpl();
    protected TreeData<ScopedFacetPath> facetTree = new TreeData();
    protected SetMultimap<ScopedFacetPath, Expr> constraintIndex;

    public ElementGenerator(FacetPathMapping pathMapping, SetMultimap<ScopedFacetPath, Expr> constraintIndex, ScopedFacetPath focusPath) {
        this.pathMapping = pathMapping;
        this.constraintIndex = constraintIndex;
        this.focusPath = focusPath;
        this.baseElement = null;
    }

    public void setBaseElement(Element baseElement) {
        this.baseElement = baseElement;
    }

    public Element getBaseElement() {
        return this.baseElement;
    }

    public FacetPathMapping getPathMapping() {
        return this.pathMapping;
    }

    public void addPath(ScopedFacetPath facetPath) {
        this.facetTree.putItem((Object)facetPath, PathWrapperBase::getParent);
    }

    public void addExpr(Expr expr) {
        Set paths = NodeCustom.mentionedValues(ScopedFacetPath.class, (Expr)expr);
        for (ScopedFacetPath path : paths) {
            this.addPath(path);
            this.constraintIndex.put((Object)path, (Object)expr);
        }
    }

    public static ElementGenerator configure(ConstraintNode<NodeQuery> cn) {
        NodeQuery nq = (NodeQuery)cn.getRoot();
        RelationQuery rq = nq.relationQuery();
        Fragment baseRelation = rq.getRelation();
        List rootVars = baseRelation.getVars();
        Object result = null;
        Iterator iterator = rootVars.iterator();
        if (iterator.hasNext()) {
            Var rootVar = (Var)iterator.next();
            TreeData treeData = new TreeData();
            ScopedFacetPath focusPath = nq.getRoot().getScopedFacetPath();
            treeData.putItem((Object)focusPath, PathWrapperBase::getParent);
            Set<Expr> constraintExprs = ElementGeneratorLateral.createScopedConstraintExprs(rq);
            SetMultimap constraintIndex = FacetConstraints.createConstraintIndex(ScopedFacetPath.class, constraintExprs);
            Concept baseConcept = new Concept(baseRelation.getElement(), rootVar);
            FacetPathMappingImpl fpm = new FacetPathMappingImpl();
            ElementGenerator eltGen = new ElementGenerator(fpm, constraintIndex, focusPath);
            Traverser.forTree(arg_0 -> ((TreeData)treeData).getChildren(arg_0)).depthFirstPreOrder((Iterable)treeData.getRootItems()).forEach(eltGen::addPath);
            return eltGen;
        }
        return null;
    }

    @Deprecated
    public static ElementGenerator configure(FacetedQueryImpl fq) {
        FacetedRelationQuery frq = fq.relationQuery;
        Fragment baseRelation = frq.baseRelation.get();
        List rootVars = baseRelation.getVars();
        org.aksw.facete.v3.api.FacetConstraints constraints = frq.constraints;
        Object result = null;
        Iterator iterator = rootVars.iterator();
        if (iterator.hasNext()) {
            Var rootVar = (Var)iterator.next();
            TreeData treeData = new TreeData();
            FacetNodeImpl focusNode = (FacetNodeImpl)frq.getFacetedQuery().focus();
            TreeQueryNode tq = focusNode.node;
            ScopedFacetPath focusPath = ScopedFacetPath.of(rootVar, tq.getFacetPath());
            treeData.putItem((Object)focusPath, PathWrapperBase::getParent);
            SetMultimap<ScopedFacetPath, Expr> constraintIndex = ElementGenerator.createConstraintIndex(constraints, (TreeData<ScopedFacetPath>)treeData);
            Concept baseConcept = new Concept(baseRelation.getElement(), rootVar);
            FacetPathMappingImpl fpm = new FacetPathMappingImpl();
            ElementGenerator eltGen = new ElementGenerator(fpm, constraintIndex, focusPath);
            Traverser.forTree(arg_0 -> ((TreeData)treeData).getChildren(arg_0)).depthFirstPreOrder((Iterable)treeData.getRootItems()).forEach(eltGen::addPath);
            return eltGen;
        }
        return null;
    }

    public static SetMultimap<VarScope, Expr> createUnscopedConstraintExprs(Collection<Expr> scopedExprs) {
        HashMultimap result = HashMultimap.create();
        for (Expr expr : scopedExprs) {
            Set sfps = NodeCustom.mentionedValues(ScopedFacetPath.class, (Expr)expr);
            Multimap index = (Multimap)sfps.stream().collect(Multimaps.toMultimap(ScopedFacetPath::getScope, ScopedFacetPath::getFacetPath, HashMultimap::create));
            if (index.keySet().isEmpty()) {
                System.err.println("WARN: Constraint without path reference found " + String.valueOf(expr));
            }
            if (index.keySet().size() > 1) {
                throw new UnsupportedOperationException("Expressions with different scopes in facet paths currently not supported");
            }
            VarScope scope = (VarScope)index.keySet().iterator().next();
            Expr e = expr.applyNodeTransform(NodeCustom.mapValue(ScopedFacetPath.class, ScopedFacetPath::getFacetPath));
            result.put((Object)scope, (Object)e);
        }
        return result;
    }

    public static SetMultimap<ScopedFacetPath, Expr> createConstraintIndex(org.aksw.facete.v3.api.FacetConstraints constraints, TreeData<ScopedFacetPath> treeData) {
        Collection exprs = constraints.getExprs();
        HashMultimap constraintIndex = HashMultimap.create();
        for (Expr expr : exprs) {
            Set paths = NodeCustom.mentionedValues(ScopedFacetPath.class, (Expr)expr);
            for (ScopedFacetPath cleanPath : paths) {
                treeData.putItem((Object)cleanPath, PathWrapperBase::getParent);
                constraintIndex.put((Object)cleanPath, (Object)expr);
            }
        }
        return constraintIndex;
    }

    public static MappedQuery createQuery(FacetedRelationQuery frq) {
        Fragment baseRelation = frq.baseRelation.get();
        List rootVars = baseRelation.getVars();
        org.aksw.facete.v3.api.FacetConstraints constraints = frq.constraints;
        MappedQuery result = null;
        for (Var rootVar : rootVars) {
            TreeData treeData = new TreeData();
            FacetNodeImpl focusNode = (FacetNodeImpl)frq.getFacetedQuery().focus();
            TreeQueryNode tq = focusNode.node;
            FacetPath focusPath = tq.getFacetPath();
            treeData.putItem((Object)focusPath, PathBase::getParent);
            Collection exprs = constraints.getExprs();
            HashMultimap constraintIndex = HashMultimap.create();
            for (Expr expr : exprs) {
                Set paths = NodeCustom.mentionedValues(FacetPath.class, (Expr)expr);
                HashMap<FacetPath, FacetPath> remap = new HashMap<FacetPath, FacetPath>();
                for (FacetPath path : paths) {
                    remap.put(path, ElementGeneratorUtils.cleanPath(path));
                }
                Expr effectiveExpr = NodeTransformLib.transform((NodeTransform)NodeTransformLib2.wrapWithNullAsIdentity(node -> {
                    Node r = null;
                    if (node instanceof NodeFacetPath) {
                        FacetPath fp = ((HasFacetPath)((NodeFacetPath)node).getValue()).getFacetPath();
                        FacetPath q = (FacetPath)remap.get(fp);
                        return q == null ? node : NodeFacetPath.of(() -> q);
                    }
                    return r;
                }), (Expr)expr);
                for (FacetPath path : remap.values()) {
                    FacetPath cleanPath = ElementGeneratorUtils.cleanPath(path);
                    treeData.putItem((Object)cleanPath, PathBase::getParent);
                    constraintIndex.put((Object)cleanPath, (Object)effectiveExpr);
                }
            }
            Concept baseConcept = new Concept(baseRelation.getElement(), rootVar);
            Predicate<FacetPath> isProjected = frq::isVisible;
            result = ElementGenerator.createQuery((Fragment1)baseConcept, (TreeData<FacetPath>)treeData, (SetMultimap<FacetPath, Expr>)constraintIndex, isProjected);
        }
        return result;
    }

    public Collection<Expr> transformAddScope(Collection<Expr> exprs, VarScope scope) {
        NodeTransform constraintTransform = NodeCustom.mapValue(ScopedFacetPath.class, fp -> ScopedFacetPath.of(scope, (Path<FacetStep>)fp));
        Collection result = exprs.stream().map(e -> e.applyNodeTransform(constraintTransform)).collect(Collectors.toList());
        return result;
    }

    public static MappedQuery createQuery(Fragment1 baseConcept, TreeData<FacetPath> rawTreeData, SetMultimap<FacetPath, Expr> constraintIndex, Predicate<FacetPath> isProjected) {
        Var rootVar = baseConcept.getVar();
        VarScope scope = VarScope.of((Var)rootVar);
        TreeData treeData = rawTreeData.map(facetPath -> ScopedFacetPath.of(rootVar, facetPath));
        FacetPathMappingImpl fpm = new FacetPathMappingImpl();
        PropertyResolverImpl propertyResolver = new PropertyResolverImpl();
        ElementGeneratorWorker worker = new ElementGeneratorWorker(fpm, propertyResolver);
        ElementGeneratorContext cxt = worker.getOrCreateContext(scope);
        cxt.setFacetTree(rawTreeData).setConstraintIndex(constraintIndex);
        Element elt = worker.createElement().getElement();
        elt = ElementUtils.flatMerge((Element[])new Element[]{baseConcept.getElement(), elt});
        List visibleVars = cxt.getPathToVar().entrySet().stream().filter(e -> isProjected.test((FacetPath)e.getKey())).map(Map.Entry::getValue).collect(Collectors.toList());
        Query query = new Query();
        query.setQuerySelectType();
        query.setQueryPattern(elt);
        query.addProjectVars(visibleVars);
        BiMap<ScopedFacetPath, Var> varMap = worker.getPathToVar();
        System.err.println("Generated Query: " + String.valueOf(query));
        MappedQuery result = new MappedQuery((TreeData<ScopedFacetPath>)treeData, query, (BiMap<Var, ScopedFacetPath>)varMap.inverse());
        return result;
    }

    public Fragment1 getAvailableValuesAt(ScopedFacetPath path, boolean applySelfConstraints) {
        SetMultimap<ScopedFacetPath, Expr> effectiveConstraints = applySelfConstraints ? this.constraintIndex : ElementGeneratorUtils.hideConstraintsForPath(this.constraintIndex, path);
        Var var = FacetPathMappingImpl.resolveVar(this.pathMapping, path).asVar();
        MappedElement me = new ElementGeneratorWorker(this.facetTree, effectiveConstraints, this.pathMapping, this.propertyResolver).createElement();
        return new Concept(me.getElement(), var);
    }

    public Fragment3 createRelationFacetValue(ScopedFacetPath focus, ScopedFacetPath facetPath, Direction direction, Fragment1 pFilter, Fragment1 oFilter, boolean applySelfConstraints, boolean includeAbsent) {
        Map<String, Fragment3> facetValues = this.createMapFacetsAndValues(facetPath, direction, false, applySelfConstraints, includeAbsent);
        List elements = facetValues.values().stream().map(e -> FragmentUtils.rename((Fragment)e, Arrays.asList(Vars.s, Vars.p, Vars.o))).map(Fragment::toFragment3).map(e -> pFilter == null ? e : e.joinOn(new Var[]{e.getP()}).with(pFilter)).map(HasElement::getElement).collect(Collectors.toList());
        Element e2 = ElementUtils.unionIfNeeded(elements);
        Fragment3Impl result = new Fragment3Impl(e2, Vars.s, Vars.p, Vars.o);
        return result;
    }

    public Map<String, Fragment3> createMapFacetsAndValues(ScopedFacetPath facetOriginPath, Direction direction, boolean applySelfConstraints, boolean negated, boolean includeAbsent) {
        HashMap<String, Fragment3> result = new HashMap<String, Fragment3>();
        Set constrainedPaths = this.constraintIndex.keySet();
        Set<ScopedFacetPath> constrainedChildPaths = FacetPathUtils.getDirectChildren(facetOriginPath, direction, constrainedPaths);
        Var focusVar = FacetPathMappingImpl.resolveVar(this.pathMapping, this.focusPath).asVar();
        for (ScopedFacetPath childPath : constrainedChildPaths) {
            FacetStep facetStep = (FacetStep)((ScopedFacetPath)facetOriginPath.relativize((Path)childPath)).toSegment();
            MappedElement mr = this.createRelationForPath(childPath, applySelfConstraints, negated, includeAbsent);
            Var childVar = mr.getVar(childPath);
            List elts = ElementUtils.flatMergeList((Element[])new Element[]{this.baseElement, mr.getElement()});
            elts.add(new ElementBind(Vars.p, (Expr)NodeValue.makeNode((Node)facetStep.getNode())));
            Fragment3Impl br = new Fragment3Impl(ElementUtils.groupIfNeeded((Iterable)elts), focusVar, Vars.p, childVar);
            String pStr2 = childPath.getParent() == null ? "" : ((FacetStep)((FacetPath)childPath.getFacetPath().getFileName()).toSegment()).getNode().getURI();
            pStr2 = pStr2 == null ? "" : pStr2;
            result.put(pStr2, (Fragment3)br);
        }
        Fragment2 brrx = this.getRemainingFacetsWithoutAbsent(facetOriginPath, direction, negated, includeAbsent);
        Fragment3Impl brr = new Fragment3Impl(brrx.getElement(), focusVar, brrx.getSourceVar(), brrx.getTargetVar());
        ExprList constrainedPredicates = new ExprList(result.keySet().stream().filter(pStr -> !pStr.isEmpty()).map(NodeFactory::createURI).map(NodeValue::makeNode).collect(Collectors.toList()));
        if (!constrainedPredicates.isEmpty()) {
            List foo = brr.getElements();
            foo.add(new ElementFilter((Expr)new E_NotOneOf((Expr)new ExprVar(brrx.getSourceVar()), constrainedPredicates)));
            brr = new Fragment3Impl(ElementUtils.groupIfNeeded((Iterable)foo), brr.getS(), brr.getP(), brr.getO());
        }
        result.put((String)null, (Fragment3)brr);
        return result;
    }

    public MappedElement createRelationForPath(ScopedFacetPath childPath, boolean applySelfConstraints, boolean negated, boolean includeAbsent) {
        SetMultimap<ScopedFacetPath, Expr> effectiveConstraints = applySelfConstraints ? this.constraintIndex : ElementGeneratorUtils.hideConstraintsForPath(this.constraintIndex, childPath);
        MappedElement result = new ElementGeneratorWorker(this.facetTree, effectiveConstraints, this.pathMapping, this.propertyResolver).createElement();
        return result;
    }

    public Fragment2 getRemainingFacetsWithoutAbsent(ScopedFacetPath sourceFacetPath, Direction direction, boolean negated, boolean includeAbsent) {
        FacetStep pStep = FacetStep.of((Node)NodeUtils.ANY_IRI, (Direction)direction, null, (Node)FacetStep.PREDICATE);
        FacetStep oStep = FacetStep.of((Node)NodeUtils.ANY_IRI, (Direction)direction, null, (Node)FacetStep.TARGET);
        ScopedFacetPath pPath = (ScopedFacetPath)sourceFacetPath.resolve(pStep);
        ScopedFacetPath oPath = (ScopedFacetPath)sourceFacetPath.resolve(oStep);
        TreeData newTree = this.facetTree.cloneTree();
        newTree.putItem((Object)pPath, PathWrapperBase::getParent);
        newTree.putItem((Object)oPath, PathWrapperBase::getParent);
        ElementGeneratorWorker worker = new ElementGeneratorWorker((TreeData<ScopedFacetPath>)newTree, this.constraintIndex, this.pathMapping, this.propertyResolver);
        worker.declareMandatoryPath(oPath);
        MappedElement me = worker.createElement();
        Element elt = ElementUtils.flatMerge((Element[])new Element[]{this.baseElement, me.getElement()});
        Var pVar = me.getVar(pPath);
        Var oVar = me.getVar(oPath);
        Fragment2Impl result = new Fragment2Impl(elt, pVar, oVar);
        return result;
    }
}

