/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.FacetCount;
import org.aksw.facete.v3.api.FacetDirNode;
import org.aksw.facete.v3.api.FacetMultiNode;
import org.aksw.facete.v3.api.FacetNodeResource;
import org.aksw.facete.v3.api.FacetValueCount;
import org.aksw.facete.v3.api.FacetedDataQuery;
import org.aksw.facete.v3.api.FacetedQueryResource;
import org.aksw.facete.v3.bgp.api.BgpDirNode;
import org.aksw.facete.v3.bgp.api.BgpMultiNode;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.bgp.utils.PathAccessorImpl;
import org.aksw.facete.v3.impl.FacetMultiNodeImpl;
import org.aksw.facete.v3.impl.FacetedDataQueryImpl;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jena_sparql_api.data_query.impl.FacetedQueryGenerator;
import org.aksw.jena_sparql_api.utils.views.map.MapVocab;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_IsBlank;
import org.apache.jena.sparql.expr.E_LogicalNot;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprVar;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.Template;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class FacetDirNodeImpl
implements FacetDirNode {
    protected FacetNodeResource parent;
    protected BgpDirNode state;

    public FacetDirNodeImpl(FacetNodeResource parent, BgpDirNode state) {
        this.parent = parent;
        this.state = state;
    }

    public FacetNodeResource parent() {
        return this.parent;
    }

    public Direction dir() {
        Direction result = this.state.isFwd() ? Direction.FORWARD : Direction.BACKWARD;
        return result;
    }

    public FacetMultiNode via(Resource property, Node component) {
        if (component != null && !FacetStep.isTarget((Node)component)) {
            throw new UnsupportedOperationException("Components not supported yet");
        }
        return new FacetMultiNodeImpl(this.parent, (BgpMultiNode)this.state.via(property));
    }

    public FacetedDataQuery<RDFNode> facets(boolean includeAbsent) {
        FacetedQueryResource facetedQuery = this.parent().query();
        BgpNode focus = facetedQuery.modelRoot().getFocus();
        BgpNode bgpRoot = facetedQuery.modelRoot().getBgpRoot();
        FacetedQueryGenerator<BgpNode> qgen = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl((RDFNode)bgpRoot));
        Fragment1 baseConcept = this.query().baseConcept();
        qgen.setBaseConcept(baseConcept);
        facetedQuery.modelRoot().constraints().forEach(c -> qgen.addConstraint(c.expr()));
        Map<String, Fragment3> relations = qgen.getFacetValuesCore(baseConcept, focus, this.parent.state(), null, null, !this.state.isFwd(), false, false, includeAbsent);
        Fragment1 concept = FacetedQueryGenerator.createConceptFacets(relations, null);
        FacetedDataQueryImpl<RDFNode> result = new FacetedDataQueryImpl<RDFNode>(this.parent.query().connection(), concept.getElement(), concept.getVar(), null, RDFNode.class);
        return result;
    }

    public FacetedDataQuery<FacetCount> facetCounts(boolean includeAbsent) {
        FacetedDataQuery<FacetCount> result = this.facetCounts(includeAbsent, false);
        return result;
    }

    public FacetedDataQuery<FacetCount> facetFocusCounts(boolean includeAbsent) {
        FacetedDataQuery<FacetCount> result = this.facetCounts(includeAbsent, true);
        return result;
    }

    public FacetedDataQuery<FacetCount> facetCounts(boolean includeAbsent, boolean focusCount) {
        FacetedQueryResource facetedQuery = this.parent().query();
        BgpNode bgpRoot = facetedQuery.modelRoot().getBgpRoot();
        BgpNode focus = facetedQuery.modelRoot().getFocus();
        FacetedQueryGenerator<BgpNode> qgen = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl((RDFNode)bgpRoot));
        Fragment1 baseConcept = this.query().baseConcept();
        qgen.setBaseConcept(baseConcept);
        facetedQuery.constraints().forEach(c -> qgen.addConstraint(c.expr()));
        Map<String, Fragment3> relations = qgen.getFacetValuesCore(baseConcept, focus, this.parent.state(), null, null, !this.state.isFwd(), false, false, includeAbsent);
        Fragment2 br = FacetedQueryGenerator.createRelationFacetsAndCounts(relations, null, includeAbsent, focusCount);
        BasicPattern bgp = new BasicPattern();
        bgp.add(Triple.create((Node)br.getSourceVar(), (Node)Vocab.facetCount.asNode(), (Node)br.getTargetVar()));
        Template template = new Template(bgp);
        FacetedDataQueryImpl<FacetCount> result = new FacetedDataQueryImpl<FacetCount>(this.parent.query().connection(), br.getElement(), br.getSourceVar(), template, FacetCount.class);
        return result;
    }

    public FacetedDataQuery<FacetValueCount> facetValueTypeCounts() {
        Fragment3 tr = this.createQueryGenerator().createRelationFacetValueTypeCounts(this.parent().query().focus().state(), this.parent().state(), !this.state.isFwd(), false, null, null, false);
        FacetedDataQuery<FacetValueCount> result = this.createQueryFacetValueCounts(tr);
        return result;
    }

    public FacetedDataQuery<FacetValueCount> facetValueCounts() {
        Fragment3 tr = this.createQueryGenerator().createRelationFacetValueCounts(this.parent().query().focus().state(), this.parent().state(), !this.state.isFwd(), false, null, null, false);
        FacetedDataQuery<FacetValueCount> result = this.createQueryFacetValueCounts(tr);
        return result;
    }

    public Fragment2 facetValueRelation() {
        FacetedQueryResource facetedQuery = this.parent().query();
        FacetedQueryGenerator<BgpNode> qgen = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl((RDFNode)facetedQuery.modelRoot().getBgpRoot()));
        facetedQuery.constraints().forEach(c -> qgen.addConstraint(c.expr()));
        Fragment3 tr = qgen.createRelationFacetValue(this.parent().query().focus().state(), this.parent().state(), !this.state.isFwd(), null, null, false, false);
        Fragment2Impl result = new Fragment2Impl(tr.getElement(), tr.getP(), tr.getO());
        return result;
    }

    public FacetedQueryGenerator<BgpNode> createQueryGenerator() {
        FacetedQueryResource facetedQuery = this.parent().query();
        FacetedQueryGenerator<BgpNode> result = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl((RDFNode)facetedQuery.modelRoot().getBgpRoot()));
        result.setBaseConcept(this.query().baseConcept());
        facetedQuery.constraints().forEach(c -> result.addConstraint(c.expr()));
        return result;
    }

    public FacetedDataQuery<FacetValueCount> createQueryFacetValueCounts(Fragment3 tr) {
        ArrayList<ElementFilter> filters = new ArrayList<ElementFilter>();
        boolean discardBlankNodes = false;
        if (discardBlankNodes) {
            filters.add(new ElementFilter((Expr)new E_LogicalOr((Expr)new E_LogicalNot((Expr)new E_Bound((Expr)new ExprVar(tr.getP()))), (Expr)new E_LogicalNot((Expr)new E_IsBlank((Expr)new ExprVar(tr.getP()))))));
        }
        tr = new Fragment3Impl((Element)ElementUtils.createElementGroup((Iterable)ImmutableList.builder().addAll((Iterable)tr.getElements()).addAll(filters).build()), tr.getS(), tr.getP(), tr.getO());
        BasicPattern bgp = new BasicPattern();
        Node superRoot = NodeFactory.createBlankNode();
        bgp.add(Triple.create((Node)superRoot, (Node)Vocab.predicate.asNode(), (Node)tr.getS()));
        bgp.add(Triple.create((Node)superRoot, (Node)MapVocab.value.asNode(), (Node)tr.getP()));
        bgp.add(Triple.create((Node)superRoot, (Node)Vocab.facetCount.asNode(), (Node)tr.getO()));
        Template template = new Template(bgp);
        FacetedDataQueryImpl<FacetValueCount> result = new FacetedDataQueryImpl<FacetValueCount>(this.parent.query().connection(), tr.getElement(), Arrays.asList(tr.getS(), tr.getP()), superRoot, tr.getS(), template, FacetValueCount.class);
        return result;
    }

    public FacetedDataQuery<FacetValueCount> nonConstrainedFacetValueCounts() {
        Fragment3 tr = this.createQueryGenerator().createRelationFacetValueCounts(this.parent().query().focus().state(), this.parent().state(), !this.state.isFwd(), true, null, null, false);
        FacetedDataQuery<FacetValueCount> result = this.createQueryFacetValueCounts(tr);
        return result;
    }

    public FacetedDataQuery<FacetValueCount> facetValueCountsWithAbsent(boolean includeAbsent) {
        Fragment3 tr = this.createQueryGenerator().createRelationFacetValueCounts(this.parent().query().focus().state(), this.parent().state(), !this.state.isFwd(), false, null, null, includeAbsent);
        FacetedDataQuery<FacetValueCount> result = this.createQueryFacetValueCounts(tr);
        return result;
    }

    public String toString() {
        Direction dir = this.dir();
        return (this.parent == null ? "" : this.parent.toString()) + (Direction.FORWARD.equals((Object)dir) ? "->" : "<-");
    }

    public boolean isFwd() {
        boolean result = this.state.isFwd();
        return result;
    }
}

