/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.base.Converter;
import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.Collection;
import java.util.Set;
import org.aksw.commons.collections.ConvertingCollection;
import org.aksw.commons.collections.ConvertingSet;
import org.aksw.facete.v3.api.ConstraintFacade;
import org.aksw.facete.v3.api.FacetConstraint;
import org.aksw.facete.v3.api.FacetConstraintControl;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetNodeResource;
import org.aksw.facete.v3.api.HLFacetConstraint;
import org.aksw.facete.v3.bgp.api.XFacetedQuery;
import org.aksw.facete.v3.impl.HLFacetConstraintImpl;
import org.aksw.facete.v3.impl.RangeSpec;
import org.aksw.jena_sparql_api.rdf.collections.SetFromPropertyValues;
import org.aksw.jenax.arq.util.expr.NodeValueUtils;
import org.aksw.jenax.arq.util.node.ComparableNodeValue;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.node.RangeUtils;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.sparql.expr.E_Bound;
import org.apache.jena.sparql.expr.E_Equals;
import org.apache.jena.sparql.expr.E_Regex;
import org.apache.jena.sparql.expr.E_Str;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class ConstraintFacadeImpl<B extends FacetNodeResource>
implements ConstraintFacade<B> {
    protected B parent;

    public ConstraintFacadeImpl(B parent) {
        this.parent = parent;
    }

    public Collection<FacetConstraintControl> list() {
        XFacetedQuery modelRoot = this.parent.query().modelRoot();
        ConvertingSet set = new ConvertingSet((Set)new SetFromPropertyValues((Resource)modelRoot, Vocab.constraint, FacetConstraint.class), Converter.from(x -> x, y -> (FacetConstraint)y));
        return set;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> createConstraint(Expr expr) {
        XFacetedQuery modelRoot = this.parent.query().modelRoot();
        FacetConstraint c = (FacetConstraint)modelRoot.getModel().createResource().as(FacetConstraint.class);
        c.expr(expr);
        HLFacetConstraintImpl<ConstraintFacadeImpl> result = new HLFacetConstraintImpl<ConstraintFacadeImpl>(this, (FacetNode)this.parent, (FacetConstraintControl)c);
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> exists() {
        E_Bound expr = new E_Bound(this.thisAsExpr());
        HLFacetConstraint result = this.getOrCreateConstraint((Expr)expr);
        return result;
    }

    public Expr thisAsExpr() {
        NodeValue result = NodeValue.makeNode((Node)this.parent.state().asNode());
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> eq(Node node) {
        HLFacetConstraint result;
        if (node == null || NodeUtils.nullUriNode.equals((Object)node)) {
            result = this.absent();
        } else {
            E_Equals expr = new E_Equals(this.thisAsExpr(), (Expr)NodeValue.makeNode((Node)node));
            result = this.getOrCreateConstraint((Expr)expr);
        }
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> gt(Node node) {
        return this.nodeRange((Range<ComparableNodeValue>)Range.greaterThan((Comparable)ComparableNodeValue.wrap((Node)node)));
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> lt(Node node) {
        return this.nodeRange((Range<ComparableNodeValue>)Range.lessThan((Comparable)ComparableNodeValue.wrap((Node)node)));
    }

    public HLFacetConstraint<ConstraintFacade<B>> neq(Node node) {
        throw new UnsupportedOperationException("not implemented");
    }

    public B end() {
        return this.parent;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> nodeRange(Range<ComparableNodeValue> range) {
        Expr expr = RangeUtils.createExpr((Node)this.parent.state().asNode(), range);
        HLFacetConstraint result = this.getOrCreateConstraint(expr);
        return result;
    }

    public Collection<HLFacetConstraint<? extends ConstraintFacade<B>>> listHl() {
        Collection<FacetConstraintControl> lowLevel = this.list();
        ConvertingCollection result = new ConvertingCollection(lowLevel, Converter.from(ll -> new HLFacetConstraintImpl<ConstraintFacadeImpl>(this, (FacetNode)this.parent, (FacetConstraintControl)ll), hl -> hl.state()));
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> absent() {
        E_Equals expr = new E_Equals(this.thisAsExpr(), (Expr)NodeValueUtils.NV_ABSENT);
        HLFacetConstraint result = this.getOrCreateConstraint((Expr)expr);
        return result;
    }

    public static Range<ComparableNodeValue> toNodeRange(Range<?> range) {
        RDFDatatype dtype;
        TypeMapper tm = TypeMapper.getInstance();
        Node lowerNode = null;
        Node upperNode = null;
        BoundType lowerBoundType = null;
        BoundType upperBoundType = null;
        if (range.hasLowerBound()) {
            lowerBoundType = range.lowerBoundType();
            Comparable lb = range.lowerEndpoint();
            Class<?> lbClass = lb.getClass();
            dtype = tm.getTypeByClass(lbClass);
            if (dtype == null) {
                throw new IllegalArgumentException("No type mapper entry for " + String.valueOf(lbClass));
            }
            lowerNode = NodeFactory.createLiteralByValue((Object)lb, (RDFDatatype)dtype);
        }
        if (range.hasUpperBound()) {
            upperBoundType = range.upperBoundType();
            Comparable ub = range.upperEndpoint();
            Class<?> ubClass = ub.getClass();
            dtype = tm.getTypeByClass(ubClass);
            if (dtype == null) {
                throw new IllegalArgumentException("No type mapper entry for " + String.valueOf(ubClass));
            }
            upperNode = NodeFactory.createLiteralByValue((Object)ub, (RDFDatatype)dtype);
        }
        ComparableNodeValue lowerNh = lowerNode == null ? null : ComparableNodeValue.wrap(lowerNode);
        ComparableNodeValue upperNh = upperNode == null ? null : ComparableNodeValue.wrap(upperNode);
        Range<ComparableNodeValue> result = RangeSpec.createRange(lowerNh, lowerBoundType, upperNh, upperBoundType);
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> range(Range<?> range) {
        Range<ComparableNodeValue> nodeRange = ConstraintFacadeImpl.toNodeRange(range);
        HLFacetConstraint<ConstraintFacade<B>> result = this.nodeRange(nodeRange);
        return result;
    }

    public HLFacetConstraint<? extends ConstraintFacade<B>> regex(String pattern, String flags) {
        E_Regex expr = new E_Regex((Expr)new E_Str(this.thisAsExpr()), pattern, flags);
        HLFacetConstraint result = this.getOrCreateConstraint((Expr)expr);
        return result;
    }
}

