/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.experimental;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.aksw.facete.v3.api.AliasedPath;
import org.aksw.facete.v3.api.AliasedPathImpl;
import org.aksw.facete.v3.api.path.Resolver;
import org.aksw.facete.v3.api.path.ResolverBase;
import org.aksw.facete.v3.experimental.ResolverData;
import org.aksw.facete.v3.experimental.ResolverUnion;
import org.aksw.jena_sparql_api.data_query.impl.QueryFragment;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.relationlet.RelationletBinary;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.arq.util.var.VarGeneratorBlacklist;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.relation.query.PartitionedQuery1;
import org.aksw.jenax.sparql.relation.query.PartitionedQuery1Impl;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.syntaxtransform.NodeTransformSubst;

public class ResolverTemplate
extends ResolverBase {
    protected boolean singlePathMode = true;
    protected Fragment2 reachingRelation;
    protected Fragment2 reachingRelationContrib;
    protected Query query;
    protected RDFNode start;
    protected ResolverTemplate parent;

    public Node getStartNode() {
        Node result = this.start.asNode();
        return result;
    }

    public Collection<RelationletBinary> getReachingRelationlet() {
        Node tgtNode = this.getStartNode();
        Node srcNode = ((ResolverTemplate)this.getRoot()).getStartNode();
        Var tgtVar = tgtNode.isVariable() ? (Var)tgtNode : Vars.o;
        Var srcVar = srcNode.isVariable() ? (Var)srcNode : Vars.s;
        Fragment2Impl br = this.reachingRelationContrib == null ? new Fragment2Impl((Element)new ElementGroup(), srcVar, tgtVar) : this.reachingRelationContrib;
        RelationletBinary rb = new RelationletBinary((Fragment2)br);
        rb.pinVar(tgtVar);
        Set<RelationletBinary> result = Collections.singleton(rb);
        return result;
    }

    public Collection<Fragment2> getPaths() {
        Var v = (Var)this.start.asNode();
        Set<Fragment2Impl> result = Collections.singleton(this.reachingRelation == null ? new Fragment2Impl((Element)new ElementGroup(), v, v) : this.reachingRelation);
        return result;
    }

    protected ResolverTemplate(ResolverTemplate parent, Query query, RDFNode start, Fragment2 reachingRelation, Fragment2 reachingRelationContrib) {
        super((Resolver)parent);
        this.query = query;
        this.start = start;
        this.reachingRelation = reachingRelation;
        this.reachingRelationContrib = reachingRelationContrib;
    }

    public Resolver resolve(P_Path0 step, String alias) {
        ArrayList<Resolver> tmp = new ArrayList<Resolver>();
        tmp.addAll(this.resolveTemplate(step, alias));
        if (tmp.isEmpty() || !this.singlePathMode) {
            Collection<Resolver> subResolvers = this.resolveData(step, alias);
            tmp.addAll(subResolvers);
        }
        ResolverUnion result = new ResolverUnion((Resolver)this, tmp);
        return result;
    }

    public ResolverTemplate resolveTemplateSimple(P_Path0 step, String alias) {
        Var startVar = (Var)this.start.asNode();
        Set targets = ResourceUtils.listPropertyValues((Resource)this.start.asResource(), (P_Path0)step).toSet();
        if (this.singlePathMode && targets.size() > 1) {
            throw new RuntimeException("Simple resolution requires at most one path; but " + String.valueOf(this.start) + " resolved to these multiple targets " + String.valueOf(targets) + " in pattern " + String.valueOf(this.query));
        }
        ResolverTemplate result = targets.size() == 1 ? new ResolverTemplate(this, this.query, (RDFNode)targets.iterator().next(), null, null) : null;
        return result;
    }

    protected Collection<Resolver> resolveTemplate(P_Path0 step, String alias) {
        Node startVar = this.start.asNode();
        LinkedHashSet<RDFNode> targets = ResourceUtils.listPropertyValues((Resource)this.start.asResource(), (P_Path0)step).toSet();
        if (this.singlePathMode && targets.size() > 1) {
            throw new RuntimeException("Single path mode enabled; but " + String.valueOf(this.start) + " resolved to these multiple targets " + String.valueOf(targets) + " in pattern " + String.valueOf(this.query));
        }
        ArrayList<Resolver> result = new ArrayList<Resolver>();
        LinkedHashSet<RDFNode> newTargets = targets;
        if (alias != null && !targets.isEmpty()) {
            HashMap<Var, Var> renameMap = new HashMap<Var, Var>();
            NodeTransformCollectNodes collector = new NodeTransformCollectNodes();
            QueryUtils.applyNodeTransform((Query)this.query, (NodeTransform)collector);
            Collection vars = collector.getNodes().stream().filter(n -> n.isVariable()).map(n -> (Var)n).collect(Collectors.toSet());
            for (Var var : vars) {
                if (var.equals((Object)startVar)) continue;
                String varName = var.getName();
                Var newName = Var.alloc((String)(alias + "_" + varName));
                renameMap.put(var, newName);
            }
            Query newQuery = QueryUtils.applyNodeTransform((Query)this.query, (NodeTransform)new NodeTransformSubst(renameMap));
            newTargets = new LinkedHashSet<RDFNode>();
            for (RDFNode oldT : targets) {
                Fragment2Impl relation;
                Model m = oldT.getModel();
                Node o = oldT.asNode();
                Var newT = (Var)renameMap.get(o);
                RDFNode newN = newT == null ? oldT : m.asRDFNode((Node)newT);
                newTargets.add(newN);
                Fragment2Impl relationContrib = new Fragment2Impl(newQuery.getQueryPattern(), (Var)startVar, newT);
                if (this.reachingRelation != null) {
                    Element grouped = ElementUtils.groupIfNeeded((Iterable)Iterables.concat((Iterable)this.reachingRelation.getElements(), (Iterable)relationContrib.getElements()));
                    relation = new Fragment2Impl(grouped, this.reachingRelation.getSourceVar(), relationContrib.getTargetVar());
                } else {
                    relation = relationContrib;
                }
                result.add((Resolver)new ResolverTemplate(this, newQuery, newN, (Fragment2)relation, (Fragment2)relationContrib));
            }
        } else {
            for (RDFNode oldT : targets) {
                result.add((Resolver)new ResolverTemplate(this, this.query, oldT, null, null));
            }
        }
        return result;
    }

    protected Collection<Resolver> resolveData(P_Path0 step, String alias) {
        ArrayList<Resolver> result = new ArrayList<Resolver>();
        PartitionedQuery1Impl tmp = new PartitionedQuery1Impl(this.query, (Var)this.start.asNode());
        ResolverData item = new ResolverData((Resolver)this, (PartitionedQuery1)tmp, (AliasedPath)AliasedPathImpl.empty().subPath((Object)Maps.immutableEntry((Object)step, (Object)alias)), this.reachingRelation);
        result.add((Resolver)item);
        return result;
    }

    public Collection<Fragment3> getRdfGraphSpec(boolean isFwd) {
        ArrayList<Fragment3> result = new ArrayList<Fragment3>();
        Element basePattern = this.query.getQueryPattern();
        Collection baseVars = PatternVars.vars((Element)basePattern);
        Var var = (Var)this.start.asNode();
        Concept templateConcept = new Concept(basePattern, var);
        List stmts = ResourceUtils.listProperties((RDFNode)this.start, (boolean)isFwd).toList();
        for (Statement stmt : stmts) {
            Fragment3Impl tr;
            Node s = stmt.getSubject().asNode();
            Node p = stmt.getPredicate().asNode();
            Node o = stmt.getObject().asNode();
            if (p.isVariable()) {
                tr = new Fragment3Impl(basePattern, (Var)s, (Var)p, (Var)o);
            } else {
                Var freshP = VarGeneratorBlacklist.create((Collection)baseVars).next();
                NodeValue nvp = NodeValue.makeNode((Node)p);
                tr = new Fragment3Impl(ElementUtils.groupIfNeeded((Element[])new Element[]{basePattern, new ElementBind(freshP, (Expr)nvp)}), (Var)s, freshP, (Var)o);
            }
            result.add((Fragment3)tr);
        }
        Fragment3Impl tmp = new Fragment3Impl((Element)ElementUtils.createElement((Triple)QueryFragment.createTriple(!isFwd, (Node)Vars.s, (Node)Vars.p, (Node)Vars.o)), Vars.s, Vars.p, Vars.o);
        Fragment3 todebug = tmp.joinOn(new Var[]{tmp.getS()}).with((Fragment1)templateConcept).toFragment3();
        Fragment3 tr = tmp.prependOn(new Var[]{tmp.getS()}).with((Fragment1)templateConcept).toFragment3();
        result.add(tr);
        return result;
    }
}

