/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.experimental;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.aksw.facete.v3.api.AliasedPath;
import org.aksw.facete.v3.api.AliasedPathImpl;
import org.aksw.facete.v3.api.path.Resolver;
import org.aksw.facete.v3.api.path.ResolverBase;
import org.aksw.facete.v3.experimental.PathAccessorAliasedPath;
import org.aksw.jena_sparql_api.data_query.impl.PathToRelationMapper;
import org.aksw.jena_sparql_api.data_query.impl.QueryFragment;
import org.aksw.jena_sparql_api.relationlet.RelationletBinary;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.arq.util.var.Vars;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.aksw.jenax.sparql.fragment.api.Fragment3;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.sparql.fragment.impl.Fragment2Impl;
import org.aksw.jenax.sparql.fragment.impl.Fragment3Impl;
import org.aksw.jenax.sparql.relation.query.PartitionedQuery1;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.path.P_Path0;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;

public class ResolverData
extends ResolverBase {
    protected Resolver parent;
    protected Fragment2 reachingRelation;
    protected AliasedPath path;
    protected PartitionedQuery1 query;

    public ResolverData(Resolver parent, PartitionedQuery1 query, AliasedPath path, Fragment2 reachingRelation) {
        super(parent);
        this.query = query;
        this.path = path;
        this.reachingRelation = reachingRelation;
    }

    public Collection<RelationletBinary> getReachingRelationlet() {
        PathToRelationMapper<AliasedPath> mapper = this.createPathMapper();
        Fragment2 tmp = mapper.getOverallRelation(this.path);
        Fragment2 result = mapper.getMap().get(this.path);
        return Collections.singleton(new RelationletBinary(result));
    }

    public PathToRelationMapper<AliasedPath> createPathMapper() {
        Var var = this.query.getPartitionVar();
        String pathName = "path";
        String baseName = var.getName() + "_" + pathName;
        PathAccessorAliasedPath pathAccessor = new PathAccessorAliasedPath();
        PathToRelationMapper<AliasedPath> mapper = new PathToRelationMapper<AliasedPath>(pathAccessor, baseName);
        Fragment2Impl tmp = this.reachingRelation == null ? new Fragment2Impl((Element)new ElementGroup(), var, var) : this.reachingRelation;
        mapper.getMap().put(AliasedPathImpl.empty(), (Fragment2)tmp);
        return mapper;
    }

    public Fragment2 getPath() {
        PathToRelationMapper<AliasedPath> mapper = this.createPathMapper();
        Fragment2 result = mapper.getOverallRelation(this.path);
        return result;
    }

    public Collection<Fragment2> getPaths() {
        Fragment2 pathRelation = this.getPath();
        return Collections.singleton(pathRelation);
    }

    public Resolver resolve(P_Path0 step, String alias) {
        AliasedPath subPath = (AliasedPath)this.path.subPath((Object)Maps.immutableEntry((Object)step, (Object)alias));
        return new ResolverData((Resolver)this, this.query, subPath, this.reachingRelation);
    }

    public static Fragment3 createRelation(boolean isFwd, Var s, Var p, Var o) {
        Triple t = QueryFragment.createTriple(!isFwd, (Node)s, (Node)p, (Node)o);
        Fragment3Impl result = new Fragment3Impl((Element)ElementUtils.createElement((Triple)t), s, p, o);
        return result;
    }

    public Collection<Fragment3> getRdfGraphSpec(boolean isFwd) {
        Element basePattern = this.query.getQuery().getQueryPattern();
        Var baseVar = this.query.getPartitionVar();
        Concept baseConcept = new Concept(basePattern, baseVar);
        Fragment2 pathRelation = this.getPath();
        Fragment2 pathRelationWithConcept = pathRelation.prependOn(new Var[]{pathRelation.getSourceVar()}).with((Fragment1)baseConcept).toFragment2();
        Fragment3 tr = ResolverData.createRelation(isFwd, Vars.s, Vars.p, Vars.o);
        Fragment3 result = tr.prependOn(new Var[]{tr.getS()}).with((Fragment)pathRelationWithConcept, new Var[]{pathRelationWithConcept.getTargetVar()}).toFragment3();
        return Arrays.asList(result);
    }
}

