/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.base.Converter;
import com.google.common.collect.Maps;
import com.google.common.collect.Streams;
import java.io.OutputStream;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.aksw.commons.collections.maps.MapFromValueConverter;
import org.aksw.facete.v3.api.FacetConstraint;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.impl.HLFacetConstraintImpl;
import org.aksw.jena_sparql_api.rdf.collections.ConverterFromNodeMapper;
import org.aksw.jena_sparql_api.rdf.collections.ConverterFromNodeMapperAndModel;
import org.aksw.jena_sparql_api.rdf.collections.NodeConverter;
import org.aksw.jena_sparql_api.rdf.collections.NodeMappers;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.utils.views.map.MapFromKeyConverter;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResource;
import org.aksw.jena_sparql_api.utils.views.map.MapVocab;
import org.aksw.jenax.arq.util.node.NodeTransformCollectNodes;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Node_Variable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFFormat;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.E_LogicalOr;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformer;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformExpr;
import org.apache.jena.sparql.util.ExprUtils;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class FacetConstraintImpl
extends ResourceImpl
implements FacetConstraint {
    public FacetConstraintImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public boolean enabled() {
        return ResourceUtils.tryGetLiteralPropertyValue((Resource)this, (Property)Vocab.enabled, Boolean.class).orElse(true);
    }

    public FacetConstraint enabled(boolean onOrOff) {
        if (onOrOff) {
            ResourceUtils.setLiteralProperty((Resource)this, (Property)Vocab.enabled, null);
        } else {
            ResourceUtils.setLiteralProperty((Resource)this, (Property)Vocab.enabled, (Object)onOrOff);
        }
        return this;
    }

    public Expr expr() {
        String str = ResourceUtils.tryGetLiteralPropertyValue((Resource)this, (Property)Vocab.expr, String.class).orElse(null);
        Expr result = ExprUtils.parse((String)str);
        Map<Integer, Node> decoder = this.getBnodeMap();
        result = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(x -> {
            Integer id = FacetConstraintImpl.tryGetBnodeAsInt(x);
            Node r = decoder.getOrDefault(id, (Node)x);
            return r;
        }), (Expr)result);
        return result;
    }

    public static Integer tryGetBnodeAsInt(Node n) {
        String str;
        Integer result = null;
        if (n.isVariable() && (str = n.getName()).matches("\\d+")) {
            result = Integer.parseInt(str);
        }
        return result;
    }

    public Map<Integer, Node> getBnodeMap() {
        MapFromResource rawMap = new MapFromResource((Resource)this, Vocab.mapping, MapVocab.key, MapVocab.value);
        Model model = this.getModel();
        MapFromKeyConverter tmpMap = new MapFromKeyConverter((Map)rawMap, (Converter)new ConverterFromNodeMapperAndModel(model, RDFNode.class, (Converter)new ConverterFromNodeMapper((NodeConverter)NodeMappers.from(Integer.class))));
        MapFromValueConverter result = new MapFromValueConverter((Map)tmpMap, (Converter)new ConverterFromNodeMapperAndModel(model, RDFNode.class, (Converter)new ConverterFromNodeMapper((NodeConverter)NodeMappers.PASSTHROUGH)));
        return result;
    }

    public static Node varToBlankNode(Node node) {
        return Optional.of(node).filter(Node::isVariable).map(y -> (Var)y).map(Node_Variable::getName).filter(n -> n.startsWith("___")).map(n -> n.substring(3).replace("_", "-")).map(NodeFactory::createBlankNode).orElse(node);
    }

    public static Node blankNodeToVar(Node node) {
        return !node.isBlank() ? node : Var.alloc((String)("___" + node.getBlankNodeLabel().replace("-", "_")));
    }

    public FacetConstraint expr(Expr expr) {
        NodeTransformCollectNodes collector = new NodeTransformCollectNodes();
        Set nodes = collector.getNodes();
        ExprTransformer.transform((ExprTransform)new NodeTransformExpr((NodeTransform)collector), (Expr)expr);
        Map<Integer, Node> bnodeToInt = Streams.zip(nodes.stream().filter(Node::isBlank), IntStream.range(0, Integer.MAX_VALUE).boxed(), (v, i) -> Maps.immutableEntry((Object)i, (Object)v)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<Node, Node> encoder = bnodeToInt.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, e -> Var.alloc((String)Objects.toString(e.getKey()))));
        Expr effectiveExpr = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(x -> encoder.getOrDefault(x, (Node)x)), (Expr)expr);
        Map<Integer, Node> mapView = this.getBnodeMap();
        mapView.clear();
        mapView.putAll(bnodeToInt);
        String str = ExprUtils.fmtSPARQL((Expr)effectiveExpr);
        ResourceUtils.setLiteralProperty((Resource)this, (Property)Vocab.expr, (Object)str);
        return this;
    }

    public FacetConstraint exprOld(Expr expr) {
        expr = ExprTransformer.transform((ExprTransform)new NodeTransformExpr(FacetConstraintImpl::blankNodeToVar), (Expr)expr);
        String str = ExprUtils.fmtSPARQL((Expr)expr);
        ResourceUtils.setLiteralProperty((Resource)this, (Property)Vocab.expr, (Object)str);
        return this;
    }

    public String toString() {
        Expr expr = this.expr();
        Map<Node, BgpNode> map = HLFacetConstraintImpl.mentionedBgpNodes(this.getModel(), expr);
        Expr e = org.aksw.jenax.arq.util.expr.ExprUtils.applyNodeTransform((Expr)expr, n -> {
            BgpNode fn = (BgpNode)map.get(n);
            Node r = fn != null ? NodeFactory.createLiteral((String)("[" + String.valueOf(fn) + "]")) : n;
            return r;
        });
        String result = ExprUtils.fmtSPARQL((Expr)e);
        return result;
    }

    public static void main(String[] args) {
        Model m = ModelFactory.createDefaultModel();
        Resource b1 = m.createResource();
        Resource b2 = m.createResource();
        Resource b3 = m.createResource();
        b1.addProperty(RDF.type, (RDFNode)RDFS.Resource);
        b2.addProperty(RDF.type, (RDFNode)RDFS.Resource);
        b3.addProperty(RDF.type, (RDFNode)RDFS.Resource);
        Resource iri = m.createResource("http://www.example.org/test");
        E_LogicalOr e1 = new E_LogicalOr((Expr)NodeValue.makeNode((Node)b1.asNode()), (Expr)new E_LogicalOr((Expr)NodeValue.makeNode((Node)b2.asNode()), (Expr)NodeValue.makeNode((Node)iri.asNode())));
        FacetConstraint c = (FacetConstraint)m.createResource().as(FacetConstraint.class);
        c.expr((Expr)e1);
        NodeValue e2 = NodeValue.makeNode((Node)b3.asNode());
        c.expr((Expr)e2);
        RDFDataMgr.write((OutputStream)System.out, (Model)m, (RDFFormat)RDFFormat.TURTLE_FLAT);
    }

    public void unlink() {
    }
}

