/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import com.google.common.collect.Range;
import java.util.Optional;
import javax.persistence.Entity;
import org.aksw.commons.util.range.CountInfo;
import org.aksw.facete.v3.api.FacetValueCount;
import org.aksw.jena_sparql_api.data_query.impl.CountUtils;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.utils.views.map.MapVocab;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

@Entity
public class FacetValueCountImpl
extends ResourceImpl
implements FacetValueCount {
    public FacetValueCountImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public Node getPredicate() {
        return ResourceUtils.tryGetPropertyValue((Resource)this, (Property)Vocab.predicate).map(FrontsNode::asNode).orElse(null);
    }

    public Node getValue() {
        return ResourceUtils.tryGetPropertyValue((Resource)this, (Property)MapVocab.value).map(FrontsNode::asNode).orElse(null);
    }

    public CountInfo getFocusCount() {
        Long min;
        Long max = min = (Long)Optional.ofNullable(this.getProperty(Vocab.facetCount)).map(Statement::getLong).orElse(null);
        if (min == null) {
            throw new RuntimeException("Should not happen");
        }
        Range range = max == null ? Range.atLeast((Comparable)min) : Range.closed((Comparable)min, (Comparable)max);
        CountInfo result = CountUtils.toCountInfo((Range<Long>)range);
        return result;
    }

    public String toString() {
        return "FacetValueCountImpl [" + String.valueOf(this.getPredicate()) + ": " + String.valueOf(this.getValue()) + ": " + String.valueOf(this.getFocusCount()) + "]";
    }
}

