/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.api;

import org.aksw.commons.collections.trees.TreeUtils;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetPathOps;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.path.core.HasFacetPath;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Resource;

public interface FacetTraversable<T extends FacetTraversable<T>>
extends HasFacetPath {
    public T getOrCreateChild(FacetStep var1);

    public T getParent();

    default public T getRootNode() {
        return (T)((FacetTraversable)TreeUtils.getRoot((Object)this, FacetTraversable::getParent));
    }

    default public T resolve(FacetPath facetPath) {
        return (T)FacetTraversable.resolve(this, facetPath);
    }

    default public T fwd(String property) {
        return this.getOrCreateChild(FacetStep.fwd((String)property));
    }

    default public T fwd(Node property) {
        return this.getOrCreateChild(FacetStep.fwd((Node)property));
    }

    default public T fwd(Resource property) {
        return this.getOrCreateChild(FacetStep.fwd((Resource)property));
    }

    default public T bwd(String property) {
        return this.getOrCreateChild(FacetStep.bwd((String)property));
    }

    default public T bwd(Node property) {
        return this.getOrCreateChild(FacetStep.bwd((Node)property));
    }

    default public T bwd(Resource property) {
        return this.getOrCreateChild(FacetStep.bwd((Resource)property));
    }

    public static <T extends FacetTraversable<T>> T resolve(T node, FacetPath facetPath) {
        T tmp = facetPath.isAbsolute() ? node.getRootNode() : node;
        for (FacetStep step : facetPath.getSegments()) {
            if (FacetPathOps.PARENT.equals((Object)step)) {
                tmp = tmp.getParent();
                continue;
            }
            if (FacetPathOps.SELF.equals((Object)step)) continue;
            tmp = tmp.getOrCreateChild(step);
        }
        return tmp;
    }
}

