/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v4.impl;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import org.aksw.commons.path.core.Path;
import org.aksw.facete.v4.impl.FacetedRelationQuery;
import org.aksw.jenax.arq.util.node.NodeCustom;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.apache.jena.sparql.expr.Expr;

public class ElementGeneratorUtils {
    public static SetMultimap<FacetPath, Expr> indexConstraints(Collection<Expr> constraints) {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Expr expr : constraints) {
            Set paths = NodeCustom.mentionedValues(FacetPath.class, (Expr)expr);
            for (FacetPath path : paths) {
                result.put((Object)path, (Object)expr);
            }
        }
        return result;
    }

    public static <P> SetMultimap<P, Expr> hideConstraintsForPath(SetMultimap<P, Expr> constaintIndex, P path) {
        SetMultimap result = Multimaps.filterKeys(constaintIndex, k -> !Objects.equals(k, path));
        return result;
    }

    public static FacetPath cleanPath(FacetPath path) {
        FacetStep step;
        FacetPath firstLink = path.getNameCount() > 0 ? (FacetPath)path.getName(0) : null;
        FacetPath result = path;
        if (firstLink != null && (step = (FacetStep)firstLink.toSegment()).getNode().equals((Object)FacetedRelationQuery.INITIAL_VAR)) {
            result = (FacetPath)firstLink.relativize((Path)path);
        }
        return result;
    }
}

