/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.bgp.impl;

import com.google.common.base.Converter;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.aksw.commons.collections.maps.MapFromValueConverter;
import org.aksw.commons.collections.trees.TreeUtils;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.bgp.api.BgpDirNode;
import org.aksw.facete.v3.bgp.api.BgpMultiNode;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.bgp.impl.BgpDirNodeImpl;
import org.aksw.facete.v3.bgp.impl.BgpNodeUtils;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jena_sparql_api.rdf.collections.SetFromPropertyValues;
import org.aksw.jena_sparql_api.utils.views.map.MapFromKeyConverter;
import org.aksw.jena_sparql_api.utils.views.map.MapFromResourceUnmanaged;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.sparql.core.Var;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class BgpNodeImpl
extends ResourceImpl
implements BgpNode {
    public BgpNodeImpl(Node n, EnhGraph m) {
        super(n, m);
    }

    public Map<Resource, BgpMultiNode> createMap(Property p) {
        MapFromResourceUnmanaged map = new MapFromResourceUnmanaged((Resource)this, p, Vocab.property);
        MapFromKeyConverter m = new MapFromKeyConverter((Map)map, Converter.from(r -> (Resource)r.as(Resource.class), RDFNode::asResource));
        MapFromValueConverter result = new MapFromValueConverter((Map)m, Converter.from(r -> (BgpMultiNode)r.as(BgpMultiNode.class), RDFNode::asResource));
        return result;
    }

    public Map<Resource, BgpMultiNode> fwdMultiNodes() {
        Map<Resource, BgpMultiNode> result = this.createMap(Vocab.fwd);
        return result;
    }

    public Map<Resource, BgpMultiNode> bwdMultiNodes() {
        Map<Resource, BgpMultiNode> result = this.createMap(Vocab.bwd);
        return result;
    }

    public BgpDirNode fwd() {
        return new BgpDirNodeImpl(this, true);
    }

    public BgpDirNode bwd() {
        return new BgpDirNodeImpl(this, false);
    }

    public BgpNode as(String varName) {
        ResourceUtils.setLiteralProperty((Resource)this, (Property)Vocab.alias, (Object)varName);
        return this;
    }

    public String alias() {
        String result = ResourceUtils.tryGetLiteralPropertyValue((Resource)this, (Property)Vocab.alias, String.class).orElse(null);
        return result;
    }

    public BgpNode root() {
        BgpNode result = (BgpNode)TreeUtils.findRoot((Object)((Object)this), n -> Optional.ofNullable(n.parent()).map(BgpMultiNode::parent).orElse(null));
        return result;
    }

    public BgpNode as(Var var) {
        return this.as(var == null ? null : var.getName());
    }

    public BgpMultiNode parent() {
        BgpMultiNode result = (BgpMultiNode)ResourceUtils.getReversePropertyValue((Resource)this, (Property)Vocab.child, BgpMultiNode.class);
        return result;
    }

    public BgpNode chRoot() {
        BgpNodeImpl.turnParentToChild(this);
        return this;
    }

    public static void turnParentToChild(BgpNode start) {
        BgpMultiNode pmn = start.parent();
        if (pmn != null) {
            Direction dir = pmn.getDirection();
            Property prop = pmn.reachingProperty();
            SetFromPropertyValues parentOne = new SetFromPropertyValues((Resource)pmn, Vocab.one, BgpNode.class);
            SetFromPropertyValues parentChildren = new SetFromPropertyValues((Resource)pmn, Vocab.child, BgpNode.class);
            parentOne.remove(start);
            parentChildren.remove(start);
            BgpNode pn = pmn.parent();
            BgpNodeImpl.turnParentToChild(pn);
            switch (dir) {
                case FORWARD: {
                    Map fwdMap = pn.fwdMultiNodes();
                    Map bwdMap = start.bwdMultiNodes();
                    BgpMultiNode toMerge = (BgpMultiNode)fwdMap.get(prop);
                    if (!toMerge.equals(pmn)) {
                        throw new RuntimeException("Sanity check failed");
                    }
                    fwdMap.remove(prop);
                    BgpMultiNode existing = (BgpMultiNode)bwdMap.get(prop);
                    if (existing != null) {
                        existing.children().addAll(pmn.children());
                        SetFromPropertyValues existingOnes = new SetFromPropertyValues((Resource)existing, Vocab.one, BgpNode.class);
                        if (existingOnes.isEmpty()) {
                            BgpNode priorOne = pmn.one();
                            if (priorOne != null) {
                                existingOnes.add(priorOne);
                            }
                        } else {
                            parentOne.clear();
                        }
                        pmn.children().clear();
                        pmn.removeAll(Vocab.property);
                        Set stmts = ResourceUtils.listReverseProperties((RDFNode)pmn, null).andThen((Iterator)pmn.listProperties()).toSet();
                        if (!stmts.isEmpty()) {
                            throw new RuntimeException("Sanity check failed - expected empty set but got: " + String.valueOf(stmts));
                        }
                    } else {
                        BgpNode pmnParent = pmn.parent();
                        if (pmnParent == null) {
                            bwdMap.put(prop, pmn);
                        } else {
                            BgpMultiNode newPmn = (BgpMultiNode)start.getModel().createResource().as(BgpMultiNode.class);
                            bwdMap.put(prop, newPmn);
                        }
                    }
                    BgpMultiNode mn = (BgpMultiNode)bwdMap.get(prop);
                    mn.children().add(pn);
                    break;
                }
                case BACKWARD: {
                    Map bwdMap = pn.bwdMultiNodes();
                    Map fwdMap = start.fwdMultiNodes();
                    BgpMultiNode toMerge = (BgpMultiNode)bwdMap.get(prop);
                    if (!toMerge.equals(pmn)) {
                        throw new RuntimeException("Sanity check failed");
                    }
                    BgpMultiNode existing = (BgpMultiNode)fwdMap.get(prop);
                    if (existing != null) {
                        existing.children().addAll(pmn.children());
                        SetFromPropertyValues existingOnes = new SetFromPropertyValues((Resource)existing, Vocab.one, BgpNode.class);
                        if (existingOnes.isEmpty()) {
                            BgpNode priorOne = pmn.one();
                            if (priorOne != null) {
                                existingOnes.add(priorOne);
                            }
                        } else {
                            parentOne.clear();
                        }
                        pmn.children().clear();
                        pmn.removeAll(Vocab.property);
                        Set stmts = ResourceUtils.listReverseProperties((RDFNode)pmn, null).andThen((Iterator)pmn.listProperties()).toSet();
                        if (!stmts.isEmpty()) {
                            throw new RuntimeException("Sanity check failed - expected empty set but got: " + String.valueOf(stmts));
                        }
                    } else {
                        BgpNode pmnParent = pmn.parent();
                        if (pmnParent == null) {
                            fwdMap.put(prop, pmn);
                        } else {
                            BgpMultiNode newPmn = (BgpMultiNode)start.getModel().createResource().as(BgpMultiNode.class);
                            fwdMap.put(prop, newPmn);
                        }
                    }
                    BgpMultiNode mn = (BgpMultiNode)fwdMap.get(prop);
                    mn.children().add(pn);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    public String toString() {
        return String.valueOf(BgpNodeUtils.toSimplePath(this)) + "; " + super.toString();
    }
}

