/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.api;

import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import org.aksw.facete.v4.impl.PropertyResolverImpl;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.HasSlice;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.api.QueryContext;
import org.aksw.jenax.facete.treequery2.impl.FacetConstraints;
import org.aksw.jenax.facete.treequery2.impl.Partition;
import org.aksw.jenax.facete.treequery2.impl.QueryContextImpl;
import org.aksw.jenax.facete.treequery2.impl.RelationQueryImpl;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.sparql.fragment.impl.Concept;
import org.aksw.jenax.treequery2.old.NodeQueryOld;
import org.apache.jena.graph.Node;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;

public interface RelationQuery
extends HasSlice {
    public String getScopeBaseName();

    public NodeQuery getParentNode();

    public FacetStep getReachingStep();

    default public RelationQuery root() {
        NodeQuery parentNode = this.getParentNode();
        RelationQuery r = parentNode == null ? this : parentNode.relationQuery().root();
        return r;
    }

    public List<SortCondition> getSortConditions();

    public Fragment getRelation();

    public QueryContext getContext();

    public Partition partition();

    public FacetConstraints<ConstraintNode<NodeQuery>> getFacetConstraints();

    public void partitionBy(NodeQueryOld ... var1);

    public NodeQueryOld asNode();

    public FacetPath getPath();

    public List<NodeQuery> roots();

    public NodeQuery source();

    public NodeQuery target();

    public NodeQuery predicate();

    public NodeQuery nodeFor(Var var1);

    public static RelationQuery of(Var startVar) {
        return RelationQuery.of(() -> new Concept((Element)new ElementGroup(), startVar));
    }

    public static RelationQuery of(Fragment relation) {
        return RelationQuery.of(() -> relation);
    }

    public static RelationQuery of(Supplier<Fragment> relation) {
        return RelationQuery.of(relation, new QueryContextImpl(new PropertyResolverImpl()));
    }

    public static RelationQuery of(Supplier<Fragment> relation, QueryContext queryContext) {
        String scopeBaseName = (String)queryContext.getScopeNameGenerator().next();
        return new RelationQueryImpl(scopeBaseName, null, relation, null, queryContext, new HashMap<Var, Node>());
    }

    public static void doSort(RelationQuery relationQuery, Expr expr, int sortDirection) {
        SortCondition sc = new SortCondition(expr, sortDirection);
        List<SortCondition> sortConditions = relationQuery.getSortConditions();
        int idx = IntStream.range(0, sortConditions.size()).filter(i -> ((SortCondition)sortConditions.get(i)).getExpression().equals((Object)expr)).findFirst().orElse(-1);
        if (idx < 0) {
            if (sortDirection != -3) {
                sortConditions.add(sc);
            }
        } else if (sortDirection == -3) {
            sortConditions.remove(idx);
        } else {
            sortConditions.set(idx, sc);
        }
    }

    public static int getSortDirection(RelationQuery relationQuery, Expr expr) {
        int result = relationQuery.getSortConditions().stream().filter(sc -> sc.getExpression().equals((Object)expr)).map(SortCondition::getDirection).findFirst().orElse(-3);
        return result;
    }
}

