/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.facete.v3.impl;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.aksw.commons.collections.trees.TreeUtils;
import org.aksw.facete.v3.api.ConstraintFacade;
import org.aksw.facete.v3.api.Direction;
import org.aksw.facete.v3.api.FacetDirNode;
import org.aksw.facete.v3.api.FacetNode;
import org.aksw.facete.v3.api.FacetNodeResource;
import org.aksw.facete.v3.api.FacetedDataQuery;
import org.aksw.facete.v3.api.FacetedQueryResource;
import org.aksw.facete.v3.bgp.api.BgpMultiNode;
import org.aksw.facete.v3.bgp.api.BgpNode;
import org.aksw.facete.v3.bgp.impl.BgpNodeUtils;
import org.aksw.facete.v3.bgp.utils.PathAccessorImpl;
import org.aksw.facete.v3.impl.ConstraintFacadeImpl;
import org.aksw.facete.v3.impl.FacetDirNodeImpl;
import org.aksw.facete.v3.impl.FacetedDataQueryImpl;
import org.aksw.jena_sparql_api.data_query.api.PathAccessor;
import org.aksw.jena_sparql_api.data_query.impl.FacetedQueryGenerator;
import org.aksw.jena_sparql_api.rdf.collections.ResourceUtils;
import org.aksw.jenax.sparql.fragment.api.Fragment1;
import org.aksw.jenax.sparql.fragment.api.Fragment2;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Var;
import org.hobbit.benchmark.faceted_browsing.v2.domain.Vocab;

public class FacetNodeImpl
implements FacetNodeResource {
    protected FacetedQueryResource query;
    protected BgpNode state;

    public FacetNodeImpl(FacetedQueryResource query, BgpNode state) {
        this.query = query;
        this.state = Objects.requireNonNull(state);
    }

    public FacetNodeResource parent() {
        BgpNode p = Optional.ofNullable(this.state.parent()).map(BgpMultiNode::parent).orElse(null);
        return p == null ? null : new FacetNodeImpl(this.query, p);
    }

    public FacetedQueryResource query() {
        return this.query;
    }

    public BgpNode state() {
        return this.state;
    }

    public FacetDirNode fwd() {
        return new FacetDirNodeImpl(this, this.state.fwd());
    }

    public FacetDirNode bwd() {
        return new FacetDirNodeImpl(this, this.state.bwd());
    }

    public Fragment2 getReachingRelation() {
        Fragment2 result = BgpNode.getReachingRelation((BgpNode)this.state);
        return result;
    }

    public boolean isReverse() {
        boolean isReverse = false;
        Set set = ResourceUtils.listProperties((Resource)this.parent().state()).filterKeep(stmt -> stmt.getObject().equals(this.state)).toSet();
        if (set.isEmpty()) {
            isReverse = true;
        }
        return isReverse;
    }

    public FacetedDataQuery<RDFNode> createValueQuery(boolean applySelfConstraints) {
        FacetedQueryGenerator<BgpNode> qgen = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl(this.state.getModel()));
        qgen.setBaseConcept(this.query().baseConcept());
        this.query.constraints().forEach(c -> qgen.addConstraint(c.expr()));
        BgpNode focus = this.query().focus().state();
        Fragment1 c2 = qgen.getConceptForAtPath(focus, this.state, applySelfConstraints);
        SparqlQueryConnection conn = this.query.connection();
        FacetedDataQueryImpl<RDFNode> result = new FacetedDataQueryImpl<RDFNode>(conn, c2.getElement(), c2.getVar(), null, RDFNode.class);
        return result;
    }

    public FacetedDataQuery<RDFNode> availableValues() {
        FacetedDataQuery<RDFNode> result = this.createValueQuery(false);
        return result;
    }

    public FacetedDataQuery<RDFNode> remainingValues() {
        FacetedDataQuery<RDFNode> result = this.createValueQuery(true);
        return result;
    }

    public FacetNode as(String varName) {
        ResourceUtils.setLiteralProperty((Resource)this.state, (Property)Vocab.alias, (Object)varName);
        return this;
    }

    public FacetNode as(Var var) {
        return this.as(var.getName());
    }

    public Var alias() {
        return ResourceUtils.tryGetLiteralPropertyValue((Resource)this.state, (Property)Vocab.alias, String.class).map(Var::alloc).orElse(null);
    }

    public FacetNode root() {
        FacetNode result = (FacetNode)TreeUtils.findRoot((Object)this, FacetNode::parent);
        return result;
    }

    public ConstraintFacade<? extends FacetNodeResource> enterConstraints() {
        return new ConstraintFacadeImpl<FacetNodeImpl>(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.query == null ? 0 : this.query.hashCode());
        result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FacetNodeImpl other = (FacetNodeImpl)obj;
        if (this.query == null ? other.query != null : !this.query.equals(other.query)) {
            return false;
        }
        return !(this.state == null ? other.state != null : !this.state.equals(other.state));
    }

    public String toString() {
        String result;
        boolean pathMode = true;
        if (pathMode) {
            result = String.valueOf(BgpNodeUtils.toSimplePath(this.state));
        } else {
            FacetedQueryGenerator<BgpNode> qgen = new FacetedQueryGenerator<BgpNode>((PathAccessor<BgpNode>)new PathAccessorImpl(this.state.getModel()));
            this.query.constraints().forEach(c -> qgen.addConstraint(c.expr()));
            Fragment1 c2 = qgen.getConceptForAtPath(this.query.focus().state(), this.state, false);
            result = this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + "{" + String.valueOf(c2) + "}";
        }
        return result;
    }

    public FacetNode chRoot() {
        this.state.chRoot();
        FacetedQueryResource query = this.query();
        ResourceUtils.setProperty((Resource)query.modelRoot(), (Property)Vocab.root, (RDFNode)this.state);
        return this;
    }

    public FacetNode chFocus() {
        this.query.focus((FacetNode)this);
        return this;
    }

    public Node reachingPredicate() {
        BgpMultiNode parent = this.state.parent();
        Node result = parent == null ? null : parent.reachingProperty().asNode();
        return result;
    }

    public Direction reachingDirection() {
        BgpMultiNode parent = this.state.parent();
        Direction result = parent == null ? null : parent.getDirection();
        return result;
    }

    public String reachingAlias() {
        return null;
    }

    public Node targetComponent() {
        return null;
    }
}

