/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.facete.treequery2.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.aksw.jenax.facete.treequery2.api.ConstraintNode;
import org.aksw.jenax.facete.treequery2.api.HasSlice;
import org.aksw.jenax.facete.treequery2.api.NodeQuery;
import org.aksw.jenax.facete.treequery2.api.QueryContext;
import org.aksw.jenax.facete.treequery2.api.RelationQuery;
import org.aksw.jenax.facete.treequery2.impl.FacetConstraints;
import org.aksw.jenax.facete.treequery2.impl.FacetRelationUtils;
import org.aksw.jenax.facete.treequery2.impl.NodeQueryImpl;
import org.aksw.jenax.facete.treequery2.impl.Partition;
import org.aksw.jenax.path.core.FacetPath;
import org.aksw.jenax.path.core.FacetStep;
import org.aksw.jenax.sparql.fragment.api.Fragment;
import org.aksw.jenax.treequery2.old.NodeQueryOld;
import org.apache.jena.graph.Node;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.core.Var;

public class RelationQueryImpl
implements RelationQuery {
    protected String scopeBaseName;
    protected Supplier<Fragment> relationSupplier;
    protected QueryContext queryContext;
    protected NodeQuery parent;
    protected Long offset;
    protected Long limit;
    protected FacetStep reachingStep;
    protected Map<Var, Node> varToComponent;
    protected FacetConstraints<ConstraintNode<NodeQuery>> facetConstraints;
    protected List<SortCondition> sortConditions = new ArrayList<SortCondition>();
    protected Map<Var, NodeQuery> roots = new LinkedHashMap<Var, NodeQuery>();

    public RelationQueryImpl(String scopeBaseName, NodeQuery parent, Supplier<Fragment> relationSupplier, FacetStep reachingStep, QueryContext queryContext, Map<Var, Node> varToComponent) {
        this.scopeBaseName = scopeBaseName;
        this.parent = parent;
        this.relationSupplier = relationSupplier;
        this.queryContext = queryContext;
        this.reachingStep = reachingStep;
        this.varToComponent = varToComponent;
        this.facetConstraints = new FacetConstraints(ConstraintNode.class);
    }

    @Override
    public String getScopeBaseName() {
        return this.scopeBaseName;
    }

    @Override
    public NodeQuery getParentNode() {
        return this.parent;
    }

    @Override
    public Fragment getRelation() {
        return this.relationSupplier.get();
    }

    @Override
    public List<SortCondition> getSortConditions() {
        return this.sortConditions;
    }

    @Override
    public FacetConstraints<ConstraintNode<NodeQuery>> getFacetConstraints() {
        return this.facetConstraints;
    }

    @Override
    public Long offset() {
        return this.offset;
    }

    @Override
    public RelationQuery offset(Long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public Long limit() {
        return this.limit;
    }

    @Override
    public HasSlice limit(Long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public NodeQueryOld asNode() {
        throw new UnsupportedOperationException();
    }

    @Override
    public FacetPath getPath() {
        throw new UnsupportedOperationException("not implemented");
    }

    protected NodeQuery newRoot(Var var) {
        Node component = this.varToComponent.get(var);
        FacetStep step = component == null ? null : this.reachingStep.copyStep(component);
        NodeQueryImpl result = new NodeQueryImpl(this, var, step);
        return result;
    }

    @Override
    public List<NodeQuery> roots() {
        Fragment relation = this.relationSupplier.get();
        List vars = relation.getVars();
        List<NodeQuery> result = vars.stream().map(var -> this.roots.computeIfAbsent((Var)var, this::newRoot)).collect(Collectors.toList());
        return result;
    }

    @Override
    public NodeQuery nodeFor(Var var) {
        Fragment relation = this.relationSupplier.get();
        List vars = relation.getVars();
        if (!vars.contains(var)) {
            throw new NoSuchElementException("Requested a node for variable " + String.valueOf(var) + " but this one does not exist. Available: " + String.valueOf(vars));
        }
        NodeQuery result = this.roots.computeIfAbsent(var, this::newRoot);
        return result;
    }

    @Override
    public QueryContext getContext() {
        return this.queryContext;
    }

    @Override
    public Partition partition() {
        return null;
    }

    @Override
    public void partitionBy(NodeQueryOld ... paths) {
    }

    protected NodeQuery resolveComponent(Node component) {
        Var var = FacetRelationUtils.resolveComponent(component, this.getRelation());
        NodeQuery result = this.nodeFor(var);
        return result;
    }

    @Override
    public FacetStep getReachingStep() {
        return this.reachingStep;
    }

    @Override
    public NodeQuery source() {
        return this.resolveComponent((Node)FacetStep.SOURCE);
    }

    @Override
    public NodeQuery target() {
        return this.resolveComponent((Node)FacetStep.TARGET);
    }

    @Override
    public NodeQuery predicate() {
        return this.resolveComponent((Node)FacetStep.PREDICATE);
    }
}

